/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.api.annotation.Beta;
import co.cask.cdap.api.service.ServiceSpecification;
import co.cask.cdap.api.service.http.HttpServiceHandlerSpecification;
import co.cask.cdap.api.service.http.ServiceHttpEndpoint;
import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.NotFoundException;
import co.cask.cdap.common.ServiceUnavailableException;
import co.cask.cdap.common.UnauthenticatedException;
import co.cask.cdap.proto.Id;
import co.cask.cdap.proto.id.EntityId;
import co.cask.cdap.proto.id.ProgramId;
import co.cask.cdap.proto.id.ServiceId;
import co.cask.cdap.security.spi.authorization.UnauthorizedException;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpRequest;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;

@Beta
public class ServiceClient {
    private static final Gson GSON = new Gson();
    private static final Type MAP_STRING_INTEGER_TYPE = new TypeToken<Map<String, Integer>>(){}.getType();
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public ServiceClient(ClientConfig config, RESTClient restClient) {
        this.config = config;
        this.restClient = restClient;
    }

    public ServiceClient(ClientConfig config) {
        this(config, new RESTClient(config));
    }

    @Deprecated
    public ServiceSpecification get(Id.Service service) throws IOException, UnauthenticatedException, NotFoundException, UnauthorizedException {
        return this.get((ProgramId)service.toEntityId());
    }

    public ServiceSpecification get(ProgramId service) throws IOException, UnauthenticatedException, NotFoundException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(service.getNamespaceId(), String.format("apps/%s/versions/%s/services/%s", service.getApplication(), service.getVersion(), service.getProgram()));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((EntityId)service);
        }
        return (ServiceSpecification)ObjectResponse.fromJsonBody((HttpResponse)response, ServiceSpecification.class).getResponseObject();
    }

    @Deprecated
    public List<ServiceHttpEndpoint> getEndpoints(Id.Service service) throws IOException, UnauthenticatedException, NotFoundException, UnauthorizedException {
        return this.getEndpoints(service.toEntityId());
    }

    public List<ServiceHttpEndpoint> getEndpoints(ServiceId service) throws IOException, UnauthenticatedException, NotFoundException, UnauthorizedException {
        ServiceSpecification specification = this.get((ProgramId)service);
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (HttpServiceHandlerSpecification handlerSpecification : specification.getHandlers().values()) {
            builder.addAll((Iterable)handlerSpecification.getEndpoints());
        }
        return builder.build();
    }

    @Deprecated
    public void checkAvailability(Id.Service service) throws IOException, UnauthenticatedException, NotFoundException, ServiceUnavailableException, UnauthorizedException {
        this.checkAvailability(service.toEntityId());
    }

    public void checkAvailability(ServiceId service) throws IOException, UnauthenticatedException, NotFoundException, ServiceUnavailableException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(service.getNamespaceId(), String.format("apps/%s/versions/%s/services/%s/available", service.getApplication(), service.getVersion(), service.getProgram()));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404, 400, 503);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((EntityId)service);
        }
        if (response.getResponseCode() == 503) {
            throw new ServiceUnavailableException(service.getProgram());
        }
    }

    public URL getServiceURL(Id.Service service) throws NotFoundException, IOException, UnauthenticatedException, UnauthorizedException {
        return this.getServiceURL(service.toEntityId());
    }

    public URL getVersionedServiceURL(ServiceId service) throws NotFoundException, IOException, UnauthenticatedException, UnauthorizedException {
        this.get((ProgramId)service);
        return this.config.resolveNamespacedURLV3(service.getNamespaceId(), String.format("apps/%s/versions/%s/services/%s/methods/", service.getApplication(), service.getVersion(), service.getEntityName()));
    }

    public URL getServiceURL(ServiceId service) throws NotFoundException, IOException, UnauthenticatedException, UnauthorizedException {
        return this.config.resolveNamespacedURLV3(service.getNamespaceId(), String.format("apps/%s/services/%s/methods/", service.getApplication(), service.getEntityName()));
    }

    public Map<String, Integer> getRouteConfig(ServiceId serviceId) throws UnauthorizedException, IOException, UnauthenticatedException {
        URL url = this.buildRouteConfigUrl(serviceId);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), new int[0]);
        return (Map)ObjectResponse.fromJsonBody((HttpResponse)response, (Type)MAP_STRING_INTEGER_TYPE).getResponseObject();
    }

    public void storeRouteConfig(ServiceId serviceId, Map<String, Integer> routeConfig) throws IOException, UnauthorizedException, UnauthenticatedException {
        URL url = this.buildRouteConfigUrl(serviceId);
        HttpRequest request = HttpRequest.put((URL)url).withBody(GSON.toJson(routeConfig, MAP_STRING_INTEGER_TYPE)).build();
        this.restClient.upload(request, this.config.getAccessToken(), new int[0]);
    }

    public void deleteRouteConfig(ServiceId serviceId) throws IOException, UnauthorizedException, UnauthenticatedException {
        URL url = this.buildRouteConfigUrl(serviceId);
        this.restClient.execute(HttpMethod.DELETE, url, this.config.getAccessToken(), new int[0]);
    }

    public HttpResponse callServiceMethod(ServiceId serviceId, String methodPath) throws IOException, UnauthorizedException, UnauthenticatedException {
        String path = String.format("apps/%s/services/%s/methods/%s", serviceId.getApplication(), serviceId.getEntityName(), methodPath);
        URL url = this.config.resolveNamespacedURLV3(serviceId.getNamespaceId(), path);
        return this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), new int[0]);
    }

    private URL buildRouteConfigUrl(ServiceId serviceId) throws MalformedURLException {
        String path = String.format("apps/%s/services/%s/routeconfig", serviceId.getApplication(), serviceId.getEntityName());
        return this.config.resolveNamespacedURLV3(serviceId.getNamespaceId(), path);
    }
}

