/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.api.annotation.Beta;
import co.cask.cdap.api.customaction.CustomActionSpecification;
import co.cask.cdap.api.workflow.WorkflowActionNode;
import co.cask.cdap.api.workflow.WorkflowActionSpecification;
import co.cask.cdap.client.ApplicationClient;
import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.ApplicationNotFoundException;
import co.cask.cdap.common.NotFoundException;
import co.cask.cdap.common.ProgramNotFoundException;
import co.cask.cdap.common.UnauthenticatedException;
import co.cask.cdap.common.io.CaseInsensitiveEnumTypeAdapterFactory;
import co.cask.cdap.common.utils.Tasks;
import co.cask.cdap.proto.ApplicationRecord;
import co.cask.cdap.proto.BatchProgram;
import co.cask.cdap.proto.BatchProgramResult;
import co.cask.cdap.proto.BatchProgramStart;
import co.cask.cdap.proto.BatchProgramStatus;
import co.cask.cdap.proto.DistributedProgramLiveInfo;
import co.cask.cdap.proto.Id;
import co.cask.cdap.proto.Instances;
import co.cask.cdap.proto.ProgramRecord;
import co.cask.cdap.proto.ProgramRunStatus;
import co.cask.cdap.proto.ProgramStatus;
import co.cask.cdap.proto.RunRecord;
import co.cask.cdap.proto.codec.CustomActionSpecificationCodec;
import co.cask.cdap.proto.codec.WorkflowActionSpecificationCodec;
import co.cask.cdap.proto.id.ApplicationId;
import co.cask.cdap.proto.id.EntityId;
import co.cask.cdap.proto.id.FlowletId;
import co.cask.cdap.proto.id.NamespaceId;
import co.cask.cdap.proto.id.ProgramId;
import co.cask.cdap.proto.id.ServiceId;
import co.cask.cdap.proto.id.WorkflowId;
import co.cask.cdap.security.spi.authorization.UnauthorizedException;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpRequest;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Beta
public class ProgramClient {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(WorkflowActionSpecification.class, (Object)new WorkflowActionSpecificationCodec()).registerTypeAdapter(CustomActionSpecification.class, (Object)new CustomActionSpecificationCodec()).registerTypeAdapterFactory((TypeAdapterFactory)new CaseInsensitiveEnumTypeAdapterFactory()).create();
    private static final Type BATCH_STATUS_RESPONSE_TYPE = new TypeToken<List<BatchProgramStatus>>(){}.getType();
    private static final Type BATCH_RESULTS_TYPE = new TypeToken<List<BatchProgramResult>>(){}.getType();
    private static final Type MAP_STRING_STRING_TYPE = new TypeToken<Map<String, String>>(){}.getType();
    private final RESTClient restClient;
    private final ClientConfig config;
    private final ApplicationClient applicationClient;

    @Inject
    public ProgramClient(ClientConfig config, RESTClient restClient, ApplicationClient applicationClient) {
        this.config = config;
        this.restClient = restClient;
        this.applicationClient = applicationClient;
    }

    public ProgramClient(ClientConfig config) {
        this(config, new RESTClient(config));
    }

    public ProgramClient(ClientConfig config, RESTClient restClient) {
        this(config, restClient, new ApplicationClient(config, restClient));
    }

    @Deprecated
    public void start(Id.Program program, boolean debug, @Nullable Map<String, String> runtimeArgs) throws IOException, ProgramNotFoundException, UnauthenticatedException, UnauthorizedException {
        this.start(program.toEntityId(), debug, runtimeArgs);
    }

    public void start(ProgramId program, boolean debug, @Nullable Map<String, String> runtimeArgs) throws IOException, ProgramNotFoundException, UnauthenticatedException, UnauthorizedException {
        HttpResponse response;
        String action = debug ? "debug" : "start";
        String path = String.format("apps/%s/versions/%s/%s/%s/%s", program.getApplication(), program.getVersion(), program.getType().getCategoryName(), program.getProgram(), action);
        URL url = this.config.resolveNamespacedURLV3(program.getNamespaceId(), path);
        HttpRequest.Builder request = HttpRequest.post((URL)url);
        if (runtimeArgs != null) {
            request.withBody(GSON.toJson(runtimeArgs));
        }
        if ((response = this.restClient.execute(request.build(), this.config.getAccessToken(), 404)).getResponseCode() == 404) {
            throw new ProgramNotFoundException(program);
        }
    }

    @Deprecated
    public void start(Id.Program program, boolean debug) throws IOException, ProgramNotFoundException, UnauthenticatedException, UnauthorizedException {
        this.start(program.toEntityId(), debug);
    }

    public void start(ProgramId program, boolean debug) throws IOException, ProgramNotFoundException, UnauthenticatedException, UnauthorizedException {
        this.start(program, debug, null);
    }

    @Deprecated
    public void start(Id.Program program) throws IOException, ProgramNotFoundException, UnauthenticatedException, UnauthorizedException {
        this.start(program.toEntityId());
    }

    public void start(ProgramId program) throws IOException, ProgramNotFoundException, UnauthenticatedException, UnauthorizedException {
        this.start(program, false, null);
    }

    @Deprecated
    public List<BatchProgramResult> start(Id.Namespace namespace, List<BatchProgramStart> programs) throws IOException, UnauthenticatedException, UnauthorizedException {
        return this.start(namespace.toEntityId(), programs);
    }

    public List<BatchProgramResult> start(NamespaceId namespace, List<BatchProgramStart> programs) throws IOException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(namespace, "start");
        HttpRequest request = HttpRequest.builder((HttpMethod)HttpMethod.POST, (URL)url).withBody(GSON.toJson(programs), Charsets.UTF_8).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), new int[0]);
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (Type)BATCH_RESULTS_TYPE, (Gson)GSON).getResponseObject();
    }

    @Deprecated
    public void stop(Id.Program program) throws IOException, ProgramNotFoundException, UnauthenticatedException, UnauthorizedException {
        this.stop(program.toEntityId());
    }

    public void stop(ProgramId programId) throws IOException, ProgramNotFoundException, UnauthenticatedException, UnauthorizedException {
        String path = String.format("apps/%s/versions/%s/%s/%s/stop", programId.getApplication(), programId.getVersion(), programId.getType().getCategoryName(), programId.getProgram());
        URL url = this.config.resolveNamespacedURLV3(programId.getNamespaceId(), path);
        HttpResponse response = this.restClient.execute(HttpMethod.POST, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ProgramNotFoundException(programId);
        }
    }

    @Deprecated
    public List<BatchProgramResult> stop(Id.Namespace namespace, List<BatchProgram> programs) throws IOException, UnauthenticatedException, UnauthorizedException {
        return this.stop(namespace.toEntityId(), programs);
    }

    public List<BatchProgramResult> stop(NamespaceId namespace, List<BatchProgram> programs) throws IOException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(namespace, "stop");
        HttpRequest request = HttpRequest.builder((HttpMethod)HttpMethod.POST, (URL)url).withBody(GSON.toJson(programs), Charsets.UTF_8).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), new int[0]);
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (Type)BATCH_RESULTS_TYPE, (Gson)GSON).getResponseObject();
    }

    @Deprecated
    public void stopAll(Id.Namespace namespace) throws IOException, UnauthenticatedException, InterruptedException, TimeoutException, UnauthorizedException, ApplicationNotFoundException {
        this.stopAll(namespace.toEntityId());
    }

    public void stopAll(NamespaceId namespace) throws IOException, UnauthenticatedException, InterruptedException, TimeoutException, UnauthorizedException, ApplicationNotFoundException {
        List<ApplicationRecord> allApps = this.applicationClient.list(namespace);
        for (ApplicationRecord applicationRecord : allApps) {
            ApplicationId appId = new ApplicationId(namespace.getNamespace(), applicationRecord.getName(), applicationRecord.getAppVersion());
            List<ProgramRecord> programRecords = this.applicationClient.listPrograms(appId);
            for (ProgramRecord programRecord : programRecords) {
                try {
                    ProgramId program = appId.program(programRecord.getType(), programRecord.getName());
                    String status = this.getStatus(program);
                    if (status.equals("STOPPED")) continue;
                    this.stop(program);
                    this.waitForStatus(program, ProgramStatus.STOPPED, 60L, TimeUnit.SECONDS);
                }
                catch (ProgramNotFoundException e) {}
            }
        }
    }

    @Deprecated
    public String getStatus(Id.Program program) throws IOException, ProgramNotFoundException, UnauthenticatedException, UnauthorizedException {
        return this.getStatus(program.toEntityId());
    }

    public String getStatus(ProgramId programId) throws IOException, ProgramNotFoundException, UnauthenticatedException, UnauthorizedException {
        String path = String.format("apps/%s/versions/%s/%s/%s/status", programId.getApplication(), programId.getVersion(), programId.getType().getCategoryName(), programId.getProgram());
        URL url = this.config.resolveNamespacedURLV3(programId.getNamespaceId(), path);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (404 == response.getResponseCode()) {
            throw new ProgramNotFoundException(programId);
        }
        Map responseObject = (Map)ObjectResponse.fromJsonBody((HttpResponse)response, (Type)MAP_STRING_STRING_TYPE, (Gson)GSON).getResponseObject();
        return (String)responseObject.get("status");
    }

    @Deprecated
    public List<BatchProgramStatus> getStatus(Id.Namespace namespace, List<BatchProgram> programs) throws IOException, UnauthenticatedException, UnauthorizedException {
        return this.getStatus(namespace.toEntityId(), programs);
    }

    public List<BatchProgramStatus> getStatus(NamespaceId namespace, List<BatchProgram> programs) throws IOException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(namespace, "status");
        HttpRequest request = HttpRequest.post((URL)url).withBody(GSON.toJson(programs)).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), new int[0]);
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (Type)BATCH_STATUS_RESPONSE_TYPE, (Gson)GSON).getResponseObject();
    }

    @Deprecated
    public void waitForStatus(Id.Program program, String status, long timeout, TimeUnit timeoutUnit) throws UnauthenticatedException, IOException, ProgramNotFoundException, TimeoutException, InterruptedException {
        this.waitForStatus(program.toEntityId(), ProgramStatus.valueOf((String)status), timeout, timeoutUnit);
    }

    public void waitForStatus(final ProgramId program, ProgramStatus status, long timeout, TimeUnit timeoutUnit) throws UnauthenticatedException, IOException, ProgramNotFoundException, TimeoutException, InterruptedException {
        try {
            Tasks.waitFor((Object)status.name(), (Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return ProgramClient.this.getStatus(program);
                }
            }, (long)timeout, (TimeUnit)timeoutUnit, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), UnauthenticatedException.class);
            Throwables.propagateIfPossible((Throwable)e.getCause(), ProgramNotFoundException.class);
            Throwables.propagateIfPossible((Throwable)e.getCause(), IOException.class);
            Throwables.propagate((Throwable)e.getCause());
        }
    }

    @Deprecated
    public DistributedProgramLiveInfo getLiveInfo(Id.Program program) throws IOException, ProgramNotFoundException, UnauthenticatedException, UnauthorizedException {
        return this.getLiveInfo(program.toEntityId());
    }

    public DistributedProgramLiveInfo getLiveInfo(ProgramId program) throws IOException, ProgramNotFoundException, UnauthenticatedException, UnauthorizedException {
        String path = String.format("apps/%s/%s/%s/live-info", program.getApplication(), program.getType().getCategoryName(), program.getProgram());
        URL url = this.config.resolveNamespacedURLV3(program.getNamespaceId(), path);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ProgramNotFoundException(program);
        }
        return (DistributedProgramLiveInfo)ObjectResponse.fromJsonBody((HttpResponse)response, DistributedProgramLiveInfo.class).getResponseObject();
    }

    @Deprecated
    public int getFlowletInstances(Id.Flow.Flowlet flowlet) throws IOException, NotFoundException, UnauthenticatedException, UnauthorizedException {
        return this.getFlowletInstances(flowlet.toEntityId());
    }

    public int getFlowletInstances(FlowletId flowlet) throws IOException, NotFoundException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(flowlet.getParent().getNamespaceId(), String.format("apps/%s/flows/%s/flowlets/%s/instances", flowlet.getApplication(), flowlet.getFlow(), flowlet.getFlowlet()));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((EntityId)flowlet);
        }
        return ((Instances)ObjectResponse.fromJsonBody((HttpResponse)response, Instances.class).getResponseObject()).getInstances();
    }

    @Deprecated
    public void setFlowletInstances(Id.Flow.Flowlet flowlet, int instances) throws IOException, NotFoundException, UnauthenticatedException, UnauthorizedException {
        this.setFlowletInstances(flowlet.toEntityId(), instances);
    }

    public void setFlowletInstances(FlowletId flowlet, int instances) throws IOException, NotFoundException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(flowlet.getParent().getNamespaceId(), String.format("apps/%s/flows/%s/flowlets/%s/instances", flowlet.getApplication(), flowlet.getFlow(), flowlet.getFlowlet()));
        HttpRequest request = HttpRequest.put((URL)url).withBody(GSON.toJson((Object)new Instances(instances))).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((EntityId)flowlet);
        }
    }

    @Deprecated
    public int getWorkerInstances(Id.Worker worker) throws IOException, NotFoundException, UnauthenticatedException, UnauthorizedException {
        return this.getWorkerInstances(worker.toEntityId());
    }

    public int getWorkerInstances(ProgramId worker) throws IOException, NotFoundException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(worker.getNamespaceId(), String.format("apps/%s/workers/%s/instances", worker.getApplication(), worker.getProgram()));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((EntityId)worker);
        }
        return ((Instances)ObjectResponse.fromJsonBody((HttpResponse)response, Instances.class).getResponseObject()).getInstances();
    }

    @Deprecated
    public void setWorkerInstances(Id.Worker worker, int instances) throws IOException, NotFoundException, UnauthenticatedException, UnauthorizedException {
        this.setWorkerInstances(worker.toEntityId(), instances);
    }

    public void setWorkerInstances(ProgramId worker, int instances) throws IOException, NotFoundException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(worker.getNamespaceId(), String.format("apps/%s/workers/%s/instances", worker.getApplication(), worker.getProgram()));
        HttpRequest request = HttpRequest.put((URL)url).withBody(GSON.toJson((Object)new Instances(instances))).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((EntityId)worker);
        }
    }

    @Deprecated
    public int getServiceInstances(Id.Service service) throws IOException, NotFoundException, UnauthenticatedException, UnauthorizedException {
        return this.getServiceInstances(service.toEntityId());
    }

    public int getServiceInstances(ServiceId service) throws IOException, NotFoundException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(service.getNamespaceId(), String.format("apps/%s/services/%s/instances", service.getApplication(), service.getProgram()));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((EntityId)service);
        }
        return ((Instances)ObjectResponse.fromJsonBody((HttpResponse)response, Instances.class).getResponseObject()).getInstances();
    }

    @Deprecated
    public void setServiceInstances(Id.Service service, int instances) throws IOException, NotFoundException, UnauthenticatedException, UnauthorizedException {
        this.setServiceInstances(service.toEntityId(), instances);
    }

    public void setServiceInstances(ServiceId service, int instances) throws IOException, NotFoundException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(service.getNamespaceId(), String.format("apps/%s/services/%s/instances", service.getApplication(), service.getProgram()));
        HttpRequest request = HttpRequest.put((URL)url).withBody(GSON.toJson((Object)new Instances(instances))).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((EntityId)service);
        }
    }

    @Deprecated
    public List<WorkflowActionNode> getWorkflowCurrent(Id.Application appId, String workflowId, String runId) throws IOException, NotFoundException, UnauthenticatedException, UnauthorizedException {
        return this.getWorkflowCurrent(appId.toEntityId().workflow(workflowId), runId);
    }

    public List<WorkflowActionNode> getWorkflowCurrent(WorkflowId workflowId, String runId) throws IOException, NotFoundException, UnauthenticatedException, UnauthorizedException {
        String path = String.format("/apps/%s/workflows/%s/runs/%s/current", workflowId.getApplication(), workflowId.getProgram(), runId);
        URL url = this.config.resolveNamespacedURLV3(workflowId.getNamespaceId(), path);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((EntityId)workflowId.run(runId));
        }
        ObjectResponse objectResponse = ObjectResponse.fromJsonBody((HttpResponse)response, (Type)new TypeToken<List<WorkflowActionNode>>(){}.getType(), (Gson)GSON);
        return (List)objectResponse.getResponseObject();
    }

    @Deprecated
    public List<RunRecord> getProgramRuns(Id.Program program, String state, long startTime, long endTime, int limit) throws IOException, NotFoundException, UnauthenticatedException, UnauthorizedException {
        return this.getProgramRuns(program.toEntityId(), state, startTime, endTime, limit);
    }

    public List<RunRecord> getProgramRuns(ProgramId program, String state, long startTime, long endTime, int limit) throws IOException, NotFoundException, UnauthenticatedException, UnauthorizedException {
        String queryParams = String.format("%s=%s&%s=%d&%s=%d&%s=%d", "status", state, "start", startTime, "end", endTime, "limit", limit);
        String path = String.format("apps/%s/%s/%s/runs?%s", program.getApplication(), program.getType().getCategoryName(), program.getProgram(), queryParams);
        URL url = this.config.resolveNamespacedURLV3(program.getNamespaceId(), path);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((EntityId)program);
        }
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<List<RunRecord>>(){}).getResponseObject();
    }

    @Deprecated
    public List<RunRecord> getAllProgramRuns(Id.Program program, long startTime, long endTime, int limit) throws IOException, NotFoundException, UnauthenticatedException, UnauthorizedException {
        return this.getAllProgramRuns(program.toEntityId(), startTime, endTime, limit);
    }

    public List<RunRecord> getAllProgramRuns(ProgramId program, long startTime, long endTime, int limit) throws IOException, NotFoundException, UnauthenticatedException, UnauthorizedException {
        return this.getProgramRuns(program, ProgramRunStatus.ALL.name(), startTime, endTime, limit);
    }

    @Deprecated
    public String getProgramLogs(Id.Program program, long start, long stop) throws IOException, NotFoundException, UnauthenticatedException, UnauthorizedException {
        return this.getProgramLogs(program.toEntityId(), start, stop);
    }

    public String getProgramLogs(ProgramId program, long start, long stop) throws IOException, NotFoundException, UnauthenticatedException, UnauthorizedException {
        String path = String.format("apps/%s/%s/%s/logs?start=%d&stop=%d&escape=false", program.getApplication(), program.getType().getCategoryName(), program.getProgram(), start, stop);
        URL url = this.config.resolveNamespacedURLV3(program.getNamespaceId(), path);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), new int[0]);
        if (response.getResponseCode() == 404) {
            throw new ProgramNotFoundException(program);
        }
        return new String(response.getResponseBody(), Charsets.UTF_8);
    }

    @Deprecated
    public Map<String, String> getRuntimeArgs(Id.Program program) throws IOException, UnauthenticatedException, ProgramNotFoundException, UnauthorizedException {
        return this.getRuntimeArgs(program.toEntityId());
    }

    public Map<String, String> getRuntimeArgs(ProgramId program) throws IOException, UnauthenticatedException, ProgramNotFoundException, UnauthorizedException {
        String path = String.format("apps/%s/versions/%s/%s/%s/runtimeargs", program.getApplication(), program.getVersion(), program.getType().getCategoryName(), program.getProgram());
        URL url = this.config.resolveNamespacedURLV3(program.getNamespaceId(), path);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ProgramNotFoundException(program);
        }
        return (Map)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<Map<String, String>>(){}).getResponseObject();
    }

    @Deprecated
    public void setRuntimeArgs(Id.Program program, Map<String, String> runtimeArgs) throws IOException, UnauthenticatedException, ProgramNotFoundException, UnauthorizedException {
        this.setRuntimeArgs(program.toEntityId(), runtimeArgs);
    }

    public void setRuntimeArgs(ProgramId program, Map<String, String> runtimeArgs) throws IOException, UnauthenticatedException, ProgramNotFoundException, UnauthorizedException {
        String path = String.format("apps/%s/versions/%s/%s/%s/runtimeargs", program.getApplication(), program.getVersion(), program.getType().getCategoryName(), program.getProgram());
        URL url = this.config.resolveNamespacedURLV3(program.getNamespaceId(), path);
        HttpRequest request = HttpRequest.put((URL)url).withBody(GSON.toJson(runtimeArgs)).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ProgramNotFoundException(program);
        }
    }
}

