/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.api.annotation.Beta;
import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.NotFoundException;
import co.cask.cdap.common.ProgramNotFoundException;
import co.cask.cdap.common.UnauthenticatedException;
import co.cask.cdap.proto.Id;
import co.cask.cdap.proto.id.ApplicationId;
import co.cask.cdap.proto.id.EntityId;
import co.cask.cdap.proto.id.NamespaceId;
import co.cask.cdap.proto.id.ProgramId;
import co.cask.cdap.security.spi.authorization.UnauthorizedException;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.inject.Inject;
import java.io.IOException;
import java.net.URL;
import java.util.Map;

@Beta
public class PreferencesClient {
    private static final Gson GSON = new Gson();
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public PreferencesClient(ClientConfig config, RESTClient restClient) {
        this.config = config;
        this.restClient = restClient;
    }

    public PreferencesClient(ClientConfig config) {
        this(config, new RESTClient(config));
    }

    public Map<String, String> getInstancePreferences() throws IOException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveURLV3("preferences");
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), new int[0]);
        return (Map)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<Map<String, String>>(){}).getResponseObject();
    }

    public void setInstancePreferences(Map<String, String> preferences) throws IOException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveURLV3("preferences");
        this.restClient.execute(HttpMethod.PUT, url, GSON.toJson(preferences), null, this.config.getAccessToken(), new int[0]);
    }

    public void deleteInstancePreferences() throws IOException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveURLV3("preferences");
        this.restClient.execute(HttpMethod.DELETE, url, this.config.getAccessToken(), new int[0]);
    }

    @Deprecated
    public Map<String, String> getNamespacePreferences(Id.Namespace namespace, boolean resolved) throws IOException, UnauthenticatedException, NotFoundException, UnauthorizedException {
        return this.getNamespacePreferences(namespace.toEntityId(), resolved);
    }

    public Map<String, String> getNamespacePreferences(NamespaceId namespace, boolean resolved) throws IOException, UnauthenticatedException, NotFoundException, UnauthorizedException {
        String res = Boolean.toString(resolved);
        URL url = this.config.resolveURLV3(String.format("namespaces/%s/preferences?resolved=%s", namespace.getNamespace(), res));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((EntityId)namespace);
        }
        return (Map)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<Map<String, String>>(){}).getResponseObject();
    }

    @Deprecated
    public void setNamespacePreferences(Id.Namespace namespace, Map<String, String> preferences) throws IOException, UnauthenticatedException, NotFoundException, UnauthorizedException {
        this.setNamespacePreferences(namespace.toEntityId(), preferences);
    }

    public void setNamespacePreferences(NamespaceId namespace, Map<String, String> preferences) throws IOException, UnauthenticatedException, NotFoundException, UnauthorizedException {
        URL url = this.config.resolveURLV3(String.format("namespaces/%s/preferences", namespace.getNamespace()));
        HttpResponse response = this.restClient.execute(HttpMethod.PUT, url, GSON.toJson(preferences), null, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((EntityId)namespace);
        }
    }

    @Deprecated
    public void deleteNamespacePreferences(Id.Namespace namespace) throws IOException, UnauthenticatedException, NotFoundException, UnauthorizedException {
        this.deleteNamespacePreferences(namespace.toEntityId());
    }

    public void deleteNamespacePreferences(NamespaceId namespace) throws IOException, UnauthenticatedException, NotFoundException, UnauthorizedException {
        URL url = this.config.resolveURLV3(String.format("namespaces/%s/preferences", namespace.getNamespace()));
        HttpResponse response = this.restClient.execute(HttpMethod.DELETE, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((EntityId)namespace);
        }
    }

    @Deprecated
    public Map<String, String> getApplicationPreferences(Id.Application application, boolean resolved) throws IOException, UnauthenticatedException, NotFoundException, UnauthorizedException {
        return this.getApplicationPreferences(application.toEntityId(), resolved);
    }

    public Map<String, String> getApplicationPreferences(ApplicationId application, boolean resolved) throws IOException, UnauthenticatedException, NotFoundException, UnauthorizedException {
        String res = Boolean.toString(resolved);
        URL url = this.config.resolveNamespacedURLV3(application.getParent(), String.format("/apps/%s/preferences?resolved=%s", application.getApplication(), res));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((EntityId)application);
        }
        return (Map)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<Map<String, String>>(){}).getResponseObject();
    }

    @Deprecated
    public void setApplicationPreferences(Id.Application application, Map<String, String> preferences) throws IOException, UnauthenticatedException, NotFoundException, UnauthorizedException {
        this.setApplicationPreferences(application.toEntityId(), preferences);
    }

    public void setApplicationPreferences(ApplicationId application, Map<String, String> preferences) throws IOException, UnauthenticatedException, NotFoundException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(application.getParent(), String.format("/apps/%s/preferences", application.getApplication()));
        HttpResponse response = this.restClient.execute(HttpMethod.PUT, url, GSON.toJson(preferences), null, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((EntityId)application);
        }
    }

    @Deprecated
    public void deleteApplicationPreferences(Id.Application application) throws IOException, UnauthenticatedException, NotFoundException, UnauthorizedException {
        this.deleteApplicationPreferences(application.toEntityId());
    }

    public void deleteApplicationPreferences(ApplicationId application) throws IOException, UnauthenticatedException, NotFoundException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(application.getParent(), String.format("/apps/%s/preferences", application.getApplication()));
        HttpResponse response = this.restClient.execute(HttpMethod.DELETE, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((EntityId)application);
        }
    }

    @Deprecated
    public Map<String, String> getProgramPreferences(Id.Program program, boolean resolved) throws IOException, UnauthenticatedException, ProgramNotFoundException, UnauthorizedException {
        return this.getProgramPreferences(program.toEntityId(), resolved);
    }

    public Map<String, String> getProgramPreferences(ProgramId program, boolean resolved) throws IOException, UnauthenticatedException, ProgramNotFoundException, UnauthorizedException {
        String res = Boolean.toString(resolved);
        URL url = this.config.resolveNamespacedURLV3(program.getNamespaceId(), String.format("/apps/%s/%s/%s/preferences?resolved=%s", program.getApplication(), program.getType().getCategoryName(), program.getProgram(), res));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ProgramNotFoundException(program);
        }
        return (Map)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<Map<String, String>>(){}).getResponseObject();
    }

    @Deprecated
    public void setProgramPreferences(Id.Program program, Map<String, String> preferences) throws IOException, UnauthenticatedException, ProgramNotFoundException, UnauthorizedException {
        this.setProgramPreferences(program.toEntityId(), preferences);
    }

    public void setProgramPreferences(ProgramId program, Map<String, String> preferences) throws IOException, UnauthenticatedException, ProgramNotFoundException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(program.getNamespaceId(), String.format("/apps/%s/%s/%s/preferences", program.getApplication(), program.getType().getCategoryName(), program.getProgram()));
        HttpResponse response = this.restClient.execute(HttpMethod.PUT, url, GSON.toJson(preferences), null, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ProgramNotFoundException(program);
        }
    }

    @Deprecated
    public void deleteProgramPreferences(Id.Program program) throws IOException, UnauthenticatedException, ProgramNotFoundException, UnauthorizedException {
        this.deleteProgramPreferences(program.toEntityId());
    }

    public void deleteProgramPreferences(ProgramId program) throws IOException, UnauthenticatedException, ProgramNotFoundException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(program.getNamespaceId(), String.format("/apps/%s/%s/%s/preferences", program.getApplication(), program.getType().getCategoryName(), program.getProgram()));
        HttpResponse response = this.restClient.execute(HttpMethod.DELETE, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ProgramNotFoundException(program);
        }
    }
}

