/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.api.annotation.Beta;
import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.BadRequestException;
import co.cask.cdap.common.NotFoundException;
import co.cask.cdap.common.ServiceNotEnabledException;
import co.cask.cdap.common.UnauthenticatedException;
import co.cask.cdap.proto.Instances;
import co.cask.cdap.proto.SystemServiceLiveInfo;
import co.cask.cdap.proto.SystemServiceMeta;
import co.cask.cdap.proto.id.EntityId;
import co.cask.cdap.proto.id.SystemServiceId;
import co.cask.cdap.security.spi.authorization.UnauthorizedException;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpRequest;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;

@Beta
public class MonitorClient {
    private static final Gson GSON = new Gson();
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public MonitorClient(ClientConfig config, RESTClient restClient) {
        this.config = config;
        this.restClient = restClient;
    }

    public MonitorClient(ClientConfig config) {
        this(config, new RESTClient(config));
    }

    public SystemServiceLiveInfo getSystemServiceLiveInfo(String serviceName) throws IOException, UnauthenticatedException, NotFoundException, UnauthorizedException {
        URL url = this.config.resolveURLV3(String.format("system/services/%s/live-info", serviceName));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        String responseBody = new String(response.getResponseBody());
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((EntityId)new SystemServiceId(serviceName));
        }
        return (SystemServiceLiveInfo)GSON.fromJson(responseBody, SystemServiceLiveInfo.class);
    }

    public List<SystemServiceMeta> listSystemServices() throws IOException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveURL("system/services");
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), new int[0]);
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<List<SystemServiceMeta>>(){}).getResponseObject();
    }

    public String getSystemServiceStatus(String serviceName) throws IOException, NotFoundException, BadRequestException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveURL(String.format("system/services/%s/status", serviceName));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404, 400);
        String responseBody = new String(response.getResponseBody());
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((EntityId)new SystemServiceId(serviceName));
        }
        if (response.getResponseCode() == 400) {
            throw new BadRequestException(responseBody);
        }
        Map status = (Map)GSON.fromJson(responseBody, new TypeToken<Map<String, String>>(){}.getType());
        return (String)status.get("status");
    }

    public Map<String, String> getAllSystemServiceStatus() throws IOException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveURL("system/services/status");
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), new int[0]);
        return (Map)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<Map<String, String>>(){}).getResponseObject();
    }

    public boolean allSystemServicesOk() throws IOException, UnauthenticatedException, UnauthorizedException {
        for (String status : this.getAllSystemServiceStatus().values()) {
            if ("OK".equals(status)) continue;
            return false;
        }
        return true;
    }

    public void setSystemServiceInstances(String serviceName, int instances) throws IOException, NotFoundException, BadRequestException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveURL(String.format("system/services/%s/instances", serviceName));
        HttpRequest request = HttpRequest.put((URL)url).withBody(GSON.toJson((Object)new Instances(instances))).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 404, 400);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((EntityId)new SystemServiceId(serviceName));
        }
        if (response.getResponseCode() == 400) {
            throw new BadRequestException(new String(response.getResponseBody()));
        }
    }

    public int getSystemServiceInstances(String serviceName) throws IOException, NotFoundException, ServiceNotEnabledException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveURL(String.format("system/services/%s/instances", serviceName));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404, 403);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((EntityId)new SystemServiceId(serviceName));
        }
        if (response.getResponseCode() == 403) {
            throw new ServiceNotEnabledException(serviceName);
        }
        return ((Instances)ObjectResponse.fromJsonBody((HttpResponse)response, Instances.class).getResponseObject()).getInstances();
    }
}

