/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.api.annotation.Beta;
import co.cask.cdap.api.metrics.RuntimeMetrics;
import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.UnauthenticatedException;
import co.cask.cdap.common.metrics.MetricsTags;
import co.cask.cdap.proto.Id;
import co.cask.cdap.proto.MetricQueryResult;
import co.cask.cdap.proto.MetricTagValue;
import co.cask.cdap.proto.id.FlowletId;
import co.cask.cdap.proto.id.ServiceId;
import co.cask.cdap.security.spi.authorization.UnauthorizedException;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import com.google.common.base.Joiner;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Beta
public class MetricsClient {
    private final RESTClient restClient;
    private final ClientConfig config;
    private final Set<String> validTimeRangeParams;

    @Inject
    public MetricsClient(ClientConfig config, RESTClient restClient) {
        this.config = config;
        this.restClient = restClient;
        this.validTimeRangeParams = ImmutableSet.of((Object)"start", (Object)"end", (Object)"aggregate", (Object)"resolution", (Object)"interpolate", (Object)"maxInterpolateGap", (Object[])new String[]{"count"});
    }

    public MetricsClient(ClientConfig config) {
        this(config, new RESTClient(config));
    }

    public List<MetricTagValue> searchTags(Map<String, String> tags) throws IOException, UnauthenticatedException, UnauthorizedException {
        ArrayList queryParts = Lists.newArrayList();
        queryParts.add("target=tag");
        this.addTags(tags, queryParts);
        URL url = this.config.resolveURLV3(String.format("metrics/search?%s", Joiner.on((String)"&").join((Iterable)queryParts)));
        HttpResponse response = this.restClient.execute(HttpMethod.POST, url, this.config.getAccessToken(), new int[0]);
        ObjectResponse result = ObjectResponse.fromJsonBody((HttpResponse)response, (Type)new TypeToken<List<MetricTagValue>>(){}.getType());
        return (List)result.getResponseObject();
    }

    public List<String> searchMetrics(Map<String, String> tags) throws IOException, UnauthenticatedException, UnauthorizedException {
        ArrayList queryParts = Lists.newArrayList();
        queryParts.add("target=metric");
        this.addTags(tags, queryParts);
        URL url = this.config.resolveURLV3(String.format("metrics/search?%s", Joiner.on((String)"&").join((Iterable)queryParts)));
        HttpResponse response = this.restClient.execute(HttpMethod.POST, url, this.config.getAccessToken(), new int[0]);
        ObjectResponse result = ObjectResponse.fromJsonBody((HttpResponse)response, (Type)new TypeToken<List<String>>(){}.getType());
        return (List)result.getResponseObject();
    }

    public MetricQueryResult query(Map<String, String> tags, String metric) throws IOException, UnauthenticatedException, UnauthorizedException {
        return this.query(tags, (List<String>)ImmutableList.of((Object)metric), (List<String>)ImmutableList.of(), (Map<String, String>)ImmutableMap.of());
    }

    public MetricQueryResult query(Map<String, String> tags, List<String> metrics, List<String> groupBys, @Nullable String start, @Nullable String end) throws IOException, UnauthenticatedException, UnauthorizedException {
        HashMap timeRangeParams = Maps.newHashMap();
        if (start != null) {
            timeRangeParams.put("start", start);
        }
        if (end != null) {
            timeRangeParams.put("end", end);
        }
        return this.query(tags, metrics, groupBys, timeRangeParams);
    }

    public MetricQueryResult query(Map<String, String> tags, List<String> metrics, List<String> groupBys, Map<String, String> timeRangeParams) throws IOException, UnauthenticatedException, UnauthorizedException {
        ArrayList queryParts = Lists.newArrayList();
        queryParts.add("target=tag");
        this.add("metric", metrics, queryParts);
        this.add("groupBy", groupBys, queryParts);
        this.addTags(tags, queryParts);
        this.addTimeRangeParametersToQuery(timeRangeParams, queryParts);
        URL url = this.config.resolveURLV3(String.format("metrics/query?%s", Joiner.on((String)"&").join((Iterable)queryParts)));
        HttpResponse response = this.restClient.execute(HttpMethod.POST, url, this.config.getAccessToken(), new int[0]);
        return (MetricQueryResult)ObjectResponse.fromJsonBody((HttpResponse)response, MetricQueryResult.class).getResponseObject();
    }

    private void addTimeRangeParametersToQuery(Map<String, String> timeRangeParams, List<String> queryParts) {
        for (Map.Entry<String, String> entry : timeRangeParams.entrySet()) {
            if (!this.validTimeRangeParams.contains(entry.getKey())) continue;
            queryParts.add(entry.getKey() + "=" + entry.getValue());
        }
    }

    @Deprecated
    public RuntimeMetrics getFlowletMetrics(Id.Program flowId, String flowletId) {
        return this.getFlowletMetrics(flowId.toEntityId().flowlet(flowletId));
    }

    public RuntimeMetrics getFlowletMetrics(FlowletId flowletId) {
        return this.getMetrics(MetricsTags.flowlet((FlowletId)flowletId), "system.process.tuples.read", "system.process.events.processed", "system.process.errors");
    }

    @Deprecated
    public RuntimeMetrics getServiceMetrics(Id.Program serviceId) {
        return this.getServiceMetrics(serviceId.getApplication().toEntityId().service(serviceId.getId()));
    }

    public RuntimeMetrics getServiceMetrics(ServiceId serviceId) {
        return this.getMetrics(MetricsTags.service((ServiceId)serviceId), "system.requests.count", "system.response.successful.count", "system.response.server.error.count");
    }

    private void add(String key, List<String> values, List<String> outQueryParts) {
        for (String value : values) {
            outQueryParts.add(key + "=" + value);
        }
    }

    private void addTags(Map<String, String> tags, List<String> outQueryParts) {
        for (Map.Entry<String, String> tag : tags.entrySet()) {
            outQueryParts.add("tag=" + tag.getKey() + ":" + tag.getValue());
        }
    }

    private RuntimeMetrics getMetrics(final Map<String, String> tags, final String inputName, final String processedName, final String exceptionName) {
        return new RuntimeMetrics(){

            public long getInput() {
                return MetricsClient.this.getTotalCounter(tags, inputName);
            }

            public long getProcessed() {
                return MetricsClient.this.getTotalCounter(tags, processedName);
            }

            public long getException() {
                return MetricsClient.this.getTotalCounter(tags, exceptionName);
            }

            public void waitForinput(long count, long timeout, TimeUnit timeoutUnit) throws TimeoutException, InterruptedException {
                this.doWaitFor(inputName, count, timeout, timeoutUnit);
            }

            public void waitForProcessed(long count, long timeout, TimeUnit timeoutUnit) throws TimeoutException, InterruptedException {
                this.doWaitFor(processedName, count, timeout, timeoutUnit);
            }

            public void waitForException(long count, long timeout, TimeUnit timeoutUnit) throws TimeoutException, InterruptedException {
                this.doWaitFor(exceptionName, count, timeout, timeoutUnit);
            }

            public void waitFor(String name, long count, long timeout, TimeUnit timeoutUnit) throws TimeoutException, InterruptedException {
                this.doWaitFor(name, count, timeout, timeoutUnit);
            }

            private void doWaitFor(String name, long count, long timeout, TimeUnit timeoutUnit) throws TimeoutException, InterruptedException {
                long value = MetricsClient.this.getTotalCounter(tags, name);
                long sleepMillis = Math.max(10L, Math.min(timeoutUnit.toMillis(timeout) / 10L, TimeUnit.SECONDS.toMillis(1L)));
                Stopwatch stopwatch = new Stopwatch().start();
                while (value < count && stopwatch.elapsedTime(timeoutUnit) < timeout) {
                    TimeUnit.MILLISECONDS.sleep(sleepMillis);
                    value = MetricsClient.this.getTotalCounter(tags, name);
                }
                if (value < count) {
                    throw new TimeoutException("Time limit reached. Got '" + value + "' instead of '" + count + "'");
                }
            }

            public String toString() {
                return String.format("%s; tags=%d, processed=%d, exception=%d", Joiner.on((String)",").withKeyValueSeparator(":").join(tags), this.getInput(), this.getProcessed(), this.getException());
            }
        };
    }

    private long getTotalCounter(Map<String, String> tags, String metricName) {
        try {
            MetricQueryResult result = this.query(tags, metricName);
            if (result.getSeries().length == 0) {
                return 0L;
            }
            MetricQueryResult.TimeValue[] timeValues = result.getSeries()[0].getData();
            if (timeValues.length == 0) {
                return 0L;
            }
            return timeValues[0].getValue();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

