/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.BadRequestException;
import co.cask.cdap.common.NotFoundException;
import co.cask.cdap.common.UnauthenticatedException;
import co.cask.cdap.proto.Id;
import co.cask.cdap.proto.codec.NamespacedEntityIdCodec;
import co.cask.cdap.proto.codec.NamespacedIdCodec;
import co.cask.cdap.proto.id.DatasetId;
import co.cask.cdap.proto.id.NamespaceId;
import co.cask.cdap.proto.id.NamespacedEntityId;
import co.cask.cdap.proto.id.StreamId;
import co.cask.cdap.proto.metadata.lineage.CollapseType;
import co.cask.cdap.proto.metadata.lineage.LineageRecord;
import co.cask.cdap.security.spi.authorization.UnauthorizedException;
import co.cask.common.http.HttpRequest;
import co.cask.common.http.HttpResponse;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;

public class LineageClient {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(Id.NamespacedId.class, (Object)new NamespacedIdCodec()).registerTypeAdapter(NamespacedEntityId.class, (Object)new NamespacedEntityIdCodec()).create();
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public LineageClient(ClientConfig config, RESTClient restClient) {
        this.config = config;
        this.restClient = restClient;
    }

    public LineageClient(ClientConfig config) {
        this(config, new RESTClient());
    }

    @Deprecated
    public LineageRecord getLineage(Id.DatasetInstance datasetInstance, long startTime, long endTime, @Nullable Integer levels) throws IOException, UnauthenticatedException, NotFoundException, BadRequestException, UnauthorizedException {
        return this.getLineage(datasetInstance.toEntityId(), startTime, endTime, levels);
    }

    public LineageRecord getLineage(DatasetId datasetInstance, long startTime, long endTime, @Nullable Integer levels) throws IOException, UnauthenticatedException, NotFoundException, BadRequestException, UnauthorizedException {
        return this.getLineage(datasetInstance, Long.toString(startTime), Long.toString(endTime), levels);
    }

    @Deprecated
    public LineageRecord getLineage(Id.DatasetInstance datasetInstance, String startTime, String endTime, @Nullable Integer levels) throws IOException, UnauthenticatedException, NotFoundException, BadRequestException, UnauthorizedException {
        return this.getLineage(datasetInstance.toEntityId(), startTime, endTime, levels);
    }

    public LineageRecord getLineage(DatasetId datasetInstance, String startTime, String endTime, @Nullable Integer levels) throws IOException, UnauthenticatedException, NotFoundException, BadRequestException, UnauthorizedException {
        return this.getLineage(datasetInstance, startTime, endTime, Collections.emptySet(), levels);
    }

    @Deprecated
    public LineageRecord getLineage(Id.DatasetInstance datasetInstance, long startTime, long endTime, Set<CollapseType> collapseTypes, @Nullable Integer levels) throws IOException, UnauthenticatedException, NotFoundException, BadRequestException, UnauthorizedException {
        return this.getLineage(datasetInstance.toEntityId(), startTime, endTime, collapseTypes, levels);
    }

    public LineageRecord getLineage(DatasetId datasetInstance, long startTime, long endTime, Set<CollapseType> collapseTypes, @Nullable Integer levels) throws IOException, UnauthenticatedException, NotFoundException, BadRequestException, UnauthorizedException {
        return this.getLineage(datasetInstance, Long.toString(startTime), Long.toString(endTime), collapseTypes, levels);
    }

    @Deprecated
    public LineageRecord getLineage(Id.DatasetInstance datasetInstance, String startTime, String endTime, Set<CollapseType> collapseTypes, @Nullable Integer levels) throws IOException, UnauthenticatedException, NotFoundException, BadRequestException, UnauthorizedException {
        return this.getLineage(datasetInstance.toEntityId(), startTime, endTime, collapseTypes, levels);
    }

    public LineageRecord getLineage(DatasetId datasetInstance, String startTime, String endTime, Set<CollapseType> collapseTypes, @Nullable Integer levels) throws IOException, UnauthenticatedException, NotFoundException, BadRequestException, UnauthorizedException {
        String path = String.format("datasets/%s/lineage?start=%s&end=%s", datasetInstance.getDataset(), URLEncoder.encode(startTime, "UTF-8"), URLEncoder.encode(endTime, "UTF-8"));
        for (CollapseType collapseType : collapseTypes) {
            path = String.format("%s&collapse=%s", path, collapseType);
        }
        if (levels != null) {
            path = String.format("%s&levels=%d", path, levels);
        }
        return this.getLineage((NamespacedEntityId)datasetInstance, path);
    }

    @Deprecated
    public LineageRecord getLineage(Id.Stream streamId, long startTime, long endTime, @Nullable Integer levels) throws IOException, UnauthenticatedException, NotFoundException, BadRequestException, UnauthorizedException {
        return this.getLineage(streamId.toEntityId(), startTime, endTime, levels);
    }

    public LineageRecord getLineage(StreamId streamId, long startTime, long endTime, @Nullable Integer levels) throws IOException, UnauthenticatedException, NotFoundException, BadRequestException, UnauthorizedException {
        return this.getLineage(streamId, Long.toString(startTime), Long.toString(endTime), levels);
    }

    @Deprecated
    public LineageRecord getLineage(Id.Stream streamId, long startTime, long endTime, Set<CollapseType> collapseTypes, @Nullable Integer levels) throws IOException, UnauthenticatedException, NotFoundException, BadRequestException, UnauthorizedException {
        return this.getLineage(streamId.toEntityId(), startTime, endTime, collapseTypes, levels);
    }

    public LineageRecord getLineage(StreamId streamId, long startTime, long endTime, Set<CollapseType> collapseTypes, @Nullable Integer levels) throws IOException, UnauthenticatedException, NotFoundException, BadRequestException, UnauthorizedException {
        return this.getLineage(streamId, Long.toString(startTime), Long.toString(endTime), collapseTypes, levels);
    }

    @Deprecated
    public LineageRecord getLineage(Id.Stream streamId, String startTime, String endTime, @Nullable Integer levels) throws IOException, UnauthenticatedException, NotFoundException, BadRequestException, UnauthorizedException {
        return this.getLineage(streamId.toEntityId(), startTime, endTime, levels);
    }

    public LineageRecord getLineage(StreamId streamId, String startTime, String endTime, @Nullable Integer levels) throws IOException, UnauthenticatedException, NotFoundException, BadRequestException, UnauthorizedException {
        return this.getLineage(streamId, startTime, endTime, Collections.emptySet(), levels);
    }

    @Deprecated
    public LineageRecord getLineage(Id.Stream streamId, String startTime, String endTime, Set<CollapseType> collapseTypes, @Nullable Integer levels) throws IOException, UnauthenticatedException, NotFoundException, BadRequestException, UnauthorizedException {
        return this.getLineage(streamId.toEntityId(), startTime, endTime, collapseTypes, levels);
    }

    public LineageRecord getLineage(StreamId streamId, String startTime, String endTime, Set<CollapseType> collapseTypes, @Nullable Integer levels) throws IOException, UnauthenticatedException, NotFoundException, BadRequestException, UnauthorizedException {
        String path = String.format("streams/%s/lineage?start=%s&end=%s", streamId.getStream(), URLEncoder.encode(startTime, "UTF-8"), URLEncoder.encode(endTime, "UTF-8"));
        for (CollapseType collapseType : collapseTypes) {
            path = String.format("%s&collapse=%s", path, collapseType);
        }
        if (levels != null) {
            path = String.format("%s&levels=%d", path, levels);
        }
        return this.getLineage((NamespacedEntityId)streamId, path);
    }

    private LineageRecord getLineage(NamespacedEntityId namespacedId, String path) throws IOException, UnauthenticatedException, NotFoundException, BadRequestException, UnauthorizedException {
        URL lineageURL = this.config.resolveNamespacedURLV3(new NamespaceId(namespacedId.getNamespace()), path);
        HttpResponse response = this.restClient.execute(HttpRequest.get((URL)lineageURL).build(), this.config.getAccessToken(), 400, 404);
        if (response.getResponseCode() == 400) {
            throw new BadRequestException(response.getResponseBodyAsString());
        }
        if (response.getResponseCode() == 404) {
            throw new NotFoundException(response.getResponseBodyAsString());
        }
        return (LineageRecord)GSON.fromJson(response.getResponseBodyAsString(), LineageRecord.class);
    }
}

