/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.api.annotation.Beta;
import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.ConflictException;
import co.cask.cdap.common.DatasetAlreadyExistsException;
import co.cask.cdap.common.DatasetNotFoundException;
import co.cask.cdap.common.DatasetTypeNotFoundException;
import co.cask.cdap.common.NotFoundException;
import co.cask.cdap.common.UnauthenticatedException;
import co.cask.cdap.common.utils.Tasks;
import co.cask.cdap.proto.DatasetInstanceConfiguration;
import co.cask.cdap.proto.DatasetMeta;
import co.cask.cdap.proto.DatasetSpecificationSummary;
import co.cask.cdap.proto.Id;
import co.cask.cdap.proto.id.DatasetId;
import co.cask.cdap.proto.id.EntityId;
import co.cask.cdap.proto.id.NamespaceId;
import co.cask.cdap.security.spi.authorization.UnauthorizedException;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpRequest;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;

@Beta
public class DatasetClient {
    private static final Gson GSON = new Gson();
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public DatasetClient(ClientConfig config, RESTClient restClient) {
        this.config = config;
        this.restClient = restClient;
    }

    public DatasetClient(ClientConfig config) {
        this(config, new RESTClient(config));
    }

    @Deprecated
    public List<DatasetSpecificationSummary> list(Id.Namespace namespace) throws IOException, UnauthenticatedException, UnauthorizedException {
        return this.list(namespace.toEntityId());
    }

    public List<DatasetSpecificationSummary> list(NamespaceId namespace) throws IOException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(namespace, "data/datasets");
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), new int[0]);
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<List<DatasetSpecificationSummary>>(){}).getResponseObject();
    }

    @Deprecated
    public DatasetMeta get(Id.DatasetInstance instance) throws IOException, UnauthenticatedException, NotFoundException, UnauthorizedException {
        return this.get(instance.toEntityId());
    }

    public DatasetMeta get(DatasetId instance) throws IOException, UnauthenticatedException, NotFoundException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(instance.getParent(), String.format("data/datasets/%s", instance.getDataset()));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), new int[0]);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((EntityId)instance);
        }
        return (DatasetMeta)ObjectResponse.fromJsonBody((HttpResponse)response, DatasetMeta.class).getResponseObject();
    }

    @Deprecated
    public void create(Id.DatasetInstance instance, DatasetInstanceConfiguration properties) throws DatasetTypeNotFoundException, DatasetAlreadyExistsException, IOException, UnauthenticatedException, UnauthorizedException {
        this.create(instance.toEntityId(), properties);
    }

    public void create(DatasetId instance, DatasetInstanceConfiguration properties) throws DatasetTypeNotFoundException, DatasetAlreadyExistsException, IOException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(instance.getParent(), String.format("data/datasets/%s", instance.getDataset()));
        HttpRequest request = HttpRequest.put((URL)url).withBody(GSON.toJson((Object)properties)).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 404, 409);
        if (response.getResponseCode() == 404) {
            throw new DatasetTypeNotFoundException(instance.getParent().datasetType(properties.getTypeName()));
        }
        if (response.getResponseCode() == 409) {
            throw new DatasetAlreadyExistsException(instance);
        }
    }

    @Deprecated
    public void create(Id.DatasetInstance instance, String typeName) throws DatasetTypeNotFoundException, DatasetAlreadyExistsException, IOException, UnauthenticatedException, UnauthorizedException {
        this.create(instance.toEntityId(), typeName);
    }

    public void create(DatasetId instance, String typeName) throws DatasetTypeNotFoundException, DatasetAlreadyExistsException, IOException, UnauthenticatedException, UnauthorizedException {
        this.create(instance, new DatasetInstanceConfiguration(typeName, (Map)ImmutableMap.of(), null));
    }

    @Deprecated
    public void update(Id.DatasetInstance instance, Map<String, String> properties) throws NotFoundException, IOException, UnauthenticatedException, ConflictException, UnauthorizedException {
        this.update(instance.toEntityId(), properties);
    }

    public void update(DatasetId instance, Map<String, String> properties) throws NotFoundException, IOException, UnauthenticatedException, ConflictException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(instance.getParent(), String.format("data/datasets/%s/properties", instance.getDataset()));
        HttpRequest request = HttpRequest.put((URL)url).withBody(GSON.toJson(properties)).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 404, 409);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((EntityId)instance);
        }
        if (response.getResponseCode() == 409) {
            throw new ConflictException(response.getResponseBodyAsString());
        }
    }

    @Deprecated
    public void updateExisting(Id.DatasetInstance instance, Map<String, String> properties) throws NotFoundException, IOException, UnauthenticatedException, ConflictException, UnauthorizedException {
        this.updateExisting(instance.toEntityId(), properties);
    }

    public void updateExisting(DatasetId instance, Map<String, String> properties) throws NotFoundException, IOException, UnauthenticatedException, ConflictException, UnauthorizedException {
        DatasetMeta meta = this.get(instance);
        Map existingProperties = meta.getSpec().getProperties();
        HashMap resolvedProperties = Maps.newHashMap();
        resolvedProperties.putAll(existingProperties);
        resolvedProperties.putAll(properties);
        this.update(instance, (Map<String, String>)resolvedProperties);
    }

    @Deprecated
    public void delete(Id.DatasetInstance instance) throws DatasetNotFoundException, IOException, UnauthenticatedException, UnauthorizedException {
        this.delete(instance.toEntityId());
    }

    public void delete(DatasetId instance) throws DatasetNotFoundException, IOException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(instance.getParent(), String.format("data/datasets/%s", instance.getDataset()));
        HttpResponse response = this.restClient.execute(HttpMethod.DELETE, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new DatasetNotFoundException(instance);
        }
    }

    @Deprecated
    public boolean exists(Id.DatasetInstance instance) throws IOException, UnauthenticatedException, UnauthorizedException {
        return this.exists(instance.toEntityId());
    }

    public boolean exists(DatasetId instance) throws IOException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(instance.getParent(), String.format("data/datasets/%s", instance.getDataset()));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        return response.getResponseCode() != 404;
    }

    @Deprecated
    public void waitForExists(final Id.DatasetInstance instance, long timeout, TimeUnit timeoutUnit) throws IOException, UnauthenticatedException, TimeoutException, InterruptedException {
        try {
            Tasks.waitFor((Object)true, (Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return DatasetClient.this.exists(instance.toEntityId());
                }
            }, (long)timeout, (TimeUnit)timeoutUnit, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), IOException.class, UnauthenticatedException.class);
        }
    }

    @Deprecated
    public void waitForDeleted(final Id.DatasetInstance instance, long timeout, TimeUnit timeoutUnit) throws IOException, UnauthenticatedException, TimeoutException, InterruptedException {
        try {
            Tasks.waitFor((Object)false, (Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return DatasetClient.this.exists(instance.toEntityId());
                }
            }, (long)timeout, (TimeUnit)timeoutUnit, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), IOException.class, UnauthenticatedException.class);
        }
    }

    @Deprecated
    public void truncate(Id.DatasetInstance instance) throws IOException, UnauthenticatedException, UnauthorizedException {
        this.truncate(instance.toEntityId());
    }

    public void truncate(DatasetId instance) throws IOException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(instance.getParent(), String.format("data/datasets/%s/admin/truncate", instance.getDataset()));
        this.restClient.execute(HttpMethod.POST, url, this.config.getAccessToken(), new int[0]);
    }

    @Deprecated
    public Map<String, String> getProperties(Id.DatasetInstance instance) throws IOException, UnauthenticatedException, NotFoundException, UnauthorizedException {
        return this.getProperties(instance.toEntityId());
    }

    public Map<String, String> getProperties(DatasetId instance) throws IOException, UnauthenticatedException, NotFoundException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(instance.getParent(), String.format("data/datasets/%s/properties", instance.getDataset()));
        HttpRequest request = HttpRequest.get((URL)url).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), new int[0]);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((EntityId)instance);
        }
        return (Map)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<Map<String, String>>(){}).getResponseObject();
    }
}

