/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.api.Predicate;
import co.cask.cdap.api.annotation.Beta;
import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.FeatureDisabledException;
import co.cask.cdap.common.NotFoundException;
import co.cask.cdap.common.UnauthenticatedException;
import co.cask.cdap.proto.codec.EntityIdTypeAdapter;
import co.cask.cdap.proto.id.EntityId;
import co.cask.cdap.proto.security.Action;
import co.cask.cdap.proto.security.GrantRequest;
import co.cask.cdap.proto.security.Principal;
import co.cask.cdap.proto.security.Privilege;
import co.cask.cdap.proto.security.RevokeRequest;
import co.cask.cdap.proto.security.Role;
import co.cask.cdap.security.spi.authorization.AbstractAuthorizer;
import co.cask.cdap.security.spi.authorization.RoleAlreadyExistsException;
import co.cask.cdap.security.spi.authorization.RoleNotFoundException;
import co.cask.cdap.security.spi.authorization.UnauthorizedException;
import co.cask.common.http.HttpRequest;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Beta
public class AuthorizationClient
extends AbstractAuthorizer {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(EntityId.class, (Object)new EntityIdTypeAdapter()).create();
    public static final String AUTHORIZATION_BASE = "security/authorization/";
    private static final TypeToken<Set<Privilege>> TYPE_OF_PRIVILEGE_SET = new TypeToken<Set<Privilege>>(){};
    private static final TypeToken<Set<Role>> TYPE_OF_ROLE_SET = new TypeToken<Set<Role>>(){};
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public AuthorizationClient(ClientConfig config, RESTClient restClient) {
        this.config = config;
        this.restClient = restClient;
    }

    public AuthorizationClient(ClientConfig config) {
        this(config, new RESTClient(config));
    }

    public void enforce(EntityId entity, Principal principal, Action action) throws Exception {
        this.enforce(entity, principal, Collections.singleton(action));
    }

    public void enforce(EntityId entity, Principal principal, Set<Action> actions) throws Exception {
        throw new UnsupportedOperationException("Enforcement is not supported via Java Client. Please instead use the listPrivileges method to view the privileges for a principal.");
    }

    public Predicate<EntityId> createFilter(Principal principal) throws Exception {
        throw new UnsupportedOperationException("Filtering is not supported via Java Client.");
    }

    public void grant(EntityId entity, Principal principal, Set<Action> actions) throws IOException, UnauthenticatedException, FeatureDisabledException, UnauthorizedException, NotFoundException {
        GrantRequest grantRequest = new GrantRequest(entity, principal, actions);
        URL url = this.config.resolveURLV3("security/authorization//privileges/grant");
        HttpRequest request = HttpRequest.post((URL)url).withBody(GSON.toJson((Object)grantRequest)).build();
        this.executePrivilegeRequest(request);
    }

    public void revoke(EntityId entity) throws IOException, UnauthenticatedException, FeatureDisabledException, UnauthorizedException, NotFoundException {
        this.revoke(entity, null, null);
    }

    public void revoke(EntityId entity, @Nullable Principal principal, @Nullable Set<Action> actions) throws IOException, UnauthenticatedException, FeatureDisabledException, UnauthorizedException, NotFoundException {
        this.revoke(new RevokeRequest(entity, principal, actions));
    }

    public Set<Privilege> listPrivileges(Principal principal) throws IOException, FeatureDisabledException, UnauthenticatedException, UnauthorizedException, NotFoundException {
        URL url = this.config.resolveURLV3(String.format("security/authorization/%s/%s/privileges", principal.getType(), principal.getName()));
        HttpRequest request = HttpRequest.get((URL)url).build();
        HttpResponse response = this.doExecuteRequest(request, new int[0]);
        if (response.getResponseCode() == 200) {
            return (Set)ObjectResponse.fromJsonBody((HttpResponse)response, TYPE_OF_PRIVILEGE_SET, (Gson)GSON).getResponseObject();
        }
        throw new IOException(String.format("Cannot list privileges. Reason: %s", response.getResponseBodyAsString()));
    }

    public void createRole(Role role) throws IOException, FeatureDisabledException, UnauthenticatedException, UnauthorizedException, RoleAlreadyExistsException, NotFoundException {
        URL url = this.config.resolveURLV3(String.format("security/authorization/roles/%s", role.getName()));
        HttpRequest request = HttpRequest.put((URL)url).build();
        HttpResponse httpResponse = this.doExecuteRequest(request, 409);
        if (httpResponse.getResponseCode() == 409) {
            throw new RoleAlreadyExistsException(role);
        }
    }

    public void dropRole(Role role) throws IOException, FeatureDisabledException, UnauthenticatedException, UnauthorizedException, RoleNotFoundException, NotFoundException {
        URL url = this.config.resolveURLV3(String.format("security/authorization/roles/%s", role.getName()));
        HttpRequest request = HttpRequest.delete((URL)url).build();
        this.executeExistingRolesRequest(role, request);
    }

    public Set<Role> listAllRoles() throws FeatureDisabledException, UnauthenticatedException, UnauthorizedException, IOException, NotFoundException {
        return this.listRolesHelper(null);
    }

    public Set<Role> listRoles(Principal principal) throws FeatureDisabledException, UnauthenticatedException, UnauthorizedException, IOException, NotFoundException {
        return this.listRolesHelper(principal);
    }

    public void addRoleToPrincipal(Role role, Principal principal) throws IOException, FeatureDisabledException, UnauthenticatedException, UnauthorizedException, RoleNotFoundException, NotFoundException {
        URL url = this.config.resolveURLV3(String.format("security/authorization/%s/%s/roles/%s", principal.getType(), principal.getName(), role.getName()));
        HttpRequest request = HttpRequest.put((URL)url).build();
        this.executeExistingRolesRequest(role, request);
    }

    public void removeRoleFromPrincipal(Role role, Principal principal) throws IOException, FeatureDisabledException, UnauthenticatedException, UnauthorizedException, RoleNotFoundException, NotFoundException {
        URL url = this.config.resolveURLV3(String.format("security/authorization/%s/%s/roles/%s", principal.getType(), principal.getName(), role.getName()));
        HttpRequest request = HttpRequest.delete((URL)url).build();
        this.executeExistingRolesRequest(role, request);
    }

    private void revoke(RevokeRequest revokeRequest) throws IOException, UnauthenticatedException, FeatureDisabledException, UnauthorizedException, NotFoundException {
        URL url = this.config.resolveURLV3("security/authorization//privileges/revoke");
        HttpRequest request = HttpRequest.post((URL)url).withBody(GSON.toJson((Object)revokeRequest)).build();
        this.executePrivilegeRequest(request);
    }

    private Set<Role> listRolesHelper(@Nullable Principal principal) throws IOException, FeatureDisabledException, UnauthenticatedException, UnauthorizedException, NotFoundException {
        URL url = principal == null ? this.config.resolveURLV3("security/authorization/roles") : this.config.resolveURLV3(String.format("security/authorization/%s/%s/roles", principal.getType(), principal.getName()));
        HttpRequest request = HttpRequest.get((URL)url).build();
        HttpResponse response = this.doExecuteRequest(request, new int[0]);
        if (response.getResponseCode() == 200) {
            return (Set)ObjectResponse.fromJsonBody((HttpResponse)response, TYPE_OF_ROLE_SET).getResponseObject();
        }
        throw new IOException(String.format("Cannot list roles. Reason: %s", response.getResponseBodyAsString()));
    }

    private void executeExistingRolesRequest(Role role, HttpRequest request) throws IOException, UnauthenticatedException, FeatureDisabledException, UnauthorizedException, RoleNotFoundException, NotFoundException {
        HttpResponse httpResponse = this.doExecuteRequest(request, 404);
        if (httpResponse.getResponseCode() == 404) {
            throw new RoleNotFoundException(role);
        }
    }

    private HttpResponse executePrivilegeRequest(HttpRequest request) throws FeatureDisabledException, UnauthenticatedException, IOException, NotFoundException, UnauthorizedException {
        HttpResponse httpResponse = this.doExecuteRequest(request, 404);
        if (404 == httpResponse.getResponseCode()) {
            throw new NotFoundException(httpResponse.getResponseBodyAsString());
        }
        return httpResponse;
    }

    private HttpResponse doExecuteRequest(HttpRequest request, int ... additionalAllowedErrorCodes) throws IOException, UnauthenticatedException, FeatureDisabledException, UnauthorizedException {
        int[] allowedErrorCodes = new int[additionalAllowedErrorCodes.length + 2];
        System.arraycopy(additionalAllowedErrorCodes, 0, allowedErrorCodes, 0, additionalAllowedErrorCodes.length);
        allowedErrorCodes[additionalAllowedErrorCodes.length] = 501;
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), allowedErrorCodes);
        if (501 == response.getResponseCode()) {
            FeatureDisabledException.Feature feature = FeatureDisabledException.Feature.AUTHORIZATION;
            String enableConfig = "security.authorization.enabled";
            if (response.getResponseBodyAsString().toLowerCase().contains("authentication")) {
                feature = FeatureDisabledException.Feature.AUTHENTICATION;
                enableConfig = "security.enabled";
            }
            throw new FeatureDisabledException(feature, "cdap-site.xml", enableConfig, "true");
        }
        return response;
    }
}

