/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.api.annotation.Beta;
import co.cask.cdap.api.artifact.ArtifactScope;
import co.cask.cdap.api.data.schema.Schema;
import co.cask.cdap.api.plugin.PluginClass;
import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.ArtifactAlreadyExistsException;
import co.cask.cdap.common.ArtifactNotFoundException;
import co.cask.cdap.common.ArtifactRangeNotFoundException;
import co.cask.cdap.common.BadRequestException;
import co.cask.cdap.common.NotFoundException;
import co.cask.cdap.common.UnauthenticatedException;
import co.cask.cdap.internal.io.SchemaTypeAdapter;
import co.cask.cdap.proto.Id;
import co.cask.cdap.proto.artifact.ApplicationClassInfo;
import co.cask.cdap.proto.artifact.ApplicationClassSummary;
import co.cask.cdap.proto.artifact.ArtifactInfo;
import co.cask.cdap.proto.artifact.ArtifactRange;
import co.cask.cdap.proto.artifact.ArtifactSummary;
import co.cask.cdap.proto.artifact.PluginInfo;
import co.cask.cdap.proto.artifact.PluginSummary;
import co.cask.cdap.proto.id.ArtifactId;
import co.cask.cdap.proto.id.EntityId;
import co.cask.cdap.proto.id.NamespaceId;
import co.cask.cdap.security.spi.authorization.UnauthorizedException;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpRequest;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import com.google.common.base.Joiner;
import com.google.common.io.InputSupplier;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Beta
public class ArtifactClient {
    private static final Type ARTIFACT_SUMMARIES_TYPE = new TypeToken<List<ArtifactSummary>>(){}.getType();
    private static final Type APPCLASS_SUMMARIES_TYPE = new TypeToken<List<ApplicationClassSummary>>(){}.getType();
    private static final Type APPCLASS_INFOS_TYPE = new TypeToken<List<ApplicationClassInfo>>(){}.getType();
    private static final Type EXTENSIONS_TYPE = new TypeToken<List<String>>(){}.getType();
    private static final Type PLUGIN_SUMMARIES_TYPE = new TypeToken<List<PluginSummary>>(){}.getType();
    private static final Type PLUGIN_INFOS_TYPE = new TypeToken<List<PluginInfo>>(){}.getType();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(Schema.class, (Object)new SchemaTypeAdapter()).create();
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public ArtifactClient(ClientConfig config, RESTClient restClient) {
        this.config = config;
        this.restClient = restClient;
    }

    public ArtifactClient(ClientConfig config) {
        this(config, new RESTClient(config));
    }

    @Deprecated
    public List<ArtifactSummary> list(Id.Namespace namespace) throws IOException, UnauthenticatedException, NotFoundException, UnauthorizedException {
        return this.list(namespace.toEntityId());
    }

    public List<ArtifactSummary> list(NamespaceId namespace) throws IOException, UnauthenticatedException, NotFoundException, UnauthorizedException {
        return this.list(namespace, null);
    }

    @Deprecated
    public List<ArtifactSummary> list(Id.Namespace namespace, @Nullable ArtifactScope scope) throws IOException, UnauthenticatedException, NotFoundException, UnauthorizedException {
        return this.list(namespace.toEntityId(), scope);
    }

    public List<ArtifactSummary> list(NamespaceId namespace, @Nullable ArtifactScope scope) throws IOException, UnauthenticatedException, NotFoundException, UnauthorizedException {
        URL url = scope == null ? this.config.resolveNamespacedURLV3(namespace, "artifacts") : this.config.resolveNamespacedURLV3(namespace, String.format("artifacts?scope=%s", scope.name()));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((EntityId)namespace);
        }
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (Type)ARTIFACT_SUMMARIES_TYPE).getResponseObject();
    }

    @Deprecated
    public List<ArtifactSummary> listVersions(Id.Namespace namespace, String artifactName) throws UnauthenticatedException, IOException, ArtifactNotFoundException, UnauthorizedException {
        return this.listVersions(namespace.toEntityId(), artifactName);
    }

    public List<ArtifactSummary> listVersions(NamespaceId namespace, String artifactName) throws UnauthenticatedException, IOException, ArtifactNotFoundException, UnauthorizedException {
        return this.listVersions(namespace, artifactName, null);
    }

    @Deprecated
    public List<ArtifactSummary> listVersions(Id.Namespace namespace, String artifactName, @Nullable ArtifactScope scope) throws UnauthenticatedException, IOException, ArtifactNotFoundException, UnauthorizedException {
        return this.listVersions(namespace.toEntityId(), artifactName, scope);
    }

    public List<ArtifactSummary> listVersions(NamespaceId namespace, String artifactName, @Nullable ArtifactScope scope) throws UnauthenticatedException, IOException, ArtifactNotFoundException, UnauthorizedException {
        URL url = scope == null ? this.config.resolveNamespacedURLV3(namespace, String.format("artifacts/%s", artifactName)) : this.config.resolveNamespacedURLV3(namespace, String.format("artifacts/%s?scope=%s", artifactName, scope.name()));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ArtifactNotFoundException(namespace, artifactName);
        }
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (Type)ARTIFACT_SUMMARIES_TYPE).getResponseObject();
    }

    @Deprecated
    public ArtifactInfo getArtifactInfo(Id.Artifact artifactId) throws IOException, UnauthenticatedException, ArtifactNotFoundException, UnauthorizedException {
        return this.getArtifactInfo(artifactId.toEntityId());
    }

    public ArtifactInfo getArtifactInfo(ArtifactId artifactId) throws IOException, UnauthenticatedException, ArtifactNotFoundException, UnauthorizedException {
        ArtifactInfo info;
        try {
            info = this.getArtifactInfo(artifactId, ArtifactScope.SYSTEM);
        }
        catch (ArtifactNotFoundException e) {
            info = this.getArtifactInfo(artifactId, ArtifactScope.USER);
        }
        return info;
    }

    @Deprecated
    public ArtifactInfo getArtifactInfo(Id.Artifact artifactId, ArtifactScope scope) throws IOException, UnauthenticatedException, ArtifactNotFoundException, UnauthorizedException {
        return this.getArtifactInfo(artifactId.toEntityId(), scope);
    }

    public ArtifactInfo getArtifactInfo(ArtifactId artifactId, ArtifactScope scope) throws IOException, UnauthenticatedException, ArtifactNotFoundException, UnauthorizedException {
        String path = String.format("artifacts/%s/versions/%s?scope=%s", artifactId.getArtifact(), artifactId.getVersion(), scope.name());
        URL url = this.config.resolveNamespacedURLV3(artifactId.getParent(), path);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ArtifactNotFoundException(artifactId);
        }
        return (ArtifactInfo)ObjectResponse.fromJsonBody((HttpResponse)response, ArtifactInfo.class, (Gson)GSON).getResponseObject();
    }

    @Deprecated
    public List<ApplicationClassSummary> getApplicationClasses(Id.Namespace namespace) throws IOException, UnauthenticatedException, UnauthorizedException {
        return this.getApplicationClasses(namespace.toEntityId());
    }

    public List<ApplicationClassSummary> getApplicationClasses(NamespaceId namespace) throws IOException, UnauthenticatedException, UnauthorizedException {
        return this.getApplicationClasses(namespace, (ArtifactScope)null);
    }

    @Deprecated
    public List<ApplicationClassSummary> getApplicationClasses(Id.Namespace namespace, @Nullable ArtifactScope scope) throws IOException, UnauthenticatedException, UnauthorizedException {
        return this.getApplicationClasses(namespace.toEntityId(), scope);
    }

    public List<ApplicationClassSummary> getApplicationClasses(NamespaceId namespace, @Nullable ArtifactScope scope) throws IOException, UnauthenticatedException, UnauthorizedException {
        String path = scope == null ? "classes/apps" : String.format("classes/apps?scope=%s", scope.name());
        URL url = this.config.resolveNamespacedURLV3(namespace, path);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), new int[0]);
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (Type)APPCLASS_SUMMARIES_TYPE).getResponseObject();
    }

    @Deprecated
    public List<ApplicationClassInfo> getApplicationClasses(Id.Namespace namespace, String className) throws IOException, UnauthenticatedException, UnauthorizedException {
        return this.getApplicationClasses(namespace.toEntityId(), className);
    }

    public List<ApplicationClassInfo> getApplicationClasses(NamespaceId namespace, String className) throws IOException, UnauthenticatedException, UnauthorizedException {
        return this.getApplicationClasses(namespace, className, ArtifactScope.USER);
    }

    @Deprecated
    public List<ApplicationClassInfo> getApplicationClasses(Id.Namespace namespace, String className, ArtifactScope scope) throws IOException, UnauthenticatedException, UnauthorizedException {
        return this.getApplicationClasses(namespace.toEntityId(), className, scope);
    }

    public List<ApplicationClassInfo> getApplicationClasses(NamespaceId namespace, String className, ArtifactScope scope) throws IOException, UnauthenticatedException, UnauthorizedException {
        String path = String.format("classes/apps/%s?scope=%s", className, scope.name());
        URL url = this.config.resolveNamespacedURLV3(namespace, path);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), new int[0]);
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (Type)APPCLASS_INFOS_TYPE, (Gson)GSON).getResponseObject();
    }

    @Deprecated
    public List<String> getPluginTypes(Id.Artifact artifactId) throws IOException, UnauthenticatedException, ArtifactNotFoundException, UnauthorizedException {
        return this.getPluginTypes(artifactId.toEntityId());
    }

    public List<String> getPluginTypes(ArtifactId artifactId) throws IOException, UnauthenticatedException, ArtifactNotFoundException, UnauthorizedException {
        List<String> pluginTypes;
        try {
            pluginTypes = this.getPluginTypes(artifactId, ArtifactScope.SYSTEM);
        }
        catch (ArtifactNotFoundException e) {
            pluginTypes = this.getPluginTypes(artifactId, ArtifactScope.USER);
        }
        return pluginTypes;
    }

    @Deprecated
    public List<String> getPluginTypes(Id.Artifact artifactId, ArtifactScope scope) throws IOException, UnauthenticatedException, ArtifactNotFoundException, UnauthorizedException {
        return this.getPluginTypes(artifactId.toEntityId(), scope);
    }

    public List<String> getPluginTypes(ArtifactId artifactId, ArtifactScope scope) throws IOException, UnauthenticatedException, ArtifactNotFoundException, UnauthorizedException {
        String path = String.format("artifacts/%s/versions/%s/extensions?scope=%s", artifactId.getArtifact(), artifactId.getVersion(), scope.name());
        URL url = this.config.resolveNamespacedURLV3(artifactId.getParent(), path);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ArtifactNotFoundException(artifactId);
        }
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (Type)EXTENSIONS_TYPE).getResponseObject();
    }

    @Deprecated
    public List<PluginSummary> getPluginSummaries(Id.Artifact artifactId, String pluginType) throws IOException, UnauthenticatedException, ArtifactNotFoundException, UnauthorizedException {
        return this.getPluginSummaries(artifactId.toEntityId(), pluginType);
    }

    public List<PluginSummary> getPluginSummaries(ArtifactId artifactId, String pluginType) throws IOException, UnauthenticatedException, ArtifactNotFoundException, UnauthorizedException {
        List<PluginSummary> pluginSummary;
        try {
            pluginSummary = this.getPluginSummaries(artifactId, pluginType, ArtifactScope.SYSTEM);
        }
        catch (ArtifactNotFoundException e) {
            pluginSummary = this.getPluginSummaries(artifactId, pluginType, ArtifactScope.USER);
        }
        return pluginSummary;
    }

    @Deprecated
    public List<PluginSummary> getPluginSummaries(Id.Artifact artifactId, String pluginType, ArtifactScope scope) throws IOException, UnauthenticatedException, ArtifactNotFoundException, UnauthorizedException {
        return this.getPluginSummaries(artifactId.toEntityId(), pluginType, scope);
    }

    public List<PluginSummary> getPluginSummaries(ArtifactId artifactId, String pluginType, ArtifactScope scope) throws IOException, UnauthenticatedException, ArtifactNotFoundException, UnauthorizedException {
        String path = String.format("artifacts/%s/versions/%s/extensions/%s?scope=%s", artifactId.getArtifact(), artifactId.getVersion(), pluginType, scope.name());
        URL url = this.config.resolveNamespacedURLV3(artifactId.getParent(), path);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ArtifactNotFoundException(artifactId);
        }
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (Type)PLUGIN_SUMMARIES_TYPE).getResponseObject();
    }

    @Deprecated
    public List<PluginInfo> getPluginInfo(Id.Artifact artifactId, String pluginType, String pluginName) throws IOException, UnauthenticatedException, NotFoundException, UnauthorizedException {
        return this.getPluginInfo(artifactId.toEntityId(), pluginType, pluginName);
    }

    public List<PluginInfo> getPluginInfo(ArtifactId artifactId, String pluginType, String pluginName) throws IOException, UnauthenticatedException, NotFoundException, UnauthorizedException {
        List<PluginInfo> pluginInfo;
        try {
            pluginInfo = this.getPluginInfo(artifactId, pluginType, pluginName, ArtifactScope.SYSTEM);
        }
        catch (NotFoundException e) {
            pluginInfo = this.getPluginInfo(artifactId, pluginType, pluginName, ArtifactScope.USER);
        }
        return pluginInfo;
    }

    @Deprecated
    public List<PluginInfo> getPluginInfo(Id.Artifact artifactId, String pluginType, String pluginName, ArtifactScope scope) throws IOException, UnauthenticatedException, NotFoundException, UnauthorizedException {
        return this.getPluginInfo(artifactId.toEntityId(), pluginType, pluginName, scope);
    }

    public List<PluginInfo> getPluginInfo(ArtifactId artifactId, String pluginType, String pluginName, ArtifactScope scope) throws IOException, UnauthenticatedException, NotFoundException, UnauthorizedException {
        String path = String.format("artifacts/%s/versions/%s/extensions/%s/plugins/%s?scope=%s", artifactId.getArtifact(), artifactId.getVersion(), pluginType, pluginName, scope.name());
        URL url = this.config.resolveNamespacedURLV3(artifactId.getParent(), path);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException(response.getResponseBodyAsString());
        }
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (Type)PLUGIN_INFOS_TYPE).getResponseObject();
    }

    @Deprecated
    public void add(Id.Artifact artifactId, @Nullable Set<ArtifactRange> parentArtifacts, InputSupplier<? extends InputStream> artifactContents) throws UnauthenticatedException, BadRequestException, ArtifactRangeNotFoundException, ArtifactAlreadyExistsException, IOException, UnauthorizedException {
        this.add(artifactId.toEntityId(), parentArtifacts, artifactContents);
    }

    public void add(ArtifactId artifactId, @Nullable Set<ArtifactRange> parentArtifacts, InputSupplier<? extends InputStream> artifactContents) throws UnauthenticatedException, BadRequestException, ArtifactRangeNotFoundException, ArtifactAlreadyExistsException, IOException, UnauthorizedException {
        this.add(artifactId.getParent(), artifactId.getArtifact(), artifactContents, artifactId.getVersion(), parentArtifacts);
    }

    @Deprecated
    public void add(Id.Namespace namespace, String artifactName, InputSupplier<? extends InputStream> artifactContents, @Nullable String artifactVersion) throws ArtifactAlreadyExistsException, BadRequestException, IOException, UnauthenticatedException, ArtifactRangeNotFoundException, UnauthorizedException {
        this.add(namespace.toEntityId(), artifactName, artifactContents, artifactVersion);
    }

    public void add(NamespaceId namespace, String artifactName, InputSupplier<? extends InputStream> artifactContents, @Nullable String artifactVersion) throws ArtifactAlreadyExistsException, BadRequestException, IOException, UnauthenticatedException, ArtifactRangeNotFoundException, UnauthorizedException {
        this.add(namespace, artifactName, artifactContents, artifactVersion, null, null);
    }

    @Deprecated
    public void add(Id.Namespace namespace, String artifactName, InputSupplier<? extends InputStream> artifactContents, @Nullable String artifactVersion, @Nullable Set<ArtifactRange> parentArtifacts) throws ArtifactAlreadyExistsException, BadRequestException, IOException, UnauthenticatedException, ArtifactRangeNotFoundException, UnauthorizedException {
        this.add(namespace.toEntityId(), artifactName, artifactContents, artifactVersion, parentArtifacts);
    }

    public void add(NamespaceId namespace, String artifactName, InputSupplier<? extends InputStream> artifactContents, @Nullable String artifactVersion, @Nullable Set<ArtifactRange> parentArtifacts) throws ArtifactAlreadyExistsException, BadRequestException, IOException, UnauthenticatedException, ArtifactRangeNotFoundException, UnauthorizedException {
        this.add(namespace, artifactName, artifactContents, artifactVersion, parentArtifacts, null);
    }

    @Deprecated
    public void add(Id.Namespace namespace, String artifactName, InputSupplier<? extends InputStream> artifactContents, @Nullable String artifactVersion, @Nullable Set<ArtifactRange> parentArtifacts, @Nullable Set<PluginClass> additionalPlugins) throws ArtifactAlreadyExistsException, BadRequestException, IOException, UnauthenticatedException, ArtifactRangeNotFoundException, UnauthorizedException {
        this.add(namespace.toEntityId(), artifactName, artifactContents, artifactVersion, parentArtifacts, additionalPlugins);
    }

    public void add(NamespaceId namespace, String artifactName, InputSupplier<? extends InputStream> artifactContents, @Nullable String artifactVersion, @Nullable Set<ArtifactRange> parentArtifacts, @Nullable Set<PluginClass> additionalPlugins) throws ArtifactAlreadyExistsException, BadRequestException, IOException, UnauthenticatedException, ArtifactRangeNotFoundException, UnauthorizedException {
        HttpRequest request;
        HttpResponse response;
        int responseCode;
        URL url = this.config.resolveNamespacedURLV3(namespace, String.format("artifacts/%s", artifactName));
        HttpRequest.Builder requestBuilder = HttpRequest.post((URL)url);
        if (artifactVersion != null) {
            requestBuilder.addHeader("Artifact-Version", artifactVersion);
        }
        if (parentArtifacts != null && !parentArtifacts.isEmpty()) {
            requestBuilder.addHeader("Artifact-Extends", Joiner.on((char)'/').join(parentArtifacts));
        }
        if (additionalPlugins != null && !additionalPlugins.isEmpty()) {
            requestBuilder.addHeader("Artifact-Plugins", GSON.toJson(additionalPlugins));
        }
        if ((responseCode = (response = this.restClient.execute(request = requestBuilder.withBody(artifactContents).build(), this.config.getAccessToken(), 409, 400, 404)).getResponseCode()) == 409) {
            throw new ArtifactAlreadyExistsException(response.getResponseBodyAsString());
        }
        if (responseCode == 400) {
            throw new BadRequestException(response.getResponseBodyAsString());
        }
        if (responseCode == 404) {
            throw new ArtifactRangeNotFoundException(parentArtifacts);
        }
    }

    @Deprecated
    public void delete(Id.Artifact artifactId) throws IOException, UnauthenticatedException, BadRequestException, UnauthorizedException {
        this.delete(artifactId.toEntityId());
    }

    public void delete(ArtifactId artifactId) throws IOException, UnauthenticatedException, BadRequestException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(artifactId.getParent(), String.format("artifacts/%s/versions/%s", artifactId.getArtifact(), artifactId.getVersion()));
        HttpRequest request = HttpRequest.delete((URL)url).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 400);
        int responseCode = response.getResponseCode();
        if (responseCode == 400) {
            throw new BadRequestException(response.getResponseBodyAsString());
        }
    }

    @Deprecated
    public void writeProperties(Id.Artifact artifactId, Map<String, String> properties) throws IOException, UnauthenticatedException, ArtifactNotFoundException, BadRequestException, UnauthorizedException {
        this.writeProperties(artifactId.toEntityId(), properties);
    }

    public void writeProperties(ArtifactId artifactId, Map<String, String> properties) throws IOException, UnauthenticatedException, ArtifactNotFoundException, BadRequestException, UnauthorizedException {
        String path = String.format("artifacts/%s/versions/%s/properties", artifactId.getArtifact(), artifactId.getVersion());
        URL url = this.config.resolveNamespacedURLV3(artifactId.getParent(), path);
        HttpRequest.Builder requestBuilder = HttpRequest.put((URL)url);
        HttpRequest request = requestBuilder.withBody(GSON.toJson(properties)).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 400, 404);
        int responseCode = response.getResponseCode();
        if (responseCode == 404) {
            throw new ArtifactNotFoundException(artifactId);
        }
        if (responseCode == 400) {
            throw new BadRequestException(response.getResponseBodyAsString());
        }
    }

    @Deprecated
    public void deleteProperties(Id.Artifact artifactId) throws IOException, UnauthenticatedException, ArtifactNotFoundException, BadRequestException, UnauthorizedException {
        this.deleteProperties(artifactId.toEntityId());
    }

    public void deleteProperties(ArtifactId artifactId) throws IOException, UnauthenticatedException, ArtifactNotFoundException, BadRequestException, UnauthorizedException {
        String path = String.format("artifacts/%s/versions/%s/properties", artifactId.getArtifact(), artifactId.getVersion());
        URL url = this.config.resolveNamespacedURLV3(artifactId.getParent(), path);
        HttpRequest.Builder requestBuilder = HttpRequest.delete((URL)url);
        HttpRequest request = requestBuilder.build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 400, 404);
        int responseCode = response.getResponseCode();
        if (responseCode == 404) {
            throw new ArtifactNotFoundException(artifactId);
        }
        if (responseCode == 400) {
            throw new BadRequestException(response.getResponseBodyAsString());
        }
    }

    @Deprecated
    public void writeProperty(Id.Artifact artifactId, String key, String value) throws IOException, UnauthenticatedException, ArtifactNotFoundException, BadRequestException, UnauthorizedException {
        this.writeProperty(artifactId.toEntityId(), key, value);
    }

    public void writeProperty(ArtifactId artifactId, String key, String value) throws IOException, UnauthenticatedException, ArtifactNotFoundException, BadRequestException, UnauthorizedException {
        String path = String.format("artifacts/%s/versions/%s/properties/%s", artifactId.getArtifact(), artifactId.getVersion(), key);
        URL url = this.config.resolveNamespacedURLV3(artifactId.getParent(), path);
        HttpRequest.Builder requestBuilder = HttpRequest.put((URL)url);
        HttpRequest request = requestBuilder.withBody(value).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 400, 404);
        int responseCode = response.getResponseCode();
        if (responseCode == 404) {
            throw new ArtifactNotFoundException(artifactId);
        }
        if (responseCode == 400) {
            throw new BadRequestException(response.getResponseBodyAsString());
        }
    }

    @Deprecated
    public void deleteProperty(Id.Artifact artifactId, String key) throws IOException, UnauthenticatedException, ArtifactNotFoundException, BadRequestException, UnauthorizedException {
        this.deleteProperty(artifactId.toEntityId(), key);
    }

    public void deleteProperty(ArtifactId artifactId, String key) throws IOException, UnauthenticatedException, ArtifactNotFoundException, BadRequestException, UnauthorizedException {
        String path = String.format("artifacts/%s/versions/%s/properties/%s", artifactId.getArtifact(), artifactId.getVersion(), key);
        URL url = this.config.resolveNamespacedURLV3(artifactId.getParent(), path);
        HttpRequest.Builder requestBuilder = HttpRequest.delete((URL)url);
        HttpRequest request = requestBuilder.build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 400, 404);
        int responseCode = response.getResponseCode();
        if (responseCode == 404) {
            throw new ArtifactNotFoundException(artifactId);
        }
        if (responseCode == 400) {
            throw new BadRequestException(response.getResponseBodyAsString());
        }
    }
}

