/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.api.Config;
import co.cask.cdap.api.annotation.Beta;
import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.ApplicationNotFoundException;
import co.cask.cdap.common.BadRequestException;
import co.cask.cdap.common.NotFoundException;
import co.cask.cdap.common.UnauthenticatedException;
import co.cask.cdap.common.utils.Tasks;
import co.cask.cdap.proto.ApplicationDetail;
import co.cask.cdap.proto.ApplicationRecord;
import co.cask.cdap.proto.Id;
import co.cask.cdap.proto.PluginInstanceDetail;
import co.cask.cdap.proto.ProgramRecord;
import co.cask.cdap.proto.ProgramType;
import co.cask.cdap.proto.artifact.AppRequest;
import co.cask.cdap.proto.id.ApplicationId;
import co.cask.cdap.proto.id.NamespaceId;
import co.cask.cdap.security.spi.authorization.UnauthorizedException;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpRequest;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Beta
public class ApplicationClient {
    private static final Gson GSON = new Gson();
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public ApplicationClient(ClientConfig config, RESTClient restClient) {
        this.config = config;
        this.restClient = restClient;
    }

    public ApplicationClient(ClientConfig config) {
        this(config, new RESTClient(config));
    }

    @Deprecated
    public List<ApplicationRecord> list(Id.Namespace namespace) throws IOException, UnauthenticatedException, UnauthorizedException {
        return this.list(namespace.toEntityId());
    }

    public List<ApplicationRecord> list(NamespaceId namespace) throws IOException, UnauthenticatedException, UnauthorizedException {
        HttpResponse response = this.restClient.execute(HttpMethod.GET, this.config.resolveNamespacedURLV3(namespace, "apps"), this.config.getAccessToken(), new int[0]);
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<List<ApplicationRecord>>(){}).getResponseObject();
    }

    @Deprecated
    public List<ApplicationRecord> list(Id.Namespace namespace, @Nullable String artifactName, @Nullable String artifactVersion) throws IOException, UnauthenticatedException, UnauthorizedException {
        return this.list(namespace.toEntityId(), artifactName, artifactVersion);
    }

    public List<ApplicationRecord> list(NamespaceId namespace, @Nullable String artifactName, @Nullable String artifactVersion) throws IOException, UnauthenticatedException, UnauthorizedException {
        HashSet<String> names = new HashSet<String>();
        if (artifactName != null) {
            names.add(artifactName);
        }
        return this.list(namespace, names, artifactVersion);
    }

    @Deprecated
    public List<ApplicationRecord> list(Id.Namespace namespace, Set<String> artifactNames, @Nullable String artifactVersion) throws IOException, UnauthenticatedException, UnauthorizedException {
        return this.list(namespace.toEntityId(), artifactNames, artifactVersion);
    }

    public List<ApplicationRecord> list(NamespaceId namespace, Set<String> artifactNames, @Nullable String artifactVersion) throws IOException, UnauthenticatedException, UnauthorizedException {
        if (artifactNames.isEmpty() && artifactVersion == null) {
            return this.list(namespace);
        }
        String path = !artifactNames.isEmpty() && artifactVersion != null ? String.format("apps?artifactName=%s&artifactVersion=%s", Joiner.on((char)',').join(artifactNames), artifactVersion) : (!artifactNames.isEmpty() ? "apps?artifactName=" + Joiner.on((char)',').join(artifactNames) : "apps?artifactVersion=" + artifactVersion);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, this.config.resolveNamespacedURLV3(namespace, path), this.config.getAccessToken(), new int[0]);
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<List<ApplicationRecord>>(){}).getResponseObject();
    }

    public List<String> listAppVersions(NamespaceId namespace, String appName) throws IOException, UnauthenticatedException, UnauthorizedException, ApplicationNotFoundException {
        String path = String.format("apps/%s/versions", appName);
        URL url = this.config.resolveNamespacedURLV3(namespace, path);
        HttpRequest request = HttpRequest.get((URL)url).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ApplicationNotFoundException(namespace.app(appName));
        }
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<List<String>>(){}).getResponseObject();
    }

    @Deprecated
    public ApplicationDetail get(Id.Application appId) throws ApplicationNotFoundException, IOException, UnauthenticatedException, UnauthorizedException {
        return this.get(appId.toEntityId());
    }

    public ApplicationDetail get(ApplicationId appId) throws ApplicationNotFoundException, IOException, UnauthenticatedException, UnauthorizedException {
        String path = String.format("apps/%s/versions/%s", appId.getApplication(), appId.getVersion());
        HttpResponse response = this.restClient.execute(HttpMethod.GET, this.config.resolveNamespacedURLV3(appId.getParent(), path), this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ApplicationNotFoundException(appId);
        }
        return (ApplicationDetail)ObjectResponse.fromJsonBody((HttpResponse)response, ApplicationDetail.class).getResponseObject();
    }

    public List<PluginInstanceDetail> getPlugins(ApplicationId appId) throws ApplicationNotFoundException, IOException, UnauthenticatedException, UnauthorizedException {
        HttpResponse response = this.restClient.execute(HttpMethod.GET, this.config.resolveNamespacedURLV3(appId.getParent(), "apps/" + appId.getApplication() + "/plugins"), this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ApplicationNotFoundException(appId);
        }
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<List<PluginInstanceDetail>>(){}).getResponseObject();
    }

    @Deprecated
    public void delete(Id.Application app) throws ApplicationNotFoundException, IOException, UnauthenticatedException, UnauthorizedException {
        this.delete(app.toEntityId());
    }

    public void delete(ApplicationId app) throws ApplicationNotFoundException, IOException, UnauthenticatedException, UnauthorizedException {
        String path = String.format("apps/%s/versions/%s", app.getApplication(), app.getVersion());
        HttpResponse response = this.restClient.execute(HttpMethod.DELETE, this.config.resolveNamespacedURLV3(app.getParent(), path), this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ApplicationNotFoundException(app);
        }
    }

    @Deprecated
    public void deleteAll(Id.Namespace namespace) throws IOException, UnauthenticatedException, UnauthorizedException {
        this.deleteAll(namespace.toEntityId());
    }

    public void deleteAll(NamespaceId namespace) throws IOException, UnauthenticatedException, UnauthorizedException {
        this.restClient.execute(HttpMethod.DELETE, this.config.resolveNamespacedURLV3(namespace, "apps"), this.config.getAccessToken(), new int[0]);
    }

    @Deprecated
    public boolean exists(Id.Application app) throws IOException, UnauthenticatedException, UnauthorizedException {
        return this.exists(app.toEntityId());
    }

    public boolean exists(ApplicationId app) throws IOException, UnauthenticatedException, UnauthorizedException {
        HttpResponse response = this.restClient.execute(HttpMethod.GET, this.config.resolveNamespacedURLV3(app.getParent(), "apps/" + app.getApplication()), this.config.getAccessToken(), 404);
        return response.getResponseCode() != 404;
    }

    @Deprecated
    public void waitForDeployed(Id.Application app, long timeout, TimeUnit timeoutUnit) throws IOException, UnauthenticatedException, TimeoutException, InterruptedException {
        this.waitForDeployed(app.toEntityId(), timeout, timeoutUnit);
    }

    public void waitForDeployed(final ApplicationId app, long timeout, TimeUnit timeoutUnit) throws IOException, UnauthenticatedException, TimeoutException, InterruptedException {
        try {
            Tasks.waitFor((Object)true, (Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return ApplicationClient.this.exists(app);
                }
            }, (long)timeout, (TimeUnit)timeoutUnit, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), IOException.class, UnauthenticatedException.class);
        }
    }

    @Deprecated
    public void waitForDeleted(Id.Application app, long timeout, TimeUnit timeoutUnit) throws IOException, UnauthenticatedException, TimeoutException, InterruptedException {
        this.waitForDeleted(app.toEntityId(), timeout, timeoutUnit);
    }

    public void waitForDeleted(final ApplicationId app, long timeout, TimeUnit timeoutUnit) throws IOException, UnauthenticatedException, TimeoutException, InterruptedException {
        try {
            Tasks.waitFor((Object)false, (Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return ApplicationClient.this.exists(app);
                }
            }, (long)timeout, (TimeUnit)timeoutUnit, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), IOException.class, UnauthenticatedException.class);
        }
    }

    @Deprecated
    public void deploy(Id.Namespace namespace, File jarFile) throws IOException, UnauthenticatedException {
        this.deploy(namespace.toEntityId(), jarFile);
    }

    public void deploy(NamespaceId namespace, File jarFile) throws IOException, UnauthenticatedException {
        ImmutableMap headers = ImmutableMap.of((Object)"X-Archive-Name", (Object)jarFile.getName());
        this.deployApp(namespace, jarFile, (Map<String, String>)headers);
    }

    @Deprecated
    public void deploy(Id.Namespace namespace, File jarFile, String appConfig) throws IOException, UnauthenticatedException {
        this.deploy(namespace.toEntityId(), jarFile, appConfig);
    }

    public void deploy(NamespaceId namespace, File jarFile, String appConfig) throws IOException, UnauthenticatedException {
        ImmutableMap headers = ImmutableMap.of((Object)"X-Archive-Name", (Object)jarFile.getName(), (Object)"X-App-Config", (Object)appConfig);
        this.deployApp(namespace, jarFile, (Map<String, String>)headers);
    }

    @Deprecated
    public void deploy(Id.Namespace namespace, File jarFile, Config appConfig) throws IOException, UnauthenticatedException {
        this.deploy(namespace.toEntityId(), jarFile, appConfig);
    }

    public void deploy(NamespaceId namespace, File jarFile, Config appConfig) throws IOException, UnauthenticatedException {
        this.deploy(namespace, jarFile, GSON.toJson((Object)appConfig));
    }

    @Deprecated
    public void deploy(Id.Application appId, AppRequest<?> createRequest) throws IOException, UnauthenticatedException {
        this.deploy(appId.toEntityId(), createRequest);
    }

    public void deploy(ApplicationId appId, AppRequest<?> createRequest) throws IOException, UnauthenticatedException {
        URL url = this.config.resolveNamespacedURLV3(new NamespaceId(appId.getNamespace()), String.format("apps/%s/versions/%s/create", appId.getApplication(), appId.getVersion()));
        HttpRequest request = HttpRequest.post((URL)url).addHeader("Content-Type", "application/json").withBody(GSON.toJson(createRequest)).build();
        this.restClient.upload(request, this.config.getAccessToken(), new int[0]);
    }

    @Deprecated
    public void update(Id.Application appId, AppRequest<?> updateRequest) throws IOException, UnauthenticatedException, NotFoundException, BadRequestException, UnauthorizedException {
        this.update(appId.toEntityId(), updateRequest);
    }

    public void update(ApplicationId appId, AppRequest<?> updateRequest) throws IOException, UnauthenticatedException, NotFoundException, BadRequestException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(appId.getParent(), String.format("apps/%s/update", appId.getApplication()));
        HttpRequest request = HttpRequest.post((URL)url).withBody(GSON.toJson(updateRequest)).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 404, 400);
        int responseCode = response.getResponseCode();
        if (responseCode == 404) {
            throw new NotFoundException("app or app artifact");
        }
        if (responseCode == 400) {
            throw new BadRequestException(String.format("Bad Request. Reason: %s", response.getResponseBodyAsString()));
        }
    }

    private void deployApp(NamespaceId namespace, File jarFile, Map<String, String> headers) throws IOException, UnauthenticatedException {
        URL url = this.config.resolveNamespacedURLV3(namespace, "apps");
        HttpRequest request = HttpRequest.post((URL)url).addHeaders(headers).addHeader("Content-Type", "application/octet-stream").withBody(jarFile).build();
        this.restClient.upload(request, this.config.getAccessToken(), new int[0]);
    }

    @Deprecated
    public List<ProgramRecord> listAllPrograms(Id.Namespace namespace, ProgramType programType) throws IOException, UnauthenticatedException, UnauthorizedException {
        return this.listAllPrograms(namespace.toEntityId(), programType);
    }

    public List<ProgramRecord> listAllPrograms(NamespaceId namespace, ProgramType programType) throws IOException, UnauthenticatedException, UnauthorizedException {
        Preconditions.checkArgument((boolean)programType.isListable());
        String path = programType.getCategoryName();
        URL url = this.config.resolveNamespacedURLV3(namespace, path);
        HttpRequest request = HttpRequest.get((URL)url).build();
        ObjectResponse response = ObjectResponse.fromJsonBody((HttpResponse)this.restClient.execute(request, this.config.getAccessToken(), new int[0]), (TypeToken)new TypeToken<List<ProgramRecord>>(){});
        return (List)response.getResponseObject();
    }

    @Deprecated
    public Map<ProgramType, List<ProgramRecord>> listAllPrograms(Id.Namespace namespace) throws IOException, UnauthenticatedException, UnauthorizedException {
        return this.listAllPrograms(namespace.toEntityId());
    }

    public Map<ProgramType, List<ProgramRecord>> listAllPrograms(NamespaceId namespace) throws IOException, UnauthenticatedException, UnauthorizedException {
        ImmutableMap.Builder allPrograms = ImmutableMap.builder();
        for (ProgramType programType : ProgramType.values()) {
            if (!programType.isListable()) continue;
            ArrayList programRecords = Lists.newArrayList();
            programRecords.addAll(this.listAllPrograms(namespace, programType));
            allPrograms.put((Object)programType, (Object)programRecords);
        }
        return allPrograms.build();
    }

    @Deprecated
    public List<ProgramRecord> listPrograms(Id.Application app, ProgramType programType) throws ApplicationNotFoundException, IOException, UnauthenticatedException, UnauthorizedException {
        return this.listPrograms(app.toEntityId(), programType);
    }

    public List<ProgramRecord> listPrograms(ApplicationId app, ProgramType programType) throws ApplicationNotFoundException, IOException, UnauthenticatedException, UnauthorizedException {
        Preconditions.checkArgument((boolean)programType.isListable());
        ArrayList programs = Lists.newArrayList();
        for (ProgramRecord program : this.listPrograms(app)) {
            if (!programType.equals((Object)program.getType())) continue;
            programs.add(program);
        }
        return programs;
    }

    @Deprecated
    public Map<ProgramType, List<ProgramRecord>> listProgramsByType(Id.Application app) throws ApplicationNotFoundException, IOException, UnauthenticatedException, UnauthorizedException {
        return this.listProgramsByType(app.toEntityId());
    }

    public Map<ProgramType, List<ProgramRecord>> listProgramsByType(ApplicationId app) throws ApplicationNotFoundException, IOException, UnauthenticatedException, UnauthorizedException {
        HashMap result = Maps.newHashMap();
        for (ProgramType type : ProgramType.values()) {
            result.put(type, Lists.newArrayList());
        }
        for (ProgramRecord program : this.listPrograms(app)) {
            ((List)result.get(program.getType())).add(program);
        }
        return result;
    }

    @Deprecated
    public List<ProgramRecord> listPrograms(Id.Application app) throws ApplicationNotFoundException, IOException, UnauthenticatedException, UnauthorizedException {
        return this.listPrograms(app.toEntityId());
    }

    public List<ProgramRecord> listPrograms(ApplicationId app) throws ApplicationNotFoundException, IOException, UnauthenticatedException, UnauthorizedException {
        String path = String.format("apps/%s/versions/%s", app.getApplication(), app.getVersion());
        URL url = this.config.resolveNamespacedURLV3(app.getParent(), path);
        HttpRequest request = HttpRequest.get((URL)url).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ApplicationNotFoundException(app);
        }
        return ((ApplicationDetail)ObjectResponse.fromJsonBody((HttpResponse)response, ApplicationDetail.class).getResponseObject()).getPrograms();
    }
}

