/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.api.security.store.SecureStoreMetadata;
import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.AlreadyExistsException;
import co.cask.cdap.common.NamespaceNotFoundException;
import co.cask.cdap.common.SecureKeyAlreadyExistsException;
import co.cask.cdap.common.SecureKeyNotFoundException;
import co.cask.cdap.common.UnauthenticatedException;
import co.cask.cdap.proto.id.NamespaceId;
import co.cask.cdap.proto.id.SecureKeyId;
import co.cask.cdap.proto.security.SecureKeyCreateRequest;
import co.cask.cdap.security.spi.authorization.UnauthorizedException;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.inject.Inject;
import java.io.IOException;
import java.net.URL;
import java.util.Map;

public class SecureStoreClient {
    private static final Gson GSON = new Gson();
    private static final String SECURE_KEYS = "securekeys";
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public SecureStoreClient(ClientConfig config, RESTClient restClient) {
        this.config = config;
        this.restClient = restClient;
    }

    public SecureStoreClient(ClientConfig config) {
        this(config, new RESTClient(config));
    }

    public void createKey(SecureKeyId secureKeyId, SecureKeyCreateRequest keyCreateRequest) throws IOException, UnauthenticatedException, AlreadyExistsException, NamespaceNotFoundException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(secureKeyId.getParent().toId(), SecureStoreClient.getSecureKeyPath(secureKeyId));
        HttpResponse response = this.restClient.execute(HttpMethod.PUT, url, GSON.toJson((Object)keyCreateRequest), null, this.config.getAccessToken(), 404, 409);
        if (response.getResponseCode() == 409) {
            throw new SecureKeyAlreadyExistsException(secureKeyId);
        }
        if (response.getResponseCode() == 404) {
            throw new NamespaceNotFoundException(secureKeyId.getParent().toId());
        }
    }

    public String getData(SecureKeyId secureKeyId) throws IOException, UnauthenticatedException, SecureKeyNotFoundException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(secureKeyId.getParent().toId(), SecureStoreClient.getSecureKeyPath(secureKeyId));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new SecureKeyNotFoundException(secureKeyId);
        }
        return response.getResponseBodyAsString();
    }

    public SecureStoreMetadata getKeyMetadata(SecureKeyId secureKeyId) throws IOException, UnauthenticatedException, SecureKeyNotFoundException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(secureKeyId.getParent().toId(), String.format("%s/metadata", SecureStoreClient.getSecureKeyPath(secureKeyId)));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new SecureKeyNotFoundException(secureKeyId);
        }
        return (SecureStoreMetadata)GSON.fromJson(response.getResponseBodyAsString(), SecureStoreMetadata.class);
    }

    public void deleteKey(SecureKeyId secureKeyId) throws IOException, UnauthenticatedException, SecureKeyNotFoundException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(secureKeyId.getParent().toId(), SecureStoreClient.getSecureKeyPath(secureKeyId));
        HttpResponse response = this.restClient.execute(HttpMethod.DELETE, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new SecureKeyNotFoundException(secureKeyId);
        }
    }

    public Map<String, String> listKeys(NamespaceId namespaceId) throws IOException, UnauthenticatedException, NamespaceNotFoundException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(namespaceId.toId(), SECURE_KEYS);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NamespaceNotFoundException(namespaceId.toId());
        }
        return (Map)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<Map<String, String>>(){}).getResponseObject();
    }

    private static String getSecureKeyPath(SecureKeyId secureKeyId) {
        return String.format("%s/%s", SECURE_KEYS, secureKeyId.getName());
    }
}

