/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.UnauthenticatedException;
import co.cask.cdap.common.metadata.AbstractMetadataClient;
import co.cask.cdap.proto.Id;
import co.cask.cdap.security.spi.authorization.UnauthorizedException;
import co.cask.common.http.HttpRequest;
import co.cask.common.http.HttpResponse;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.inject.Inject;

public class MetadataClient
extends AbstractMetadataClient {
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public MetadataClient(ClientConfig config, RESTClient restClient) {
        this.config = config;
        this.restClient = restClient;
    }

    public MetadataClient(ClientConfig config) {
        this(config, new RESTClient(config));
    }

    protected HttpResponse execute(HttpRequest request, int ... allowedErrorCodes) throws IOException, UnauthenticatedException, UnauthorizedException {
        return this.restClient.execute(request, this.config.getAccessToken(), 400, 404, 403);
    }

    protected URL resolve(Id.Namespace namespace, String resource) throws MalformedURLException {
        return this.config.resolveNamespacedURLV3(namespace, resource);
    }
}

