/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.api.annotation.Beta;
import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.DatasetTypeNotFoundException;
import co.cask.cdap.common.UnauthenticatedException;
import co.cask.cdap.common.utils.Tasks;
import co.cask.cdap.proto.DatasetTypeMeta;
import co.cask.cdap.proto.Id;
import co.cask.cdap.security.spi.authorization.UnauthorizedException;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import com.google.common.base.Throwables;
import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;

@Beta
public class DatasetTypeClient {
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public DatasetTypeClient(ClientConfig config, RESTClient restClient) {
        this.config = config;
        this.restClient = restClient;
    }

    public DatasetTypeClient(ClientConfig config) {
        this(config, new RESTClient(config));
    }

    public List<DatasetTypeMeta> list(Id.Namespace namespace) throws IOException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(namespace, "data/types");
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), new int[0]);
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<List<DatasetTypeMeta>>(){}).getResponseObject();
    }

    public DatasetTypeMeta get(Id.DatasetType type) throws DatasetTypeNotFoundException, IOException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(type.getNamespace(), String.format("data/types/%s", type.getId()));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new DatasetTypeNotFoundException(type);
        }
        return (DatasetTypeMeta)ObjectResponse.fromJsonBody((HttpResponse)response, DatasetTypeMeta.class).getResponseObject();
    }

    public boolean exists(Id.DatasetType type) throws DatasetTypeNotFoundException, IOException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(type.getNamespace(), String.format("data/types/%s", type.getId()));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        return response.getResponseCode() != 404;
    }

    public void waitForExists(final Id.DatasetType type, long timeout, TimeUnit timeoutUnit) throws IOException, UnauthenticatedException, TimeoutException, InterruptedException {
        try {
            Tasks.waitFor((Object)true, (Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return DatasetTypeClient.this.exists(type);
                }
            }, (long)timeout, (TimeUnit)timeoutUnit, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), IOException.class, UnauthenticatedException.class);
        }
    }

    public void waitForDeleted(final Id.DatasetType type, long timeout, TimeUnit timeoutUnit) throws IOException, UnauthenticatedException, TimeoutException, InterruptedException {
        try {
            Tasks.waitFor((Object)false, (Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return DatasetTypeClient.this.exists(type);
                }
            }, (long)timeout, (TimeUnit)timeoutUnit, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), IOException.class, UnauthenticatedException.class);
        }
    }
}

