/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.api.annotation.Beta;
import co.cask.cdap.api.data.schema.Schema;
import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.NotFoundException;
import co.cask.cdap.common.UnauthenticatedException;
import co.cask.cdap.internal.io.SchemaTypeAdapter;
import co.cask.cdap.proto.Id;
import co.cask.cdap.proto.ViewDetail;
import co.cask.cdap.proto.ViewSpecification;
import co.cask.cdap.security.spi.authorization.UnauthorizedException;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpRequest;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.inject.Inject;

@Beta
public class StreamViewClient {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(Schema.class, (Object)new SchemaTypeAdapter()).create();
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public StreamViewClient(ClientConfig config, RESTClient restClient) {
        this.config = config;
        this.restClient = restClient;
    }

    public StreamViewClient(ClientConfig config) {
        this(config, new RESTClient(config));
    }

    public boolean createOrUpdate(Id.Stream.View id, ViewSpecification viewSpecification) throws NotFoundException, IOException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(id.getNamespace(), String.format("streams/%s/views/%s", id.getStreamId(), id.getId()));
        HttpRequest request = HttpRequest.put((URL)url).withBody(GSON.toJson((Object)viewSpecification)).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), new int[0]);
        return response.getResponseCode() == 201;
    }

    public void delete(Id.Stream.View id) throws IOException, UnauthenticatedException, NotFoundException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(id.getNamespace(), String.format("streams/%s/views/%s", id.getStreamId(), id.getId()));
        HttpResponse response = this.restClient.execute(HttpMethod.DELETE, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((Id)id);
        }
    }

    public List<String> list(Id.Stream stream) throws IOException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(stream.getNamespace(), String.format("streams/%s/views", stream.getId()));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), new int[0]);
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<List<String>>(){}).getResponseObject();
    }

    public ViewDetail get(Id.Stream.View id) throws NotFoundException, IOException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(id.getNamespace(), String.format("streams/%s/views/%s", id.getStreamId(), id.getId()));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((Id)id);
        }
        return (ViewDetail)ObjectResponse.fromJsonBody((HttpResponse)response, ViewDetail.class, (Gson)GSON).getResponseObject();
    }
}

