/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.api.annotation.Beta;
import co.cask.cdap.api.customaction.CustomActionSpecification;
import co.cask.cdap.api.workflow.WorkflowActionNode;
import co.cask.cdap.api.workflow.WorkflowActionSpecification;
import co.cask.cdap.client.ApplicationClient;
import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.NotFoundException;
import co.cask.cdap.common.ProgramNotFoundException;
import co.cask.cdap.common.UnauthenticatedException;
import co.cask.cdap.common.io.CaseInsensitiveEnumTypeAdapterFactory;
import co.cask.cdap.common.utils.Tasks;
import co.cask.cdap.proto.BatchProgram;
import co.cask.cdap.proto.BatchProgramResult;
import co.cask.cdap.proto.BatchProgramStart;
import co.cask.cdap.proto.BatchProgramStatus;
import co.cask.cdap.proto.DistributedProgramLiveInfo;
import co.cask.cdap.proto.Id;
import co.cask.cdap.proto.Instances;
import co.cask.cdap.proto.ProgramRecord;
import co.cask.cdap.proto.ProgramRunStatus;
import co.cask.cdap.proto.ProgramType;
import co.cask.cdap.proto.RunRecord;
import co.cask.cdap.proto.codec.CustomActionSpecificationCodec;
import co.cask.cdap.proto.codec.WorkflowActionSpecificationCodec;
import co.cask.cdap.security.spi.authorization.UnauthorizedException;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpRequest;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Beta
public class ProgramClient {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(WorkflowActionSpecification.class, (Object)new WorkflowActionSpecificationCodec()).registerTypeAdapter(CustomActionSpecification.class, (Object)new CustomActionSpecificationCodec()).registerTypeAdapterFactory((TypeAdapterFactory)new CaseInsensitiveEnumTypeAdapterFactory()).create();
    private static final Type BATCH_STATUS_RESPONSE_TYPE = new TypeToken<List<BatchProgramStatus>>(){}.getType();
    private static final Type BATCH_RESULTS_TYPE = new TypeToken<List<BatchProgramResult>>(){}.getType();
    private static final Type MAP_STRING_STRING_TYPE = new TypeToken<Map<String, String>>(){}.getType();
    private final RESTClient restClient;
    private final ClientConfig config;
    private final ApplicationClient applicationClient;

    @Inject
    public ProgramClient(ClientConfig config, RESTClient restClient, ApplicationClient applicationClient) {
        this.config = config;
        this.restClient = restClient;
        this.applicationClient = applicationClient;
    }

    public ProgramClient(ClientConfig config) {
        this(config, new RESTClient(config));
    }

    public ProgramClient(ClientConfig config, RESTClient restClient) {
        this(config, restClient, new ApplicationClient(config, restClient));
    }

    public void start(Id.Program program, boolean debug, @Nullable Map<String, String> runtimeArgs) throws IOException, ProgramNotFoundException, UnauthenticatedException, UnauthorizedException {
        HttpResponse response;
        String action = debug ? "debug" : "start";
        String path = String.format("apps/%s/%s/%s/%s", program.getApplicationId(), program.getType().getCategoryName(), program.getId(), action);
        URL url = this.config.resolveNamespacedURLV3(program.getNamespace(), path);
        HttpRequest.Builder request = HttpRequest.post((URL)url);
        if (runtimeArgs != null) {
            request.withBody(GSON.toJson(runtimeArgs));
        }
        if ((response = this.restClient.execute(request.build(), this.config.getAccessToken(), 404)).getResponseCode() == 404) {
            throw new ProgramNotFoundException(program);
        }
    }

    public void start(Id.Program program, boolean debug) throws IOException, ProgramNotFoundException, UnauthenticatedException, UnauthorizedException {
        this.start(program, debug, null);
    }

    public void start(Id.Program program) throws IOException, ProgramNotFoundException, UnauthenticatedException, UnauthorizedException {
        this.start(program, false, null);
    }

    public List<BatchProgramResult> start(Id.Namespace namespace, List<BatchProgramStart> programs) throws IOException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(namespace, "start");
        HttpRequest request = HttpRequest.builder((HttpMethod)HttpMethod.POST, (URL)url).withBody(GSON.toJson(programs), Charsets.UTF_8).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), new int[0]);
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (Type)BATCH_RESULTS_TYPE, (Gson)GSON).getResponseObject();
    }

    public void stop(Id.Program program) throws IOException, ProgramNotFoundException, UnauthenticatedException, UnauthorizedException {
        String path = String.format("apps/%s/%s/%s/stop", program.getApplicationId(), program.getType().getCategoryName(), program.getId());
        URL url = this.config.resolveNamespacedURLV3(program.getNamespace(), path);
        HttpResponse response = this.restClient.execute(HttpMethod.POST, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ProgramNotFoundException(program);
        }
    }

    public List<BatchProgramResult> stop(Id.Namespace namespace, List<BatchProgram> programs) throws IOException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(namespace, "stop");
        HttpRequest request = HttpRequest.builder((HttpMethod)HttpMethod.POST, (URL)url).withBody(GSON.toJson(programs), Charsets.UTF_8).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), new int[0]);
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (Type)BATCH_RESULTS_TYPE, (Gson)GSON).getResponseObject();
    }

    public void stopAll(Id.Namespace namespace) throws IOException, UnauthenticatedException, InterruptedException, TimeoutException, UnauthorizedException {
        Map<ProgramType, List<ProgramRecord>> allPrograms = this.applicationClient.listAllPrograms(namespace);
        for (Map.Entry<ProgramType, List<ProgramRecord>> entry : allPrograms.entrySet()) {
            ProgramType programType = entry.getKey();
            List<ProgramRecord> programRecords = entry.getValue();
            for (ProgramRecord programRecord : programRecords) {
                try {
                    Id.Program program = Id.Program.from((Id.Namespace)namespace, (String)programRecord.getApp(), (ProgramType)programType, (String)programRecord.getName());
                    String status = this.getStatus(program);
                    if (status.equals("STOPPED")) continue;
                    this.stop(program);
                    this.waitForStatus(program, "STOPPED", 60L, TimeUnit.SECONDS);
                }
                catch (ProgramNotFoundException e) {}
            }
        }
    }

    public String getStatus(Id.Program program) throws IOException, ProgramNotFoundException, UnauthenticatedException, UnauthorizedException {
        String path = String.format("apps/%s/%s/%s/status", program.getApplicationId(), program.getType().getCategoryName(), program.getId());
        URL url = this.config.resolveNamespacedURLV3(program.getNamespace(), path);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (404 == response.getResponseCode()) {
            throw new ProgramNotFoundException(program);
        }
        Map responseObject = (Map)ObjectResponse.fromJsonBody((HttpResponse)response, (Type)MAP_STRING_STRING_TYPE, (Gson)GSON).getResponseObject();
        return (String)responseObject.get("status");
    }

    public List<BatchProgramStatus> getStatus(Id.Namespace namespace, List<BatchProgram> programs) throws IOException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(namespace, "status");
        HttpRequest request = HttpRequest.post((URL)url).withBody(GSON.toJson(programs)).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), new int[0]);
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (Type)BATCH_STATUS_RESPONSE_TYPE, (Gson)GSON).getResponseObject();
    }

    public void waitForStatus(final Id.Program program, String status, long timeout, TimeUnit timeoutUnit) throws UnauthenticatedException, IOException, ProgramNotFoundException, TimeoutException, InterruptedException {
        try {
            Tasks.waitFor((Object)status, (Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return ProgramClient.this.getStatus(program);
                }
            }, (long)timeout, (TimeUnit)timeoutUnit, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), UnauthenticatedException.class);
            Throwables.propagateIfPossible((Throwable)e.getCause(), ProgramNotFoundException.class);
            Throwables.propagateIfPossible((Throwable)e.getCause(), IOException.class);
        }
    }

    public DistributedProgramLiveInfo getLiveInfo(Id.Program program) throws IOException, ProgramNotFoundException, UnauthenticatedException, UnauthorizedException {
        String path = String.format("apps/%s/%s/%s/live-info", program.getApplicationId(), program.getType().getCategoryName(), program.getId());
        URL url = this.config.resolveNamespacedURLV3(program.getNamespace(), path);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ProgramNotFoundException(program);
        }
        return (DistributedProgramLiveInfo)ObjectResponse.fromJsonBody((HttpResponse)response, DistributedProgramLiveInfo.class).getResponseObject();
    }

    public int getFlowletInstances(Id.Flow.Flowlet flowlet) throws IOException, NotFoundException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(flowlet.getNamespace(), String.format("apps/%s/flows/%s/flowlets/%s/instances", flowlet.getFlow().getApplicationId(), flowlet.getFlow().getId(), flowlet.getId()));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((Id)flowlet);
        }
        return ((Instances)ObjectResponse.fromJsonBody((HttpResponse)response, Instances.class).getResponseObject()).getInstances();
    }

    public void setFlowletInstances(Id.Flow.Flowlet flowlet, int instances) throws IOException, NotFoundException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(flowlet.getNamespace(), String.format("apps/%s/flows/%s/flowlets/%s/instances", flowlet.getFlow().getApplicationId(), flowlet.getFlow().getId(), flowlet.getId()));
        HttpRequest request = HttpRequest.put((URL)url).withBody(GSON.toJson((Object)new Instances(instances))).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((Id)flowlet);
        }
    }

    public int getWorkerInstances(Id.Worker worker) throws IOException, NotFoundException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(worker.getNamespace(), String.format("apps/%s/workers/%s/instances", worker.getApplicationId(), worker.getId()));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((Id)worker);
        }
        return ((Instances)ObjectResponse.fromJsonBody((HttpResponse)response, Instances.class).getResponseObject()).getInstances();
    }

    public void setWorkerInstances(Id.Worker worker, int instances) throws IOException, NotFoundException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(worker.getNamespace(), String.format("apps/%s/workers/%s/instances", worker.getApplicationId(), worker.getId()));
        HttpRequest request = HttpRequest.put((URL)url).withBody(GSON.toJson((Object)new Instances(instances))).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((Id)worker);
        }
    }

    public int getServiceInstances(Id.Service service) throws IOException, NotFoundException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(service.getNamespace(), String.format("apps/%s/services/%s/instances", service.getApplicationId(), service.getId()));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((Id)service);
        }
        return ((Instances)ObjectResponse.fromJsonBody((HttpResponse)response, Instances.class).getResponseObject()).getInstances();
    }

    public void setServiceInstances(Id.Service service, int instances) throws IOException, NotFoundException, UnauthenticatedException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(service.getNamespace(), String.format("apps/%s/services/%s/instances", service.getApplicationId(), service.getId()));
        HttpRequest request = HttpRequest.put((URL)url).withBody(GSON.toJson((Object)new Instances(instances))).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((Id)service);
        }
    }

    public List<WorkflowActionNode> getWorkflowCurrent(Id.Application appId, String workflowId, String runId) throws IOException, NotFoundException, UnauthenticatedException, UnauthorizedException {
        String path = String.format("/apps/%s/workflows/%s/runs/%s/current", appId.getId(), workflowId, runId);
        URL url = this.config.resolveNamespacedURLV3(appId.getNamespace(), path);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            Id.Program program = Id.Program.from((Id.Application)appId, (ProgramType)ProgramType.WORKFLOW, (String)workflowId);
            throw new NotFoundException((Id)new Id.Run(program, runId));
        }
        ObjectResponse objectResponse = ObjectResponse.fromJsonBody((HttpResponse)response, (Type)new TypeToken<List<WorkflowActionNode>>(){}.getType(), (Gson)GSON);
        return (List)objectResponse.getResponseObject();
    }

    public List<RunRecord> getProgramRuns(Id.Program program, String state, long startTime, long endTime, int limit) throws IOException, NotFoundException, UnauthenticatedException, UnauthorizedException {
        String queryParams = String.format("%s=%s&%s=%d&%s=%d&%s=%d", "status", state, "start", startTime, "end", endTime, "limit", limit);
        String path = String.format("apps/%s/%s/%s/runs?%s", program.getApplicationId(), program.getType().getCategoryName(), program.getId(), queryParams);
        URL url = this.config.resolveNamespacedURLV3(program.getNamespace(), path);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((Id)program);
        }
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<List<RunRecord>>(){}).getResponseObject();
    }

    public List<RunRecord> getAllProgramRuns(Id.Program program, long startTime, long endTime, int limit) throws IOException, NotFoundException, UnauthenticatedException, UnauthorizedException {
        return this.getProgramRuns(program, ProgramRunStatus.ALL.name(), startTime, endTime, limit);
    }

    public String getProgramLogs(Id.Program program, long start, long stop) throws IOException, NotFoundException, UnauthenticatedException, UnauthorizedException {
        String path = String.format("apps/%s/%s/%s/logs?start=%d&stop=%d", program.getApplicationId(), program.getType().getCategoryName(), program.getId(), start, stop);
        URL url = this.config.resolveNamespacedURLV3(program.getNamespace(), path);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), new int[0]);
        if (response.getResponseCode() == 404) {
            throw new ProgramNotFoundException(program);
        }
        return new String(response.getResponseBody(), Charsets.UTF_8);
    }

    public Map<String, String> getRuntimeArgs(Id.Program program) throws IOException, UnauthenticatedException, ProgramNotFoundException, UnauthorizedException {
        String path = String.format("apps/%s/%s/%s/runtimeargs", program.getApplicationId(), program.getType().getCategoryName(), program.getId());
        URL url = this.config.resolveNamespacedURLV3(program.getNamespace(), path);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ProgramNotFoundException(program);
        }
        return (Map)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<Map<String, String>>(){}).getResponseObject();
    }

    public void setRuntimeArgs(Id.Program program, Map<String, String> runtimeArgs) throws IOException, UnauthenticatedException, ProgramNotFoundException, UnauthorizedException {
        String path = String.format("apps/%s/%s/%s/runtimeargs", program.getApplicationId(), program.getType().getCategoryName(), program.getId());
        URL url = this.config.resolveNamespacedURLV3(program.getNamespace(), path);
        HttpRequest request = HttpRequest.put((URL)url).withBody(GSON.toJson(runtimeArgs)).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ProgramNotFoundException(program);
        }
    }
}

