/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.api.annotation.Beta;
import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.NotFoundException;
import co.cask.cdap.common.ProgramNotFoundException;
import co.cask.cdap.common.UnauthenticatedException;
import co.cask.cdap.proto.Id;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.inject.Inject;
import java.io.IOException;
import java.net.URL;
import java.util.Map;

@Beta
public class PreferencesClient {
    private static final Gson GSON = new Gson();
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public PreferencesClient(ClientConfig config, RESTClient restClient) {
        this.config = config;
        this.restClient = restClient;
    }

    public PreferencesClient(ClientConfig config) {
        this(config, new RESTClient(config));
    }

    public Map<String, String> getInstancePreferences() throws IOException, UnauthenticatedException {
        URL url = this.config.resolveURLV3("preferences");
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), new int[0]);
        return (Map)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<Map<String, String>>(){}).getResponseObject();
    }

    public void setInstancePreferences(Map<String, String> preferences) throws IOException, UnauthenticatedException {
        URL url = this.config.resolveURLV3("preferences");
        this.restClient.execute(HttpMethod.PUT, url, GSON.toJson(preferences), null, this.config.getAccessToken(), new int[0]);
    }

    public void deleteInstancePreferences() throws IOException, UnauthenticatedException {
        URL url = this.config.resolveURLV3("preferences");
        this.restClient.execute(HttpMethod.DELETE, url, this.config.getAccessToken(), new int[0]);
    }

    public Map<String, String> getNamespacePreferences(Id.Namespace namespace, boolean resolved) throws IOException, UnauthenticatedException, NotFoundException {
        String res = Boolean.toString(resolved);
        URL url = this.config.resolveURLV3(String.format("namespaces/%s/preferences?resolved=%s", namespace.getId(), res));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((Id)namespace);
        }
        return (Map)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<Map<String, String>>(){}).getResponseObject();
    }

    public void setNamespacePreferences(Id.Namespace namespace, Map<String, String> preferences) throws IOException, UnauthenticatedException, NotFoundException {
        URL url = this.config.resolveURLV3(String.format("namespaces/%s/preferences", namespace.getId()));
        HttpResponse response = this.restClient.execute(HttpMethod.PUT, url, GSON.toJson(preferences), null, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((Id)namespace);
        }
    }

    public void deleteNamespacePreferences(Id.Namespace namespace) throws IOException, UnauthenticatedException, NotFoundException {
        URL url = this.config.resolveURLV3(String.format("namespaces/%s/preferences", namespace.getId()));
        HttpResponse response = this.restClient.execute(HttpMethod.DELETE, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((Id)namespace);
        }
    }

    public Map<String, String> getApplicationPreferences(Id.Application application, boolean resolved) throws IOException, UnauthenticatedException, NotFoundException {
        String res = Boolean.toString(resolved);
        URL url = this.config.resolveURLV3(String.format("namespaces/%s/apps/%s/preferences?resolved=%s", application.getNamespaceId(), application.getId(), res));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((Id)application);
        }
        return (Map)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<Map<String, String>>(){}).getResponseObject();
    }

    public void setApplicationPreferences(Id.Application application, Map<String, String> preferences) throws IOException, UnauthenticatedException, NotFoundException {
        URL url = this.config.resolveURLV3(String.format("namespaces/%s/apps/%s/preferences", application.getNamespaceId(), application.getId()));
        HttpResponse response = this.restClient.execute(HttpMethod.PUT, url, GSON.toJson(preferences), null, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((Id)application);
        }
    }

    public void deleteApplicationPreferences(Id.Application application) throws IOException, UnauthenticatedException, NotFoundException {
        URL url = this.config.resolveURLV3(String.format("namespaces/%s/apps/%s/preferences", application.getNamespaceId(), application.getId()));
        HttpResponse response = this.restClient.execute(HttpMethod.DELETE, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((Id)application);
        }
    }

    public Map<String, String> getProgramPreferences(Id.Program program, boolean resolved) throws IOException, UnauthenticatedException, ProgramNotFoundException {
        String res = Boolean.toString(resolved);
        URL url = this.config.resolveURLV3(String.format("namespaces/%s/apps/%s/%s/%s/preferences?resolved=%s", program.getNamespaceId(), program.getApplicationId(), program.getType().getCategoryName(), program.getId(), res));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ProgramNotFoundException(program);
        }
        return (Map)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<Map<String, String>>(){}).getResponseObject();
    }

    public void setProgramPreferences(Id.Program program, Map<String, String> preferences) throws IOException, UnauthenticatedException, ProgramNotFoundException {
        URL url = this.config.resolveURLV3(String.format("/namespaces/%s/apps/%s/%s/%s/preferences", program.getNamespaceId(), program.getApplicationId(), program.getType().getCategoryName(), program.getId()));
        HttpResponse response = this.restClient.execute(HttpMethod.PUT, url, GSON.toJson(preferences), null, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ProgramNotFoundException(program);
        }
    }

    public void deleteProgramPreferences(Id.Program program) throws IOException, UnauthenticatedException, ProgramNotFoundException {
        URL url = this.config.resolveURLV3(String.format("namespaces/%s/apps/%s/%s/%s/preferences", program.getNamespaceId(), program.getApplicationId(), program.getType().getCategoryName(), program.getId()));
        HttpResponse response = this.restClient.execute(HttpMethod.DELETE, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ProgramNotFoundException(program);
        }
    }
}

