/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client.util;

import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.exception.DisconnectedException;
import co.cask.cdap.common.UnauthorizedException;
import co.cask.cdap.security.authentication.client.AccessToken;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpRequest;
import co.cask.common.http.HttpRequestConfig;
import co.cask.common.http.HttpRequests;
import co.cask.common.http.HttpResponse;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.ArrayUtils;

public class RESTClient {
    private final List<Listener> listeners;
    private final ClientConfig clientConfig;

    @Inject
    public RESTClient(ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        this.listeners = Lists.newArrayList();
    }

    public RESTClient() {
        this(ClientConfig.getDefault());
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public boolean removeListener(Listener listener) {
        return this.listeners.remove(listener);
    }

    public HttpResponse execute(HttpRequest request, AccessToken accessToken, int ... allowedErrorCodes) throws IOException, UnauthorizedException, DisconnectedException {
        return this.execute(HttpRequest.builder((HttpRequest)request).addHeaders(this.getAuthHeaders(accessToken)).build(), allowedErrorCodes);
    }

    public HttpResponse execute(HttpMethod httpMethod, URL url, AccessToken accessToken, int ... allowedErrorCodes) throws IOException, UnauthorizedException, DisconnectedException {
        return this.execute(HttpRequest.builder((HttpMethod)httpMethod, (URL)url).addHeaders(this.getAuthHeaders(accessToken)).build(), allowedErrorCodes);
    }

    public HttpResponse execute(HttpMethod httpMethod, URL url, Map<String, String> headers, AccessToken accessToken, int ... allowedErrorCodes) throws IOException, UnauthorizedException, DisconnectedException {
        return this.execute(HttpRequest.builder((HttpMethod)httpMethod, (URL)url).addHeaders(headers).addHeaders(this.getAuthHeaders(accessToken)).build(), allowedErrorCodes);
    }

    public HttpResponse execute(HttpMethod httpMethod, URL url, String body, Map<String, String> headers, AccessToken accessToken, int ... allowedErrorCodes) throws IOException, UnauthorizedException, DisconnectedException {
        return this.execute(HttpRequest.builder((HttpMethod)httpMethod, (URL)url).addHeaders(headers).addHeaders(this.getAuthHeaders(accessToken)).withBody(body).build(), allowedErrorCodes);
    }

    private HttpResponse execute(HttpRequest request, int ... allowedErrorCodes) throws IOException, UnauthorizedException, DisconnectedException {
        HttpResponse response;
        int currentTry = 0;
        do {
            this.onRequest(request, currentTry);
            response = HttpRequests.execute((HttpRequest)request, (HttpRequestConfig)this.clientConfig.getDefaultRequestConfig());
            if (response.getResponseCode() != 503) break;
            ++currentTry;
            try {
                TimeUnit.MILLISECONDS.sleep(1000L);
            }
            catch (InterruptedException e) {
                break;
            }
        } while (currentTry <= this.clientConfig.getUnavailableRetryLimit());
        this.onResponse(request, response, currentTry);
        int responseCode = response.getResponseCode();
        if (responseCode == 401) {
            throw new UnauthorizedException("Unauthorized status code received from the server.");
        }
        if (!this.isSuccessful(responseCode) && !ArrayUtils.contains((int[])allowedErrorCodes, (int)responseCode)) {
            throw new IOException(responseCode + ": " + response.getResponseBodyAsString());
        }
        return response;
    }

    private void onRequest(HttpRequest request, int attempt) {
        for (Listener listener : this.listeners) {
            listener.onRequest(request, attempt);
        }
    }

    private void onResponse(HttpRequest request, HttpResponse response, int attemptsMade) {
        for (Listener listener : this.listeners) {
            listener.onResponse(request, response, attemptsMade);
        }
    }

    public HttpResponse upload(HttpRequest request, AccessToken accessToken, int ... allowedErrorCodes) throws IOException, UnauthorizedException, DisconnectedException {
        HttpResponse response = HttpRequests.execute((HttpRequest)HttpRequest.builder((HttpRequest)request).addHeaders(this.getAuthHeaders(accessToken)).build(), (HttpRequestConfig)this.clientConfig.getUploadRequestConfig());
        int responseCode = response.getResponseCode();
        if (!this.isSuccessful(responseCode) && !ArrayUtils.contains((int[])allowedErrorCodes, (int)responseCode)) {
            if (responseCode == 401) {
                throw new UnauthorizedException("Unauthorized status code received from the server.");
            }
            throw new IOException(response.getResponseBodyAsString());
        }
        return response;
    }

    private boolean isSuccessful(int responseCode) {
        return 200 <= responseCode && responseCode <= 299;
    }

    private Map<String, String> getAuthHeaders(AccessToken accessToken) {
        ImmutableMap headers = ImmutableMap.of();
        if (accessToken != null) {
            headers = ImmutableMap.of((Object)"Authorization", (Object)(accessToken.getTokenType() + " " + accessToken.getValue()));
        }
        return headers;
    }

    public static interface Listener {
        public void onRequest(HttpRequest var1, int var2);

        public void onResponse(HttpRequest var1, HttpResponse var2, int var3);
    }
}

