/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.api.annotation.Beta;
import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.UnauthorizedException;
import co.cask.cdap.proto.codec.EntityIdTypeAdapter;
import co.cask.cdap.proto.id.EntityId;
import co.cask.cdap.proto.security.Action;
import co.cask.cdap.proto.security.CheckAuthorizedRequest;
import co.cask.cdap.proto.security.CheckAuthorizedResponse;
import co.cask.cdap.proto.security.GrantRequest;
import co.cask.cdap.proto.security.RevokeRequest;
import co.cask.common.http.HttpRequest;
import co.cask.common.http.HttpResponse;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.net.URL;
import java.util.Set;
import javax.inject.Inject;

@Beta
public class AuthorizationClient {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(EntityId.class, (Object)new EntityIdTypeAdapter()).create();
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public AuthorizationClient(ClientConfig config, RESTClient restClient) {
        this.config = config;
        this.restClient = restClient;
    }

    public AuthorizationClient(ClientConfig config) {
        this(config, new RESTClient(config));
    }

    public boolean authorized(EntityId entity, String user, Set<Action> actions) throws IOException, UnauthorizedException {
        CheckAuthorizedRequest checkRequest = new CheckAuthorizedRequest(entity, user, actions);
        URL url = this.config.resolveURLV3("security/authorized");
        HttpRequest request = HttpRequest.post((URL)url).withBody(GSON.toJson((Object)checkRequest)).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), new int[0]);
        CheckAuthorizedResponse checkResponse = (CheckAuthorizedResponse)GSON.fromJson(response.getResponseBodyAsString(), CheckAuthorizedResponse.class);
        return checkResponse.isAuthorized();
    }

    public void grant(EntityId entity, String user, Set<Action> actions) throws IOException, UnauthorizedException {
        GrantRequest grantRequest = new GrantRequest(entity, user, actions);
        URL url = this.config.resolveURLV3("security/grant");
        HttpRequest request = HttpRequest.post((URL)url).withBody(GSON.toJson((Object)grantRequest)).build();
        this.restClient.execute(request, this.config.getAccessToken(), new int[0]);
    }

    public void revoke(EntityId entity, String user, Set<Action> actions) throws IOException, UnauthorizedException {
        this.revoke(new RevokeRequest(entity, user, actions));
    }

    public void revoke(EntityId entity, String user) throws IOException, UnauthorizedException {
        this.revoke(new RevokeRequest(entity, user, null));
    }

    public void revoke(EntityId entity) throws IOException, UnauthorizedException {
        this.revoke(new RevokeRequest(entity, null, null));
    }

    public void revoke(RevokeRequest revokeRequest) throws IOException, UnauthorizedException {
        URL url = this.config.resolveURLV3("security/revoke");
        HttpRequest request = HttpRequest.post((URL)url).withBody(GSON.toJson((Object)revokeRequest)).build();
        this.restClient.execute(request, this.config.getAccessToken(), new int[0]);
    }
}

