/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.api.annotation.Beta;
import co.cask.cdap.api.schedule.ScheduleSpecification;
import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.NotFoundException;
import co.cask.cdap.common.UnauthorizedException;
import co.cask.cdap.proto.Id;
import co.cask.cdap.proto.ScheduledRuntime;
import co.cask.cdap.proto.codec.ScheduleSpecificationCodec;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;

@Beta
public class ScheduleClient {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(ScheduleSpecification.class, (Object)new ScheduleSpecificationCodec()).create();
    private static final Type MAP_STRING_STRING_TYPE = new TypeToken<Map<String, String>>(){}.getType();
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public ScheduleClient(ClientConfig config, RESTClient restClient) {
        this.config = config;
        this.restClient = restClient;
    }

    public ScheduleClient(ClientConfig config) {
        this(config, new RESTClient(config));
    }

    public List<ScheduleSpecification> list(Id.Workflow workflow) throws IOException, UnauthorizedException, NotFoundException {
        String path = String.format("apps/%s/workflows/%s/schedules", workflow.getApplicationId(), workflow.getId());
        URL url = this.config.resolveNamespacedURLV3(workflow.getNamespace(), path);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (404 == response.getResponseCode()) {
            throw new NotFoundException((Id)workflow);
        }
        ObjectResponse objectResponse = ObjectResponse.fromJsonBody((HttpResponse)response, (Type)new TypeToken<List<ScheduleSpecification>>(){}.getType(), (Gson)GSON);
        return (List)objectResponse.getResponseObject();
    }

    public List<ScheduledRuntime> nextRuntimes(Id.Workflow workflow) throws IOException, UnauthorizedException, NotFoundException {
        String path = String.format("apps/%s/workflows/%s/nextruntime", workflow.getApplicationId(), workflow.getId());
        URL url = this.config.resolveNamespacedURLV3(workflow.getNamespace(), path);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (404 == response.getResponseCode()) {
            throw new NotFoundException((Id)workflow);
        }
        ObjectResponse objectResponse = ObjectResponse.fromJsonBody((HttpResponse)response, (Type)new TypeToken<List<ScheduledRuntime>>(){}.getType(), (Gson)GSON);
        return (List)objectResponse.getResponseObject();
    }

    public void suspend(Id.Schedule schedule) throws IOException, UnauthorizedException, NotFoundException {
        String path = String.format("apps/%s/schedules/%s/suspend", schedule.getApplication().getId(), schedule.getId());
        URL url = this.config.resolveNamespacedURLV3(schedule.getNamespace(), path);
        HttpResponse response = this.restClient.execute(HttpMethod.POST, url, this.config.getAccessToken(), 404);
        if (404 == response.getResponseCode()) {
            throw new NotFoundException((Id)schedule);
        }
    }

    public void resume(Id.Schedule schedule) throws IOException, UnauthorizedException, NotFoundException {
        String path = String.format("apps/%s/schedules/%s/resume", schedule.getApplication().getId(), schedule.getId());
        URL url = this.config.resolveNamespacedURLV3(schedule.getNamespace(), path);
        HttpResponse response = this.restClient.execute(HttpMethod.POST, url, this.config.getAccessToken(), 404);
        if (404 == response.getResponseCode()) {
            throw new NotFoundException((Id)schedule);
        }
    }

    public String getStatus(Id.Schedule schedule) throws IOException, UnauthorizedException, NotFoundException {
        String path = String.format("apps/%s/schedules/%s/status", schedule.getApplication().getId(), schedule.getId());
        URL url = this.config.resolveNamespacedURLV3(schedule.getNamespace(), path);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (404 == response.getResponseCode()) {
            throw new NotFoundException((Id)schedule);
        }
        Map responseObject = (Map)ObjectResponse.fromJsonBody((HttpResponse)response, (Type)MAP_STRING_STRING_TYPE, (Gson)GSON).getResponseObject();
        return (String)responseObject.get("status");
    }
}

