/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.BadRequestException;
import co.cask.cdap.common.NotFoundException;
import co.cask.cdap.common.UnauthorizedException;
import co.cask.cdap.proto.Id;
import co.cask.cdap.proto.codec.NamespacedIdCodec;
import co.cask.cdap.proto.metadata.MetadataRecord;
import co.cask.cdap.proto.metadata.MetadataScope;
import co.cask.cdap.proto.metadata.MetadataSearchResultRecord;
import co.cask.cdap.proto.metadata.MetadataSearchTargetType;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpRequest;
import co.cask.common.http.HttpResponse;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;

public class MetadataClient {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(Id.NamespacedId.class, (Object)new NamespacedIdCodec()).create();
    private static final Type SET_METADATA_RECORD_TYPE = new TypeToken<Set<MetadataRecord>>(){}.getType();
    private static final Type SET_METADATA_SEARCH_RESULT_TYPE = new TypeToken<Set<MetadataSearchResultRecord>>(){}.getType();
    private static final Type MAP_STRING_STRING_TYPE = new TypeToken<Map<String, String>>(){}.getType();
    private static final Type SET_STRING_TYPE = new TypeToken<Set<String>>(){}.getType();
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public MetadataClient(ClientConfig config, RESTClient restClient) {
        this.config = config;
        this.restClient = restClient;
    }

    public MetadataClient(ClientConfig config) {
        this(config, new RESTClient(config));
    }

    public Set<MetadataSearchResultRecord> searchMetadata(Id.Namespace namespace, String query, @Nullable MetadataSearchTargetType target) throws IOException, UnauthorizedException {
        String path = String.format("metadata/search?query=%s", query);
        if (target != null) {
            path = path + "&target=" + target;
        }
        URL searchURL = this.config.resolveNamespacedURLV3(namespace, path);
        HttpResponse response = this.restClient.execute(HttpRequest.get((URL)searchURL).build(), this.config.getAccessToken(), new int[0]);
        return (Set)GSON.fromJson(response.getResponseBodyAsString(), SET_METADATA_SEARCH_RESULT_TYPE);
    }

    public Set<MetadataRecord> getMetadata(Id id) throws UnauthorizedException, BadRequestException, NotFoundException, IOException {
        return this.getMetadata(id, null);
    }

    public Set<MetadataRecord> getMetadata(Id id, @Nullable MetadataScope scope) throws NotFoundException, BadRequestException, UnauthorizedException, IOException {
        if (id instanceof Id.Application) {
            return this.getMetadata((Id.Application)id, scope);
        }
        if (id instanceof Id.Artifact) {
            return this.getMetadata((Id.Artifact)id, scope);
        }
        if (id instanceof Id.DatasetInstance) {
            return this.getMetadata((Id.DatasetInstance)id, scope);
        }
        if (id instanceof Id.Stream) {
            return this.getMetadata((Id.Stream)id, scope);
        }
        if (id instanceof Id.Stream.View) {
            return this.getMetadata((Id.Stream.View)id, scope);
        }
        if (id instanceof Id.Program) {
            return this.getMetadata((Id.Program)id, scope);
        }
        if (id instanceof Id.Run) {
            return this.getMetadata((Id.Run)id);
        }
        throw new IllegalArgumentException("Unsupported Id type: " + id.getClass().getName());
    }

    public Map<String, String> getProperties(Id id) throws UnauthorizedException, BadRequestException, NotFoundException, IOException {
        return this.getProperties(id, null);
    }

    public Map<String, String> getProperties(Id id, @Nullable MetadataScope scope) throws NotFoundException, BadRequestException, UnauthorizedException, IOException {
        if (id instanceof Id.Application) {
            return this.getProperties((Id.Application)id, scope);
        }
        if (id instanceof Id.Artifact) {
            return this.getProperties((Id.Artifact)id, scope);
        }
        if (id instanceof Id.DatasetInstance) {
            return this.getProperties((Id.DatasetInstance)id, scope);
        }
        if (id instanceof Id.Stream) {
            return this.getProperties((Id.Stream)id, scope);
        }
        if (id instanceof Id.Stream.View) {
            return this.getProperties((Id.Stream.View)id, scope);
        }
        if (id instanceof Id.Program) {
            return this.getProperties((Id.Program)id, scope);
        }
        throw new IllegalArgumentException("Unsupported Id type: " + id.getClass().getName());
    }

    public Set<String> getTags(Id id) throws UnauthorizedException, BadRequestException, NotFoundException, IOException {
        return this.getTags(id, null);
    }

    public Set<String> getTags(Id id, @Nullable MetadataScope scope) throws NotFoundException, BadRequestException, UnauthorizedException, IOException {
        if (id instanceof Id.Application) {
            return this.getTags((Id.Application)id, scope);
        }
        if (id instanceof Id.Artifact) {
            return this.getTags((Id.Artifact)id, scope);
        }
        if (id instanceof Id.DatasetInstance) {
            return this.getTags((Id.DatasetInstance)id, scope);
        }
        if (id instanceof Id.Stream) {
            return this.getTags((Id.Stream)id, scope);
        }
        if (id instanceof Id.Stream.View) {
            return this.getTags((Id.Stream.View)id, scope);
        }
        if (id instanceof Id.Program) {
            return this.getTags((Id.Program)id, scope);
        }
        throw new IllegalArgumentException("Unsupported Id type: " + id.getClass().getName());
    }

    public void addProperties(Id id, Map<String, String> properties) throws NotFoundException, BadRequestException, UnauthorizedException, IOException {
        if (id instanceof Id.Application) {
            this.addProperties((Id.Application)id, properties);
        } else if (id instanceof Id.Artifact) {
            this.addProperties((Id.Artifact)id, properties);
        } else if (id instanceof Id.DatasetInstance) {
            this.addProperties((Id.DatasetInstance)id, properties);
        } else if (id instanceof Id.Stream) {
            this.addProperties((Id.Stream)id, properties);
        } else if (id instanceof Id.Stream.View) {
            this.addProperties((Id.Stream.View)id, properties);
        } else if (id instanceof Id.Program) {
            this.addProperties((Id.Program)id, properties);
        } else {
            throw new IllegalArgumentException("Unsupported Id type: " + id.getClass().getName());
        }
    }

    public void addTags(Id id, Set<String> tags) throws NotFoundException, BadRequestException, UnauthorizedException, IOException {
        if (id instanceof Id.Application) {
            this.addTags((Id.Application)id, tags);
        } else if (id instanceof Id.Artifact) {
            this.addTags((Id.Artifact)id, tags);
        } else if (id instanceof Id.DatasetInstance) {
            this.addTags((Id.DatasetInstance)id, tags);
        } else if (id instanceof Id.Stream) {
            this.addTags((Id.Stream)id, tags);
        } else if (id instanceof Id.Stream.View) {
            this.addTags((Id.Stream.View)id, tags);
        } else if (id instanceof Id.Program) {
            this.addTags((Id.Program)id, tags);
        } else {
            throw new IllegalArgumentException("Unsupported Id type: " + id.getClass().getName());
        }
    }

    public void removeMetadata(Id id) throws NotFoundException, BadRequestException, UnauthorizedException, IOException {
        if (id instanceof Id.Application) {
            this.removeMetadata((Id.Application)id);
        } else if (id instanceof Id.Artifact) {
            this.removeMetadata((Id.Artifact)id);
        } else if (id instanceof Id.DatasetInstance) {
            this.removeMetadata((Id.DatasetInstance)id);
        } else if (id instanceof Id.Stream) {
            this.removeMetadata((Id.Stream)id);
        } else if (id instanceof Id.Stream.View) {
            this.removeMetadata((Id.Stream.View)id);
        } else if (id instanceof Id.Program) {
            this.removeMetadata((Id.Program)id);
        } else {
            throw new IllegalArgumentException("Unsupported Id type: " + id.getClass().getName());
        }
    }

    public void removeProperties(Id id) throws NotFoundException, BadRequestException, UnauthorizedException, IOException {
        if (id instanceof Id.Application) {
            this.removeProperties((Id.Application)id);
        } else if (id instanceof Id.Artifact) {
            this.removeProperties((Id.Artifact)id);
        } else if (id instanceof Id.DatasetInstance) {
            this.removeProperties((Id.DatasetInstance)id);
        } else if (id instanceof Id.Stream) {
            this.removeProperties((Id.Stream)id);
        } else if (id instanceof Id.Stream.View) {
            this.removeProperties((Id.Stream.View)id);
        } else if (id instanceof Id.Program) {
            this.removeProperties((Id.Program)id);
        } else {
            throw new IllegalArgumentException("Unsupported Id type: " + id.getClass().getName());
        }
    }

    public void removeTags(Id id) throws NotFoundException, BadRequestException, UnauthorizedException, IOException {
        if (id instanceof Id.Application) {
            this.removeTags((Id.Application)id);
        } else if (id instanceof Id.Artifact) {
            this.removeTags((Id.Artifact)id);
        } else if (id instanceof Id.DatasetInstance) {
            this.removeTags((Id.DatasetInstance)id);
        } else if (id instanceof Id.Stream) {
            this.removeTags((Id.Stream)id);
        } else if (id instanceof Id.Stream.View) {
            this.removeTags((Id.Stream.View)id);
        } else if (id instanceof Id.Program) {
            this.removeTags((Id.Program)id);
        } else {
            throw new IllegalArgumentException("Unsupported Id type: " + id.getClass().getName());
        }
    }

    public void removeProperty(Id id, String property) throws NotFoundException, BadRequestException, UnauthorizedException, IOException {
        if (id instanceof Id.Application) {
            this.removeProperty((Id.Application)id, property);
        } else if (id instanceof Id.Artifact) {
            this.removeProperty((Id.Artifact)id, property);
        } else if (id instanceof Id.DatasetInstance) {
            this.removeProperty((Id.DatasetInstance)id, property);
        } else if (id instanceof Id.Stream) {
            this.removeProperty((Id.Stream)id, property);
        } else if (id instanceof Id.Stream.View) {
            this.removeProperty((Id.Stream.View)id, property);
        } else if (id instanceof Id.Program) {
            this.removeProperty((Id.Program)id, property);
        } else {
            throw new IllegalArgumentException("Unsupported Id type: " + id.getClass().getName());
        }
    }

    public void removeTag(Id id, String tag) throws NotFoundException, BadRequestException, UnauthorizedException, IOException {
        if (id instanceof Id.Application) {
            this.removeTag((Id.Application)id, tag);
        } else if (id instanceof Id.Artifact) {
            this.removeTag((Id.Artifact)id, tag);
        } else if (id instanceof Id.DatasetInstance) {
            this.removeTag((Id.DatasetInstance)id, tag);
        } else if (id instanceof Id.Stream) {
            this.removeTag((Id.Stream)id, tag);
        } else if (id instanceof Id.Stream.View) {
            this.removeTag((Id.Stream.View)id, tag);
        } else if (id instanceof Id.Program) {
            this.removeTag((Id.Program)id, tag);
        } else if (id instanceof Id.Run) {
            this.removeTag((Id)((Id.Run)id), tag);
        } else {
            throw new IllegalArgumentException("Unsupported Id type: " + id.getClass().getName());
        }
    }

    public Set<MetadataRecord> getMetadata(Id.Application appId, @Nullable MetadataScope scope) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        return this.doGetMetadata((Id.NamespacedId)appId, this.constructPath(appId), scope);
    }

    public Set<MetadataRecord> getMetadata(Id.Artifact artifactId, @Nullable MetadataScope scope) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        return this.doGetMetadata((Id.NamespacedId)artifactId, this.constructPath(artifactId), scope);
    }

    public Set<MetadataRecord> getMetadata(Id.DatasetInstance datasetInstance, @Nullable MetadataScope scope) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        return this.doGetMetadata((Id.NamespacedId)datasetInstance, this.constructPath(datasetInstance), scope);
    }

    public Set<MetadataRecord> getMetadata(Id.Stream streamId, @Nullable MetadataScope scope) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        return this.doGetMetadata((Id.NamespacedId)streamId, this.constructPath(streamId), scope);
    }

    public Set<MetadataRecord> getMetadata(Id.Stream.View viewId, @Nullable MetadataScope scope) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        return this.doGetMetadata((Id.NamespacedId)viewId, this.constructPath(viewId), scope);
    }

    public Set<MetadataRecord> getMetadata(Id.Program programId, @Nullable MetadataScope scope) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        return this.doGetMetadata((Id.NamespacedId)programId, this.constructPath(programId), scope);
    }

    public Set<MetadataRecord> getMetadata(Id.Run runId) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        return this.doGetMetadata((Id.NamespacedId)runId, this.constructPath(runId));
    }

    private Set<MetadataRecord> doGetMetadata(Id.NamespacedId namespacedId, String entityPath) throws NotFoundException, BadRequestException, UnauthorizedException, IOException {
        return this.doGetMetadata(namespacedId, entityPath, null);
    }

    private Set<MetadataRecord> doGetMetadata(Id.NamespacedId namespacedId, String entityPath, @Nullable MetadataScope scope) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        String path = String.format("%s/metadata", entityPath);
        path = scope == null ? path : String.format("%s?scope=%s", path, scope);
        HttpResponse response = this.makeRequest(namespacedId, path, HttpMethod.GET);
        return (Set)GSON.fromJson(response.getResponseBodyAsString(), SET_METADATA_RECORD_TYPE);
    }

    public Map<String, String> getProperties(Id.Application appId, @Nullable MetadataScope scope) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        return this.getProperties((Id.NamespacedId)appId, this.constructPath(appId), scope);
    }

    public Map<String, String> getProperties(Id.Artifact artifactId, @Nullable MetadataScope scope) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        return this.getProperties((Id.NamespacedId)artifactId, this.constructPath(artifactId), scope);
    }

    public Map<String, String> getProperties(Id.DatasetInstance datasetInstance, @Nullable MetadataScope scope) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        return this.getProperties((Id.NamespacedId)datasetInstance, this.constructPath(datasetInstance), scope);
    }

    public Map<String, String> getProperties(Id.Stream streamId, @Nullable MetadataScope scope) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        return this.getProperties((Id.NamespacedId)streamId, this.constructPath(streamId), scope);
    }

    public Map<String, String> getProperties(Id.Stream.View viewId, @Nullable MetadataScope scope) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        return this.getProperties((Id.NamespacedId)viewId, this.constructPath(viewId), scope);
    }

    public Map<String, String> getProperties(Id.Program programId, @Nullable MetadataScope scope) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        return this.getProperties((Id.NamespacedId)programId, this.constructPath(programId), scope);
    }

    private Map<String, String> getProperties(Id.NamespacedId namespacedId, String entityPath, @Nullable MetadataScope scope) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        String path = String.format("%s/metadata/properties", entityPath);
        path = scope == null ? path : String.format("%s?scope=%s", path, scope);
        HttpResponse response = this.makeRequest(namespacedId, path, HttpMethod.GET);
        return (Map)GSON.fromJson(response.getResponseBodyAsString(), MAP_STRING_STRING_TYPE);
    }

    public Set<String> getTags(Id.Application appId, @Nullable MetadataScope scope) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        return this.getTags((Id.NamespacedId)appId, this.constructPath(appId), scope);
    }

    public Set<String> getTags(Id.Artifact artifactId, @Nullable MetadataScope scope) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        return this.getTags((Id.NamespacedId)artifactId, this.constructPath(artifactId), scope);
    }

    public Set<String> getTags(Id.DatasetInstance datasetInstance, @Nullable MetadataScope scope) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        return this.getTags((Id.NamespacedId)datasetInstance, this.constructPath(datasetInstance), scope);
    }

    public Set<String> getTags(Id.Stream streamId, @Nullable MetadataScope scope) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        return this.getTags((Id.NamespacedId)streamId, this.constructPath(streamId), scope);
    }

    public Set<String> getTags(Id.Stream.View viewId, @Nullable MetadataScope scope) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        return this.getTags((Id.NamespacedId)viewId, this.constructPath(viewId), scope);
    }

    public Set<String> getTags(Id.Program programId, @Nullable MetadataScope scope) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        return this.getTags((Id.NamespacedId)programId, this.constructPath(programId), scope);
    }

    private Set<String> getTags(Id.NamespacedId namespacedId, String entityPath, @Nullable MetadataScope scope) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        String path = String.format("%s/metadata/tags", entityPath);
        path = scope == null ? path : String.format("%s?scope=%s", path, scope);
        HttpResponse response = this.makeRequest(namespacedId, path, HttpMethod.GET);
        return (Set)GSON.fromJson(response.getResponseBodyAsString(), SET_STRING_TYPE);
    }

    public void addTags(Id.Application appId, Set<String> tags) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        this.addTags((Id.NamespacedId)appId, this.constructPath(appId), tags);
    }

    public void addTags(Id.Artifact artifactId, Set<String> tags) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        this.addTags((Id.NamespacedId)artifactId, this.constructPath(artifactId), tags);
    }

    public void addTags(Id.DatasetInstance datasetInstance, Set<String> tags) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        this.addTags((Id.NamespacedId)datasetInstance, this.constructPath(datasetInstance), tags);
    }

    public void addTags(Id.Stream streamId, Set<String> tags) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        this.addTags((Id.NamespacedId)streamId, this.constructPath(streamId), tags);
    }

    public void addTags(Id.Stream.View viewId, Set<String> tags) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        this.addTags((Id.NamespacedId)viewId, this.constructPath(viewId), tags);
    }

    public void addTags(Id.Program programId, Set<String> tags) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        this.addTags((Id.NamespacedId)programId, this.constructPath(programId), tags);
    }

    private void addTags(Id.NamespacedId namespacedId, String entityPath, Set<String> tags) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        String path = String.format("%s/metadata/tags", entityPath);
        this.makeRequest(namespacedId, path, HttpMethod.POST, GSON.toJson(tags));
    }

    public void addProperties(Id.Application appId, Map<String, String> properties) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        this.addProperties((Id.NamespacedId)appId, this.constructPath(appId), properties);
    }

    public void addProperties(Id.Artifact artifactId, Map<String, String> properties) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        this.addProperties((Id.NamespacedId)artifactId, this.constructPath(artifactId), properties);
    }

    public void addProperties(Id.DatasetInstance datasetInstance, Map<String, String> properties) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        this.addProperties((Id.NamespacedId)datasetInstance, this.constructPath(datasetInstance), properties);
    }

    public void addProperties(Id.Stream streamId, Map<String, String> properties) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        this.addProperties((Id.NamespacedId)streamId, this.constructPath(streamId), properties);
    }

    public void addProperties(Id.Stream.View viewId, Map<String, String> properties) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        this.addProperties((Id.NamespacedId)viewId, this.constructPath(viewId), properties);
    }

    public void addProperties(Id.Program programId, Map<String, String> properties) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        this.addProperties((Id.NamespacedId)programId, this.constructPath(programId), properties);
    }

    private void addProperties(Id.NamespacedId namespacedId, String entityPath, Map<String, String> properties) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        String path = String.format("%s/metadata/properties", entityPath);
        this.makeRequest(namespacedId, path, HttpMethod.POST, GSON.toJson(properties));
    }

    public void removeProperty(Id.Application appId, String propertyToRemove) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        this.removeProperty((Id.NamespacedId)appId, this.constructPath(appId), propertyToRemove);
    }

    public void removeProperty(Id.Artifact artifactId, String propertyToRemove) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        this.removeProperty((Id.NamespacedId)artifactId, this.constructPath(artifactId), propertyToRemove);
    }

    public void removeProperty(Id.DatasetInstance datasetInstance, String propertyToRemove) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        this.removeProperty((Id.NamespacedId)datasetInstance, this.constructPath(datasetInstance), propertyToRemove);
    }

    public void removeProperty(Id.Stream streamId, String propertyToRemove) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        this.removeProperty((Id.NamespacedId)streamId, this.constructPath(streamId), propertyToRemove);
    }

    public void removeProperty(Id.Stream.View viewId, String propertyToRemove) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        this.removeProperty((Id.NamespacedId)viewId, this.constructPath(viewId), propertyToRemove);
    }

    public void removeProperty(Id.Program programId, String propertyToRemove) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        this.removeProperty((Id.NamespacedId)programId, this.constructPath(programId), propertyToRemove);
    }

    private void removeProperty(Id.NamespacedId namespacedId, String entityPath, String propertyToRemove) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        String path = String.format("%s/metadata/properties/%s", entityPath, propertyToRemove);
        this.makeRequest(namespacedId, path, HttpMethod.DELETE);
    }

    public void removeProperties(Id.Application appId) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        this.removeProperties((Id.NamespacedId)appId, this.constructPath(appId));
    }

    public void removeProperties(Id.Artifact artifactId) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        this.removeProperties((Id.NamespacedId)artifactId, this.constructPath(artifactId));
    }

    public void removeProperties(Id.DatasetInstance datasetInstance) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        this.removeProperties((Id.NamespacedId)datasetInstance, this.constructPath(datasetInstance));
    }

    public void removeProperties(Id.Stream streamId) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        this.removeProperties((Id.NamespacedId)streamId, this.constructPath(streamId));
    }

    public void removeProperties(Id.Stream.View viewId) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        this.removeProperties((Id.NamespacedId)viewId, this.constructPath(viewId));
    }

    public void removeProperties(Id.Program programId) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        this.removeProperties((Id.NamespacedId)programId, this.constructPath(programId));
    }

    private void removeProperties(Id.NamespacedId namespacedId, String entityPath) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        String path = String.format("%s/metadata/properties", entityPath);
        this.makeRequest(namespacedId, path, HttpMethod.DELETE);
    }

    public void removeTag(Id.Application appId, String tagToRemove) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        this.removeTag((Id.NamespacedId)appId, this.constructPath(appId), tagToRemove);
    }

    public void removeTag(Id.Artifact artifactId, String tagToRemove) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        this.removeTag((Id.NamespacedId)artifactId, this.constructPath(artifactId), tagToRemove);
    }

    public void removeTag(Id.DatasetInstance datasetInstance, String tagToRemove) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        this.removeTag((Id.NamespacedId)datasetInstance, this.constructPath(datasetInstance), tagToRemove);
    }

    public void removeTag(Id.Stream streamId, String tagToRemove) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        this.removeTag((Id.NamespacedId)streamId, this.constructPath(streamId), tagToRemove);
    }

    public void removeTag(Id.Stream.View viewId, String tagToRemove) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        this.removeTag((Id.NamespacedId)viewId, this.constructPath(viewId), tagToRemove);
    }

    public void removeTag(Id.Program programId, String tagToRemove) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        this.removeTag((Id.NamespacedId)programId, this.constructPath(programId), tagToRemove);
    }

    private void removeTag(Id.NamespacedId namespacedId, String entityPath, String tagToRemove) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        String path = String.format("%s/metadata/tags/%s", entityPath, tagToRemove);
        this.makeRequest(namespacedId, path, HttpMethod.DELETE);
    }

    public void removeTags(Id.Application appId) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        this.removeTags((Id.NamespacedId)appId, this.constructPath(appId));
    }

    public void removeTags(Id.Artifact artifactId) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        this.removeTags((Id.NamespacedId)artifactId, this.constructPath(artifactId));
    }

    public void removeTags(Id.DatasetInstance datasetInstance) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        this.removeTags((Id.NamespacedId)datasetInstance, this.constructPath(datasetInstance));
    }

    public void removeTags(Id.Stream streamId) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        this.removeTags((Id.NamespacedId)streamId, this.constructPath(streamId));
    }

    public void removeTags(Id.Stream.View viewId) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        this.removeTags((Id.NamespacedId)viewId, this.constructPath(viewId));
    }

    public void removeTags(Id.Program programId) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        this.removeTags((Id.NamespacedId)programId, this.constructPath(programId));
    }

    private void removeTags(Id.NamespacedId namespacedId, String entityPath) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        String path = String.format("%s/metadata/tags", entityPath);
        this.makeRequest(namespacedId, path, HttpMethod.DELETE);
    }

    public void removeMetadata(Id.Application appId) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        this.removeMetadata((Id.NamespacedId)appId, this.constructPath(appId));
    }

    public void removeMetadata(Id.Artifact artifactId) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        this.removeMetadata((Id.NamespacedId)artifactId, this.constructPath(artifactId));
    }

    public void removeMetadata(Id.DatasetInstance datasetInstance) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        this.removeMetadata((Id.NamespacedId)datasetInstance, this.constructPath(datasetInstance));
    }

    public void removeMetadata(Id.Stream streamId) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        this.removeMetadata((Id.NamespacedId)streamId, this.constructPath(streamId));
    }

    public void removeMetadata(Id.Stream.View viewId) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        this.removeMetadata((Id.NamespacedId)viewId, this.constructPath(viewId));
    }

    public void removeMetadata(Id.Program programId) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        this.removeMetadata((Id.NamespacedId)programId, this.constructPath(programId));
    }

    private void removeMetadata(Id.NamespacedId namespacedId, String entityPath) throws UnauthorizedException, BadRequestException, NotFoundException, IOException {
        String path = String.format("%s/metadata", entityPath);
        this.makeRequest(namespacedId, path, HttpMethod.DELETE);
    }

    private HttpResponse makeRequest(Id.NamespacedId namespacedId, String path, HttpMethod httpMethod) throws NotFoundException, BadRequestException, UnauthorizedException, IOException {
        return this.makeRequest(namespacedId, path, httpMethod, null);
    }

    private HttpResponse makeRequest(Id.NamespacedId namespacedId, String path, HttpMethod httpMethod, @Nullable String body) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        HttpResponse response;
        URL url = this.config.resolveNamespacedURLV3(namespacedId.getNamespace(), path);
        HttpRequest.Builder builder = HttpRequest.builder((HttpMethod)httpMethod, (URL)url);
        if (body != null) {
            builder.withBody(body);
        }
        if ((response = this.restClient.execute(builder.build(), this.config.getAccessToken(), 400, 404)).getResponseCode() == 400) {
            throw new BadRequestException(response.getResponseBodyAsString());
        }
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((Id)namespacedId);
        }
        return response;
    }

    private String constructPath(Id.Application appId) {
        return String.format("apps/%s", appId.getId());
    }

    private String constructPath(Id.Artifact artifactId) {
        return String.format("artifacts/%s/versions/%s", artifactId.getName(), artifactId.getVersion().getVersion());
    }

    private String constructPath(Id.Program programId) {
        return String.format("apps/%s/%s/%s", programId.getApplicationId(), programId.getType().getCategoryName(), programId.getId());
    }

    private String constructPath(Id.Run runId) {
        Id.Program programId = runId.getProgram();
        return String.format("apps/%s/%s/%s/runs/%s", programId.getApplicationId(), programId.getType().getCategoryName(), programId.getId(), runId.getId());
    }

    private String constructPath(Id.DatasetInstance datasetInstance) {
        return String.format("datasets/%s", datasetInstance.getId());
    }

    private String constructPath(Id.Stream streamId) {
        return String.format("streams/%s", streamId.getId());
    }

    private String constructPath(Id.Stream.View viewId) {
        return String.format("streams/%s/views/%s", viewId.getStreamId(), viewId.getId());
    }
}

