/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.api.annotation.Beta;
import co.cask.cdap.api.service.ServiceSpecification;
import co.cask.cdap.api.service.http.HttpServiceHandlerSpecification;
import co.cask.cdap.api.service.http.ServiceHttpEndpoint;
import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.NotFoundException;
import co.cask.cdap.common.UnauthorizedException;
import co.cask.cdap.proto.Id;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.inject.Inject;

@Beta
public class ServiceClient {
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public ServiceClient(ClientConfig config, RESTClient restClient) {
        this.config = config;
        this.restClient = restClient;
    }

    public ServiceClient(ClientConfig config) {
        this.config = config;
        this.restClient = new RESTClient(config);
    }

    public ServiceSpecification get(Id.Service service) throws IOException, UnauthorizedException, NotFoundException {
        URL url = this.config.resolveNamespacedURLV3(service.getNamespace(), String.format("apps/%s/services/%s", service.getApplicationId(), service.getId()));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((Id)service);
        }
        return (ServiceSpecification)ObjectResponse.fromJsonBody((HttpResponse)response, ServiceSpecification.class).getResponseObject();
    }

    public List<ServiceHttpEndpoint> getEndpoints(Id.Service service) throws IOException, UnauthorizedException, NotFoundException {
        ServiceSpecification specification = this.get(service);
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (HttpServiceHandlerSpecification handlerSpecification : specification.getHandlers().values()) {
            builder.addAll((Iterable)handlerSpecification.getEndpoints());
        }
        return builder.build();
    }

    public URL getServiceURL(Id.Service service) throws NotFoundException, IOException, UnauthorizedException {
        this.get(service);
        return this.config.resolveNamespacedURLV3(service.getNamespace(), String.format("apps/%s/services/%s/methods/", service.getApplicationId(), service.getId()));
    }
}

