/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.api.annotation.Beta;
import co.cask.cdap.api.schedule.ScheduleSpecification;
import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.NotFoundException;
import co.cask.cdap.common.UnauthorizedException;
import co.cask.cdap.proto.Id;
import co.cask.cdap.proto.ProgramStatus;
import co.cask.cdap.proto.codec.ScheduleSpecificationCodec;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.List;
import javax.inject.Inject;

@Beta
public class ScheduleClient {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(ScheduleSpecification.class, (Object)new ScheduleSpecificationCodec()).create();
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public ScheduleClient(ClientConfig config, RESTClient restClient) {
        this.config = config;
        this.restClient = restClient;
    }

    public ScheduleClient(ClientConfig config) {
        this.config = config;
        this.restClient = new RESTClient(config);
    }

    public List<ScheduleSpecification> list(Id.Workflow workflow) throws IOException, UnauthorizedException, NotFoundException {
        String path = String.format("apps/%s/workflows/%s/schedules", workflow.getApplicationId(), workflow.getId());
        URL url = this.config.resolveNamespacedURLV3(workflow.getNamespace(), path);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (404 == response.getResponseCode()) {
            throw new NotFoundException((Id)workflow);
        }
        ObjectResponse objectResponse = ObjectResponse.fromJsonBody((HttpResponse)response, (Type)new TypeToken<List<ScheduleSpecification>>(){}.getType(), (Gson)GSON);
        return (List)objectResponse.getResponseObject();
    }

    public void suspend(Id.Schedule schedule) throws IOException, UnauthorizedException, NotFoundException {
        String path = String.format("apps/%s/schedules/%s/suspend", schedule.getApplication().getId(), schedule.getId());
        URL url = this.config.resolveNamespacedURLV3(schedule.getNamespace(), path);
        HttpResponse response = this.restClient.execute(HttpMethod.POST, url, this.config.getAccessToken(), 404);
        if (404 == response.getResponseCode()) {
            throw new NotFoundException((Id)schedule);
        }
    }

    public void resume(Id.Schedule schedule) throws IOException, UnauthorizedException, NotFoundException {
        String path = String.format("apps/%s/schedules/%s/resume", schedule.getApplication().getId(), schedule.getId());
        URL url = this.config.resolveNamespacedURLV3(schedule.getNamespace(), path);
        HttpResponse response = this.restClient.execute(HttpMethod.POST, url, this.config.getAccessToken(), 404);
        if (404 == response.getResponseCode()) {
            throw new NotFoundException((Id)schedule);
        }
    }

    public String getStatus(Id.Schedule schedule) throws IOException, UnauthorizedException, NotFoundException {
        String path = String.format("apps/%s/schedules/%s/status", schedule.getApplication().getId(), schedule.getId());
        URL url = this.config.resolveNamespacedURLV3(schedule.getNamespace(), path);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (404 == response.getResponseCode()) {
            throw new NotFoundException((Id)schedule);
        }
        return ((ProgramStatus)ObjectResponse.fromJsonBody((HttpResponse)response, ProgramStatus.class).getResponseObject()).getStatus();
    }
}

