/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.api.annotation.Beta;
import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.DatasetAlreadyExistsException;
import co.cask.cdap.common.DatasetNotFoundException;
import co.cask.cdap.common.DatasetTypeNotFoundException;
import co.cask.cdap.common.NotFoundException;
import co.cask.cdap.common.UnauthorizedException;
import co.cask.cdap.common.utils.Tasks;
import co.cask.cdap.proto.DatasetInstanceConfiguration;
import co.cask.cdap.proto.DatasetMeta;
import co.cask.cdap.proto.DatasetSpecificationSummary;
import co.cask.cdap.proto.Id;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpRequest;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;

@Beta
public class DatasetClient {
    private static final Gson GSON = new Gson();
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public DatasetClient(ClientConfig config, RESTClient restClient) {
        this.config = config;
        this.restClient = restClient;
    }

    public DatasetClient(ClientConfig config) {
        this.config = config;
        this.restClient = new RESTClient(config);
    }

    public List<DatasetSpecificationSummary> list(Id.Namespace namespace) throws IOException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(namespace, "data/datasets");
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), new int[0]);
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<List<DatasetSpecificationSummary>>(){}).getResponseObject();
    }

    public DatasetMeta get(Id.DatasetInstance instance) throws IOException, UnauthorizedException, NotFoundException {
        URL url = this.config.resolveNamespacedURLV3(instance.getNamespace(), String.format("data/datasets/%s", instance.getId()));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), new int[0]);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((Id)instance);
        }
        return (DatasetMeta)ObjectResponse.fromJsonBody((HttpResponse)response, DatasetMeta.class).getResponseObject();
    }

    public void create(Id.DatasetInstance instance, DatasetInstanceConfiguration properties) throws DatasetTypeNotFoundException, DatasetAlreadyExistsException, IOException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(instance.getNamespace(), String.format("data/datasets/%s", instance.getId()));
        HttpRequest request = HttpRequest.put((URL)url).withBody(GSON.toJson((Object)properties)).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 404, 409);
        if (response.getResponseCode() == 404) {
            throw new DatasetTypeNotFoundException(Id.DatasetType.from((Id.Namespace)instance.getNamespace(), (String)properties.getTypeName()));
        }
        if (response.getResponseCode() == 409) {
            throw new DatasetAlreadyExistsException(instance);
        }
    }

    public void create(Id.DatasetInstance instance, String typeName) throws DatasetTypeNotFoundException, DatasetAlreadyExistsException, IOException, UnauthorizedException {
        this.create(instance, new DatasetInstanceConfiguration(typeName, (Map)ImmutableMap.of()));
    }

    public void update(Id.DatasetInstance instance, Map<String, String> properties) throws NotFoundException, IOException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(instance.getNamespace(), String.format("data/datasets/%s/properties", instance.getId()));
        HttpRequest request = HttpRequest.put((URL)url).withBody(GSON.toJson(properties)).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 404, 409);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((Id)instance);
        }
    }

    public void updateExisting(Id.DatasetInstance instance, Map<String, String> properties) throws NotFoundException, IOException, UnauthorizedException {
        DatasetMeta meta = this.get(instance);
        Map existingProperties = meta.getSpec().getProperties();
        HashMap resolvedProperties = Maps.newHashMap();
        resolvedProperties.putAll(existingProperties);
        resolvedProperties.putAll(properties);
        this.update(instance, resolvedProperties);
    }

    public void delete(Id.DatasetInstance instance) throws DatasetNotFoundException, IOException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(instance.getNamespace(), String.format("data/datasets/%s", instance.getId()));
        HttpResponse response = this.restClient.execute(HttpMethod.DELETE, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new DatasetNotFoundException(instance);
        }
    }

    public boolean exists(Id.DatasetInstance instance) throws IOException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(instance.getNamespace(), String.format("data/datasets/%s", instance.getId()));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        return response.getResponseCode() != 404;
    }

    public void waitForExists(final Id.DatasetInstance instance, long timeout, TimeUnit timeoutUnit) throws IOException, UnauthorizedException, TimeoutException, InterruptedException {
        try {
            Tasks.waitFor((Object)true, (Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return DatasetClient.this.exists(instance);
                }
            }, (long)timeout, (TimeUnit)timeoutUnit, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), IOException.class, UnauthorizedException.class);
        }
    }

    public void waitForDeleted(final Id.DatasetInstance instance, long timeout, TimeUnit timeoutUnit) throws IOException, UnauthorizedException, TimeoutException, InterruptedException {
        try {
            Tasks.waitFor((Object)false, (Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return DatasetClient.this.exists(instance);
                }
            }, (long)timeout, (TimeUnit)timeoutUnit, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), IOException.class, UnauthorizedException.class);
        }
    }

    public void truncate(Id.DatasetInstance instance) throws IOException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(instance.getNamespace(), String.format("data/datasets/%s/admin/truncate", instance.getId()));
        this.restClient.execute(HttpMethod.POST, url, this.config.getAccessToken(), new int[0]);
    }
}

