/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.api.annotation.Beta;
import co.cask.cdap.api.artifact.ArtifactScope;
import co.cask.cdap.api.data.schema.Schema;
import co.cask.cdap.api.plugin.PluginClass;
import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.ArtifactAlreadyExistsException;
import co.cask.cdap.common.ArtifactNotFoundException;
import co.cask.cdap.common.ArtifactRangeNotFoundException;
import co.cask.cdap.common.BadRequestException;
import co.cask.cdap.common.NotFoundException;
import co.cask.cdap.common.UnauthorizedException;
import co.cask.cdap.internal.io.SchemaTypeAdapter;
import co.cask.cdap.proto.Id;
import co.cask.cdap.proto.artifact.ApplicationClassInfo;
import co.cask.cdap.proto.artifact.ApplicationClassSummary;
import co.cask.cdap.proto.artifact.ArtifactInfo;
import co.cask.cdap.proto.artifact.ArtifactRange;
import co.cask.cdap.proto.artifact.ArtifactSummary;
import co.cask.cdap.proto.artifact.PluginInfo;
import co.cask.cdap.proto.artifact.PluginSummary;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpRequest;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import com.google.common.base.Joiner;
import com.google.common.io.InputSupplier;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Beta
public class ArtifactClient {
    private static final Type ARTIFACT_SUMMARIES_TYPE = new TypeToken<List<ArtifactSummary>>(){}.getType();
    private static final Type APPCLASS_SUMMARIES_TYPE = new TypeToken<List<ApplicationClassSummary>>(){}.getType();
    private static final Type APPCLASS_INFOS_TYPE = new TypeToken<List<ApplicationClassInfo>>(){}.getType();
    private static final Type EXTENSIONS_TYPE = new TypeToken<List<String>>(){}.getType();
    private static final Type PLUGIN_SUMMARIES_TYPE = new TypeToken<List<PluginSummary>>(){}.getType();
    private static final Type PLUGIN_INFOS_TYPE = new TypeToken<List<PluginInfo>>(){}.getType();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(Schema.class, (Object)new SchemaTypeAdapter()).create();
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public ArtifactClient(ClientConfig config, RESTClient restClient) {
        this.config = config;
        this.restClient = restClient;
    }

    public ArtifactClient(ClientConfig config) {
        this(config, new RESTClient(config));
    }

    public List<ArtifactSummary> list(Id.Namespace namespace) throws IOException, UnauthorizedException, NotFoundException {
        return this.list(namespace, null);
    }

    public List<ArtifactSummary> list(Id.Namespace namespace, @Nullable ArtifactScope scope) throws IOException, UnauthorizedException, NotFoundException {
        URL url = scope == null ? this.config.resolveNamespacedURLV3(namespace, "artifacts") : this.config.resolveNamespacedURLV3(namespace, String.format("artifacts?scope=%s", scope.name()));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((Id)namespace);
        }
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (Type)ARTIFACT_SUMMARIES_TYPE).getResponseObject();
    }

    public List<ArtifactSummary> listVersions(Id.Namespace namespace, String artifactName) throws UnauthorizedException, IOException, ArtifactNotFoundException {
        return this.listVersions(namespace, artifactName, null);
    }

    public List<ArtifactSummary> listVersions(Id.Namespace namespace, String artifactName, @Nullable ArtifactScope scope) throws UnauthorizedException, IOException, ArtifactNotFoundException {
        URL url = scope == null ? this.config.resolveNamespacedURLV3(namespace, String.format("artifacts/%s", artifactName)) : this.config.resolveNamespacedURLV3(namespace, String.format("artifacts/%s?scope=%s", artifactName, scope.name()));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ArtifactNotFoundException(namespace, artifactName);
        }
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (Type)ARTIFACT_SUMMARIES_TYPE).getResponseObject();
    }

    public ArtifactInfo getArtifactInfo(Id.Artifact artifactId) throws IOException, UnauthorizedException, ArtifactNotFoundException {
        return this.getArtifactInfo(artifactId, ArtifactScope.USER);
    }

    public ArtifactInfo getArtifactInfo(Id.Artifact artifactId, ArtifactScope scope) throws IOException, UnauthorizedException, ArtifactNotFoundException {
        String path = String.format("artifacts/%s/versions/%s?scope=%s", artifactId.getName(), artifactId.getVersion().getVersion(), scope.name());
        URL url = this.config.resolveNamespacedURLV3(artifactId.getNamespace(), path);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ArtifactNotFoundException(artifactId);
        }
        return (ArtifactInfo)ObjectResponse.fromJsonBody((HttpResponse)response, ArtifactInfo.class, (Gson)GSON).getResponseObject();
    }

    public List<ApplicationClassSummary> getApplicationClasses(Id.Namespace namespace) throws IOException, UnauthorizedException {
        return this.getApplicationClasses(namespace, (ArtifactScope)null);
    }

    public List<ApplicationClassSummary> getApplicationClasses(Id.Namespace namespace, @Nullable ArtifactScope scope) throws IOException, UnauthorizedException {
        String path = scope == null ? "classes/apps" : String.format("classes/apps?scope=%s", scope.name());
        URL url = this.config.resolveNamespacedURLV3(namespace, path);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), new int[0]);
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (Type)APPCLASS_SUMMARIES_TYPE).getResponseObject();
    }

    public List<ApplicationClassInfo> getApplicationClasses(Id.Namespace namespace, String className) throws IOException, UnauthorizedException {
        return this.getApplicationClasses(namespace, className, ArtifactScope.USER);
    }

    public List<ApplicationClassInfo> getApplicationClasses(Id.Namespace namespace, String className, ArtifactScope scope) throws IOException, UnauthorizedException {
        String path = String.format("classes/apps/%s?scope=%s", className, scope.name());
        URL url = this.config.resolveNamespacedURLV3(namespace, path);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), new int[0]);
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (Type)APPCLASS_INFOS_TYPE, (Gson)GSON).getResponseObject();
    }

    public List<String> getPluginTypes(Id.Artifact artifactId) throws IOException, UnauthorizedException {
        return this.getPluginTypes(artifactId, ArtifactScope.USER);
    }

    public List<String> getPluginTypes(Id.Artifact artifactId, ArtifactScope scope) throws IOException, UnauthorizedException {
        String path = String.format("artifacts/%s/versions/%s/extensions?scope=%s", artifactId.getName(), artifactId.getVersion().getVersion(), scope.name());
        URL url = this.config.resolveNamespacedURLV3(artifactId.getNamespace(), path);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), new int[0]);
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (Type)EXTENSIONS_TYPE).getResponseObject();
    }

    public List<PluginSummary> getPluginSummaries(Id.Artifact artifactId, String pluginType) throws IOException, UnauthorizedException {
        return this.getPluginSummaries(artifactId, pluginType, ArtifactScope.USER);
    }

    public List<PluginSummary> getPluginSummaries(Id.Artifact artifactId, String pluginType, ArtifactScope scope) throws IOException, UnauthorizedException {
        String path = String.format("artifacts/%s/versions/%s/extensions/%s?scope=%s", artifactId.getName(), artifactId.getVersion().getVersion(), pluginType, scope.name());
        URL url = this.config.resolveNamespacedURLV3(artifactId.getNamespace(), path);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), new int[0]);
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (Type)PLUGIN_SUMMARIES_TYPE).getResponseObject();
    }

    public List<PluginInfo> getPluginInfo(Id.Artifact artifactId, String pluginType, String pluginName) throws IOException, UnauthorizedException {
        return this.getPluginInfo(artifactId, pluginType, pluginName, ArtifactScope.USER);
    }

    public List<PluginInfo> getPluginInfo(Id.Artifact artifactId, String pluginType, String pluginName, ArtifactScope scope) throws IOException, UnauthorizedException {
        String path = String.format("artifacts/%s/versions/%s/extensions/%s/plugins/%s?scope=%s", artifactId.getName(), artifactId.getVersion().getVersion(), pluginType, pluginName, scope.name());
        URL url = this.config.resolveNamespacedURLV3(artifactId.getNamespace(), path);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), new int[0]);
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (Type)PLUGIN_INFOS_TYPE).getResponseObject();
    }

    public void add(Id.Artifact artifactId, @Nullable Set<ArtifactRange> parentArtifacts, InputSupplier<? extends InputStream> artifactContents) throws UnauthorizedException, BadRequestException, ArtifactRangeNotFoundException, ArtifactAlreadyExistsException, IOException {
        this.add(artifactId.getNamespace(), artifactId.getName(), artifactContents, artifactId.getVersion().getVersion(), parentArtifacts);
    }

    public void add(Id.Namespace namespace, String artifactName, InputSupplier<? extends InputStream> artifactContents, @Nullable String artifactVersion) throws ArtifactAlreadyExistsException, BadRequestException, IOException, UnauthorizedException, ArtifactRangeNotFoundException {
        this.add(namespace, artifactName, artifactContents, artifactVersion, null, null);
    }

    public void add(Id.Namespace namespace, String artifactName, InputSupplier<? extends InputStream> artifactContents, @Nullable String artifactVersion, @Nullable Set<ArtifactRange> parentArtifacts) throws ArtifactAlreadyExistsException, BadRequestException, IOException, UnauthorizedException, ArtifactRangeNotFoundException {
        this.add(namespace, artifactName, artifactContents, artifactVersion, parentArtifacts, null);
    }

    public void add(Id.Namespace namespace, String artifactName, InputSupplier<? extends InputStream> artifactContents, @Nullable String artifactVersion, @Nullable Set<ArtifactRange> parentArtifacts, @Nullable Set<PluginClass> additionalPlugins) throws ArtifactAlreadyExistsException, BadRequestException, IOException, UnauthorizedException, ArtifactRangeNotFoundException {
        URL url = this.config.resolveNamespacedURLV3(namespace, String.format("artifacts/%s", artifactName));
        HttpRequest.Builder requestBuilder = HttpRequest.post((URL)url);
        if (artifactVersion != null) {
            requestBuilder.addHeader("Artifact-Version", artifactVersion);
        }
        if (parentArtifacts != null) {
            requestBuilder.addHeader("Artifact-Extends", Joiner.on((char)'/').join(parentArtifacts));
        }
        if (additionalPlugins != null) {
            requestBuilder.addHeader("Artifact-Plugins", GSON.toJson(additionalPlugins));
        }
        HttpRequest request = requestBuilder.withBody(artifactContents).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 409, 400, 404);
        int responseCode = response.getResponseCode();
        if (responseCode == 409) {
            throw new ArtifactAlreadyExistsException(response.getResponseBodyAsString());
        }
        if (responseCode == 400) {
            throw new BadRequestException(response.getResponseBodyAsString());
        }
        if (responseCode == 404) {
            throw new ArtifactRangeNotFoundException(parentArtifacts);
        }
    }

    public void delete(Id.Artifact artifactId) throws IOException, UnauthorizedException, BadRequestException {
        URL url = this.config.resolveNamespacedURLV3(artifactId.getNamespace(), String.format("artifacts/%s/versions/%s", artifactId.getName(), artifactId.getVersion().getVersion()));
        HttpRequest request = HttpRequest.delete((URL)url).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 400);
        int responseCode = response.getResponseCode();
        if (responseCode == 400) {
            throw new BadRequestException(response.getResponseBodyAsString());
        }
    }
}

