/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.api.Config;
import co.cask.cdap.api.annotation.Beta;
import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.ApplicationNotFoundException;
import co.cask.cdap.common.BadRequestException;
import co.cask.cdap.common.NotFoundException;
import co.cask.cdap.common.UnauthorizedException;
import co.cask.cdap.common.utils.Tasks;
import co.cask.cdap.proto.ApplicationDetail;
import co.cask.cdap.proto.ApplicationRecord;
import co.cask.cdap.proto.Id;
import co.cask.cdap.proto.ProgramRecord;
import co.cask.cdap.proto.ProgramType;
import co.cask.cdap.proto.artifact.AppRequest;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpRequest;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Beta
public class ApplicationClient {
    private static final Gson GSON = new Gson();
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public ApplicationClient(ClientConfig config, RESTClient restClient) {
        this.config = config;
        this.restClient = restClient;
    }

    public ApplicationClient(ClientConfig config) {
        this.config = config;
        this.restClient = new RESTClient(config);
    }

    public List<ApplicationRecord> list(Id.Namespace namespace) throws IOException, UnauthorizedException {
        HttpResponse response = this.restClient.execute(HttpMethod.GET, this.config.resolveNamespacedURLV3(namespace, "apps"), this.config.getAccessToken(), new int[0]);
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<List<ApplicationRecord>>(){}).getResponseObject();
    }

    public List<ApplicationRecord> list(Id.Namespace namespace, @Nullable String artifactName, @Nullable String artifactVersion) throws IOException, UnauthorizedException {
        HashSet<String> names = new HashSet<String>();
        if (artifactName != null) {
            names.add(artifactName);
        }
        return this.list(namespace, names, artifactVersion);
    }

    public List<ApplicationRecord> list(Id.Namespace namespace, Set<String> artifactNames, @Nullable String artifactVersion) throws IOException, UnauthorizedException {
        if (artifactNames.isEmpty() && artifactVersion == null) {
            return this.list(namespace);
        }
        String path = !artifactNames.isEmpty() && artifactVersion != null ? String.format("apps?artifactName=%s&artifactVersion=%s", Joiner.on((char)',').join(artifactNames), artifactVersion) : (!artifactNames.isEmpty() ? "apps?artifactName=" + Joiner.on((char)',').join(artifactNames) : "apps?artifactVersion=" + artifactVersion);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, this.config.resolveNamespacedURLV3(namespace, path), this.config.getAccessToken(), new int[0]);
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<List<ApplicationRecord>>(){}).getResponseObject();
    }

    public ApplicationDetail get(Id.Application appId) throws ApplicationNotFoundException, IOException, UnauthorizedException {
        HttpResponse response = this.restClient.execute(HttpMethod.GET, this.config.resolveNamespacedURLV3(appId.getNamespace(), "apps/" + appId.getId()), this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ApplicationNotFoundException(appId);
        }
        return (ApplicationDetail)ObjectResponse.fromJsonBody((HttpResponse)response, ApplicationDetail.class).getResponseObject();
    }

    public void delete(Id.Application app) throws ApplicationNotFoundException, IOException, UnauthorizedException {
        HttpResponse response = this.restClient.execute(HttpMethod.DELETE, this.config.resolveNamespacedURLV3(app.getNamespace(), "apps/" + app.getId()), this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ApplicationNotFoundException(app);
        }
    }

    public void deleteAll(Id.Namespace namespace) throws IOException, UnauthorizedException {
        this.restClient.execute(HttpMethod.DELETE, this.config.resolveNamespacedURLV3(namespace, "apps"), this.config.getAccessToken(), new int[0]);
    }

    public boolean exists(Id.Application app) throws IOException, UnauthorizedException {
        HttpResponse response = this.restClient.execute(HttpMethod.GET, this.config.resolveNamespacedURLV3(app.getNamespace(), "apps/" + app.getId()), this.config.getAccessToken(), 404);
        return response.getResponseCode() != 404;
    }

    public void waitForDeployed(final Id.Application app, long timeout, TimeUnit timeoutUnit) throws IOException, UnauthorizedException, TimeoutException, InterruptedException {
        try {
            Tasks.waitFor((Object)true, (Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return ApplicationClient.this.exists(app);
                }
            }, (long)timeout, (TimeUnit)timeoutUnit, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), IOException.class, UnauthorizedException.class);
        }
    }

    public void waitForDeleted(final Id.Application app, long timeout, TimeUnit timeoutUnit) throws IOException, UnauthorizedException, TimeoutException, InterruptedException {
        try {
            Tasks.waitFor((Object)false, (Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return ApplicationClient.this.exists(app);
                }
            }, (long)timeout, (TimeUnit)timeoutUnit, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), IOException.class, UnauthorizedException.class);
        }
    }

    public void deploy(Id.Namespace namespace, File jarFile) throws IOException, UnauthorizedException {
        ImmutableMap headers = ImmutableMap.of((Object)"X-Archive-Name", (Object)jarFile.getName());
        this.deployApp(namespace, jarFile, (Map<String, String>)headers);
    }

    public void deploy(Id.Namespace namespace, File jarFile, String appConfig) throws IOException, UnauthorizedException {
        ImmutableMap headers = ImmutableMap.of((Object)"X-Archive-Name", (Object)jarFile.getName(), (Object)"X-App-Config", (Object)appConfig);
        this.deployApp(namespace, jarFile, (Map<String, String>)headers);
    }

    public void deploy(Id.Namespace namespace, File jarFile, Config appConfig) throws IOException, UnauthorizedException {
        this.deploy(namespace, jarFile, GSON.toJson((Object)appConfig));
    }

    public void deploy(Id.Application appId, AppRequest<?> createRequest) throws IOException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(appId.getNamespace(), "apps/" + appId.getId());
        HttpRequest request = HttpRequest.put((URL)url).addHeader("Content-Type", "application/json").withBody(GSON.toJson(createRequest)).build();
        this.restClient.upload(request, this.config.getAccessToken(), new int[0]);
    }

    public void update(Id.Application appId, AppRequest<?> updateRequest) throws IOException, UnauthorizedException, NotFoundException, BadRequestException {
        URL url = this.config.resolveNamespacedURLV3(appId.getNamespace(), String.format("apps/%s/update", appId.getId()));
        HttpRequest request = HttpRequest.post((URL)url).withBody(GSON.toJson(updateRequest)).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 404, 400);
        int responseCode = response.getResponseCode();
        if (responseCode == 404) {
            throw new NotFoundException((Object)"app or app artifact");
        }
        if (responseCode == 400) {
            throw new BadRequestException(response.getResponseBodyAsString());
        }
    }

    private void deployApp(Id.Namespace namespace, File jarFile, Map<String, String> headers) throws IOException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(namespace, "apps");
        HttpRequest request = HttpRequest.post((URL)url).addHeaders(headers).addHeader("Content-Type", "application/octet-stream").withBody(jarFile).build();
        this.restClient.upload(request, this.config.getAccessToken(), new int[0]);
    }

    public List<ProgramRecord> listAllPrograms(Id.Namespace namespace, ProgramType programType) throws IOException, UnauthorizedException {
        Preconditions.checkArgument((boolean)programType.isListable());
        String path = programType.getCategoryName();
        URL url = this.config.resolveNamespacedURLV3(namespace, path);
        HttpRequest request = HttpRequest.get((URL)url).build();
        ObjectResponse response = ObjectResponse.fromJsonBody((HttpResponse)this.restClient.execute(request, this.config.getAccessToken(), new int[0]), (TypeToken)new TypeToken<List<ProgramRecord>>(){});
        return (List)response.getResponseObject();
    }

    public Map<ProgramType, List<ProgramRecord>> listAllPrograms(Id.Namespace namespace) throws IOException, UnauthorizedException {
        ImmutableMap.Builder allPrograms = ImmutableMap.builder();
        for (ProgramType programType : ProgramType.values()) {
            if (!programType.isListable()) continue;
            ArrayList programRecords = Lists.newArrayList();
            programRecords.addAll(this.listAllPrograms(namespace, programType));
            allPrograms.put((Object)programType, (Object)programRecords);
        }
        return allPrograms.build();
    }

    public List<ProgramRecord> listPrograms(Id.Application app, ProgramType programType) throws ApplicationNotFoundException, IOException, UnauthorizedException {
        Preconditions.checkArgument((boolean)programType.isListable());
        ArrayList programs = Lists.newArrayList();
        for (ProgramRecord program : this.listPrograms(app)) {
            if (!programType.equals((Object)program.getType())) continue;
            programs.add(program);
        }
        return programs;
    }

    public Map<ProgramType, List<ProgramRecord>> listProgramsByType(Id.Application app) throws ApplicationNotFoundException, IOException, UnauthorizedException {
        HashMap result = Maps.newHashMap();
        for (ProgramType type : ProgramType.values()) {
            result.put(type, Lists.newArrayList());
        }
        for (ProgramRecord program : this.listPrograms(app)) {
            ((List)result.get(program.getType())).add(program);
        }
        return result;
    }

    public List<ProgramRecord> listPrograms(Id.Application app) throws ApplicationNotFoundException, IOException, UnauthorizedException {
        String path = String.format("apps/%s", app.getId());
        URL url = this.config.resolveNamespacedURLV3(app.getNamespace(), path);
        HttpRequest request = HttpRequest.get((URL)url).build();
        ObjectResponse response = ObjectResponse.fromJsonBody((HttpResponse)this.restClient.execute(request, this.config.getAccessToken(), 404), (TypeToken)new TypeToken<ApplicationDetail>(){});
        if (response.getResponseCode() == 404) {
            throw new ApplicationNotFoundException(app);
        }
        return ((ApplicationDetail)response.getResponseObject()).getPrograms();
    }
}

