/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client.config;

import co.cask.cdap.common.conf.CConfiguration;
import co.cask.cdap.proto.Id;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionConfig {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionConfig.class);
    private static final CConfiguration CONF = CConfiguration.create();
    private static final int DEFAULT_PORT = CONF.getInt("router.bind.port");
    private static final int DEFAULT_SSL_PORT = CONF.getInt("router.ssl.bind.port");
    private static final boolean DEFAULT_SSL_ENABLED = CONF.getBoolean("ssl.enabled", false);
    private static final String DEFAULT_HOST = ConnectionConfig.tryResolveAddress(CONF.get("router.bind.address"));
    public static final ConnectionConfig DEFAULT = ConnectionConfig.builder().build();
    private final String hostname;
    private final int port;
    private final boolean sslEnabled;
    @Deprecated
    private final Id.Namespace namespace;

    private static String tryResolveAddress(String addressString) {
        try {
            InetAddress address = InetAddress.getByName(addressString);
            if (address.isAnyLocalAddress()) {
                return InetAddress.getLocalHost().getHostName();
            }
        }
        catch (UnknownHostException e) {
            LOG.warn("Unable to resolve address", (Throwable)e);
        }
        return addressString;
    }

    public ConnectionConfig(ConnectionConfig config) {
        this(config.getHostname(), config.getPort(), config.isSSLEnabled());
    }

    public ConnectionConfig(String hostname, int port, boolean sslEnabled) {
        Preconditions.checkArgument((hostname != null && !hostname.isEmpty() ? 1 : 0) != 0, (Object)"hostname cannot be empty");
        this.hostname = hostname;
        this.port = port;
        this.sslEnabled = sslEnabled;
        this.namespace = null;
    }

    @Deprecated
    public ConnectionConfig(Id.Namespace namespace, String hostname, int port, boolean sslEnabled) {
        Preconditions.checkArgument((namespace != null ? 1 : 0) != 0, (Object)"namespace cannot be empty");
        Preconditions.checkArgument((hostname != null && !hostname.isEmpty() ? 1 : 0) != 0, (Object)"hostname cannot be empty");
        this.namespace = namespace;
        this.hostname = hostname;
        this.port = port;
        this.sslEnabled = sslEnabled;
    }

    public URI getURI() {
        return URI.create(String.format("%s://%s:%d", this.sslEnabled ? "https" : "http", this.hostname, this.port));
    }

    public URI resolveURI(String path) {
        return this.getURI().resolve(String.format("/%s", path));
    }

    public URI resolveURI(String apiVersion, String path) {
        return this.getURI().resolve(String.format("/%s/%s", apiVersion, path));
    }

    public URI resolveNamespacedURI(Id.Namespace namespace, String apiVersion, String path) {
        return this.getURI().resolve(String.format("/%s/namespaces/%s/%s", apiVersion, namespace.getId(), path));
    }

    @Deprecated
    public URI resolveNamespacedURI(String apiVersion, String path) {
        return this.getURI().resolve(String.format("/%s/namespaces/%s/%s", apiVersion, this.namespace.getId(), path));
    }

    @Deprecated
    public Id.Namespace getNamespace() {
        return this.namespace;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSSLEnabled() {
        return this.sslEnabled;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.hostname, this.port, this.sslEnabled});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectionConfig other = (ConnectionConfig)obj;
        return Objects.equal((Object)this.hostname, (Object)other.hostname) && Objects.equal((Object)this.port, (Object)other.port) && Objects.equal((Object)this.sslEnabled, (Object)other.sslEnabled);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("hostname", (Object)this.hostname).add("port", this.port).add("sslEnabled", this.sslEnabled).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ConnectionConfig connectionConfig) {
        return new Builder(connectionConfig);
    }

    static /* synthetic */ String access$000() {
        return DEFAULT_HOST;
    }

    static /* synthetic */ boolean access$100() {
        return DEFAULT_SSL_ENABLED;
    }

    public static class Builder {
        private String hostname = ConnectionConfig.access$000();
        private Integer port = null;
        private boolean sslEnabled = ConnectionConfig.access$100();
        @Deprecated
        private Id.Namespace namespace = Id.Namespace.DEFAULT;

        public Builder() {
        }

        public Builder(ConnectionConfig connectionConfig) {
            this.hostname = connectionConfig.hostname;
            this.port = connectionConfig.port;
            this.sslEnabled = connectionConfig.sslEnabled;
            this.namespace = connectionConfig.namespace;
        }

        public Builder setHostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        @Deprecated
        public Builder setNamespace(Id.Namespace namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder setPort(@Nullable Integer port) {
            this.port = port;
            return this;
        }

        public Builder setSSLEnabled(boolean sslEnabled) {
            this.sslEnabled = sslEnabled;
            return this;
        }

        public ConnectionConfig build() {
            if (this.port == null) {
                this.port = this.sslEnabled ? Integer.valueOf(DEFAULT_SSL_PORT) : Integer.valueOf(DEFAULT_PORT);
            }
            return new ConnectionConfig(this.namespace, this.hostname, this.port, this.sslEnabled);
        }
    }
}

