/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.api.annotation.Beta;
import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.explore.client.ExploreClient;
import co.cask.cdap.explore.client.ExploreExecutionResult;
import co.cask.cdap.explore.client.SuppliedAddressExploreClient;
import co.cask.cdap.proto.Id;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.ListenableFuture;
import javax.inject.Inject;

@Beta
public class QueryClient {
    private final ClientConfig config;
    private final ExploreClient exploreClient;

    @Inject
    public QueryClient(final ClientConfig config) {
        this.config = config;
        Supplier<String> hostname = new Supplier<String>(){

            public String get() {
                return config.getConnectionConfig().getHostname();
            }
        };
        Supplier<Integer> port = new Supplier<Integer>(){

            public Integer get() {
                return config.getConnectionConfig().getPort();
            }
        };
        Supplier<String> accessToken = new Supplier<String>(){

            public String get() {
                if (config.getAccessToken() != null) {
                    return config.getAccessToken().getValue();
                }
                return null;
            }
        };
        this.exploreClient = new SuppliedAddressExploreClient((Supplier)hostname, (Supplier)port, (Supplier)accessToken);
    }

    public ListenableFuture<ExploreExecutionResult> execute(Id.Namespace namespace, String query) {
        return this.exploreClient.submit(namespace, query);
    }
}

