/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.api.annotation.Beta;
import co.cask.cdap.api.workflow.WorkflowActionNode;
import co.cask.cdap.api.workflow.WorkflowActionSpecification;
import co.cask.cdap.client.ApplicationClient;
import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.NotFoundException;
import co.cask.cdap.common.ProgramNotFoundException;
import co.cask.cdap.common.UnauthorizedException;
import co.cask.cdap.common.utils.Tasks;
import co.cask.cdap.proto.DistributedProgramLiveInfo;
import co.cask.cdap.proto.Id;
import co.cask.cdap.proto.Instances;
import co.cask.cdap.proto.ProgramRecord;
import co.cask.cdap.proto.ProgramRunStatus;
import co.cask.cdap.proto.ProgramStatus;
import co.cask.cdap.proto.ProgramType;
import co.cask.cdap.proto.RunRecord;
import co.cask.cdap.proto.codec.WorkflowActionSpecificationCodec;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpRequest;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Beta
public class ProgramClient {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(WorkflowActionSpecification.class, (Object)new WorkflowActionSpecificationCodec()).create();
    private final RESTClient restClient;
    private final ClientConfig config;
    private final ApplicationClient applicationClient;

    @Inject
    public ProgramClient(ClientConfig config, RESTClient restClient, ApplicationClient applicationClient) {
        this.config = config;
        this.restClient = restClient;
        this.applicationClient = applicationClient;
    }

    public ProgramClient(ClientConfig config) {
        this(config, new RESTClient(config));
    }

    public ProgramClient(ClientConfig config, RESTClient restClient) {
        this(config, restClient, new ApplicationClient(config, restClient));
    }

    @Deprecated
    public void start(String appId, ProgramType programType, String programName, boolean debug, @Nullable Map<String, String> runtimeArgs) throws IOException, ProgramNotFoundException, UnauthorizedException {
        this.start(Id.Program.from((Id.Namespace)this.config.getNamespace(), (String)appId, (ProgramType)programType, (String)programName), debug, runtimeArgs);
    }

    @Deprecated
    public void start(String appId, ProgramType programType, String programName, boolean debug) throws IOException, ProgramNotFoundException, UnauthorizedException {
        this.start(Id.Program.from((Id.Namespace)this.config.getNamespace(), (String)appId, (ProgramType)programType, (String)programName), debug);
    }

    @Deprecated
    public void start(String appId, ProgramType programType, String programName) throws IOException, ProgramNotFoundException, UnauthorizedException {
        this.start(Id.Program.from((Id.Namespace)this.config.getNamespace(), (String)appId, (ProgramType)programType, (String)programName));
    }

    @Deprecated
    public void stop(String appId, ProgramType programType, String programName) throws IOException, ProgramNotFoundException, UnauthorizedException {
        this.stop(Id.Program.from((Id.Namespace)this.config.getNamespace(), (String)appId, (ProgramType)programType, (String)programName));
    }

    @Deprecated
    public void stopAll() throws IOException, UnauthorizedException, InterruptedException, TimeoutException {
        this.stopAll(this.config.getNamespace());
    }

    @Deprecated
    public String getStatus(String appId, ProgramType programType, String programName) throws IOException, ProgramNotFoundException, UnauthorizedException {
        return this.getStatus(Id.Program.from((Id.Namespace)this.config.getNamespace(), (String)appId, (ProgramType)programType, (String)programName));
    }

    @Deprecated
    public void waitForStatus(String appId, ProgramType programType, String programName, String status, long timeout, TimeUnit timeoutUnit) throws UnauthorizedException, IOException, ProgramNotFoundException, TimeoutException, InterruptedException {
        this.waitForStatus(Id.Program.from((Id.Namespace)this.config.getNamespace(), (String)appId, (ProgramType)programType, (String)programName), status, timeout, timeoutUnit);
    }

    @Deprecated
    public DistributedProgramLiveInfo getLiveInfo(String appId, ProgramType programType, String programName) throws IOException, ProgramNotFoundException, UnauthorizedException {
        return this.getLiveInfo(Id.Program.from((Id.Namespace)this.config.getNamespace(), (String)appId, (ProgramType)programType, (String)programName));
    }

    @Deprecated
    public int getFlowletInstances(String appId, String flowId, String flowletId) throws IOException, NotFoundException, UnauthorizedException {
        return this.getFlowletInstances(Id.Flow.Flowlet.from((Id.Flow)Id.Flow.from((Id.Namespace)this.config.getNamespace(), (String)appId, (String)flowId), (String)flowletId));
    }

    @Deprecated
    public void setFlowletInstances(String appId, String flowId, String flowletId, int instances) throws IOException, NotFoundException, UnauthorizedException {
        this.setFlowletInstances(Id.Flow.Flowlet.from((Id.Flow)Id.Flow.from((Id.Namespace)this.config.getNamespace(), (String)appId, (String)flowId), (String)flowletId), instances);
    }

    @Deprecated
    public int getWorkerInstances(String appId, String workerId) throws IOException, NotFoundException, UnauthorizedException {
        return this.getWorkerInstances(Id.Worker.from((Id.Namespace)this.config.getNamespace(), (String)appId, (String)workerId));
    }

    @Deprecated
    public void setWorkerInstances(String appId, String workerId, int instances) throws IOException, NotFoundException, UnauthorizedException {
        this.setWorkerInstances(Id.Worker.from((Id.Namespace)this.config.getNamespace(), (String)appId, (String)workerId), instances);
    }

    @Deprecated
    public int getServiceInstances(String appId, String serviceId) throws IOException, NotFoundException, UnauthorizedException {
        return this.getServiceInstances(Id.Service.from((Id.Namespace)this.config.getNamespace(), (String)appId, (String)serviceId));
    }

    @Deprecated
    public void setServiceInstances(String appId, String serviceId, int instances) throws IOException, NotFoundException, UnauthorizedException {
        this.setServiceInstances(Id.Service.from((Id.Namespace)this.config.getNamespace(), (String)appId, (String)serviceId), instances);
    }

    @Deprecated
    public List<WorkflowActionNode> getWorkflowCurrent(String appId, String workflowId, String runId) throws IOException, NotFoundException, UnauthorizedException {
        return this.getWorkflowCurrent(Id.Application.from((Id.Namespace)this.config.getNamespace(), (String)appId), workflowId, runId);
    }

    @Deprecated
    public List<RunRecord> getProgramRuns(String appId, ProgramType programType, String programId, String state, long startTime, long endTime, int limit) throws IOException, NotFoundException, UnauthorizedException {
        return this.getProgramRuns(Id.Program.from((Id.Namespace)this.config.getNamespace(), (String)appId, (ProgramType)programType, (String)programId), state, startTime, endTime, limit);
    }

    @Deprecated
    public List<RunRecord> getAllProgramRuns(String appId, ProgramType programType, String programId, long startTime, long endTime, int limit) throws IOException, NotFoundException, UnauthorizedException {
        return this.getAllProgramRuns(Id.Program.from((Id.Namespace)this.config.getNamespace(), (String)appId, (ProgramType)programType, (String)programId), startTime, endTime, limit);
    }

    @Deprecated
    public String getProgramLogs(String appId, ProgramType programType, String programId, long start, long stop) throws IOException, NotFoundException, UnauthorizedException {
        return this.getProgramLogs(Id.Program.from((Id.Namespace)this.config.getNamespace(), (String)appId, (ProgramType)programType, (String)programId), start, stop);
    }

    @Deprecated
    public Map<String, String> getRuntimeArgs(String appId, ProgramType programType, String programId) throws IOException, UnauthorizedException, ProgramNotFoundException {
        return this.getRuntimeArgs(Id.Program.from((Id.Namespace)this.config.getNamespace(), (String)appId, (ProgramType)programType, (String)programId));
    }

    @Deprecated
    public void setRuntimeArgs(String appId, ProgramType programType, String programId, Map<String, String> runtimeArgs) throws IOException, UnauthorizedException, ProgramNotFoundException {
        this.setRuntimeArgs(Id.Program.from((Id.Namespace)this.config.getNamespace(), (String)appId, (ProgramType)programType, (String)programId), runtimeArgs);
    }

    public void start(Id.Program program, boolean debug, @Nullable Map<String, String> runtimeArgs) throws IOException, ProgramNotFoundException, UnauthorizedException {
        HttpResponse response;
        String action = debug ? "debug" : "start";
        String path = String.format("apps/%s/%s/%s/%s", program.getApplicationId(), program.getType().getCategoryName(), program.getId(), action);
        URL url = this.config.resolveNamespacedURLV3(program.getNamespace(), path);
        HttpRequest.Builder request = HttpRequest.post((URL)url);
        if (runtimeArgs != null) {
            request.withBody(GSON.toJson(runtimeArgs));
        }
        if ((response = this.restClient.execute(request.build(), this.config.getAccessToken(), 404)).getResponseCode() == 404) {
            throw new ProgramNotFoundException(program);
        }
    }

    public void start(Id.Program program, boolean debug) throws IOException, ProgramNotFoundException, UnauthorizedException {
        this.start(program, debug, null);
    }

    public void start(Id.Program program) throws IOException, ProgramNotFoundException, UnauthorizedException {
        this.start(program, false, null);
    }

    public void stop(Id.Program program) throws IOException, ProgramNotFoundException, UnauthorizedException {
        String path = String.format("apps/%s/%s/%s/stop", program.getApplicationId(), program.getType().getCategoryName(), program.getId());
        URL url = this.config.resolveNamespacedURLV3(program.getNamespace(), path);
        HttpResponse response = this.restClient.execute(HttpMethod.POST, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ProgramNotFoundException(program);
        }
    }

    public void stopAll(Id.Namespace namespace) throws IOException, UnauthorizedException, InterruptedException, TimeoutException {
        Map<ProgramType, List<ProgramRecord>> allPrograms = this.applicationClient.listAllPrograms(namespace);
        for (Map.Entry<ProgramType, List<ProgramRecord>> entry : allPrograms.entrySet()) {
            ProgramType programType = entry.getKey();
            List<ProgramRecord> programRecords = entry.getValue();
            for (ProgramRecord programRecord : programRecords) {
                try {
                    Id.Program program = Id.Program.from((Id.Namespace)namespace, (String)programRecord.getApp(), (ProgramType)programType, (String)programRecord.getName());
                    String status = this.getStatus(program);
                    if (status.equals("STOPPED")) continue;
                    this.stop(program);
                    this.waitForStatus(program, "STOPPED", 60L, TimeUnit.SECONDS);
                }
                catch (ProgramNotFoundException e) {}
            }
        }
    }

    public String getStatus(Id.Program program) throws IOException, ProgramNotFoundException, UnauthorizedException {
        String path = String.format("apps/%s/%s/%s/status", program.getApplicationId(), program.getType().getCategoryName(), program.getId());
        URL url = this.config.resolveNamespacedURLV3(program.getNamespace(), path);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (404 == response.getResponseCode()) {
            throw new ProgramNotFoundException(program);
        }
        return ((ProgramStatus)ObjectResponse.fromJsonBody((HttpResponse)response, ProgramStatus.class).getResponseObject()).getStatus();
    }

    public void waitForStatus(final Id.Program program, String status, long timeout, TimeUnit timeoutUnit) throws UnauthorizedException, IOException, ProgramNotFoundException, TimeoutException, InterruptedException {
        try {
            Tasks.waitFor((Object)status, (Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return ProgramClient.this.getStatus(program);
                }
            }, (long)timeout, (TimeUnit)timeoutUnit, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), UnauthorizedException.class);
            Throwables.propagateIfPossible((Throwable)e.getCause(), ProgramNotFoundException.class);
            Throwables.propagateIfPossible((Throwable)e.getCause(), IOException.class);
        }
    }

    public DistributedProgramLiveInfo getLiveInfo(Id.Program program) throws IOException, ProgramNotFoundException, UnauthorizedException {
        String path = String.format("apps/%s/%s/%s/live-info", program.getApplicationId(), program.getType().getCategoryName(), program.getId());
        URL url = this.config.resolveNamespacedURLV3(program.getNamespace(), path);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ProgramNotFoundException(program);
        }
        return (DistributedProgramLiveInfo)ObjectResponse.fromJsonBody((HttpResponse)response, DistributedProgramLiveInfo.class).getResponseObject();
    }

    public int getFlowletInstances(Id.Flow.Flowlet flowlet) throws IOException, NotFoundException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(flowlet.getNamespace(), String.format("apps/%s/flows/%s/flowlets/%s/instances", flowlet.getFlow().getApplicationId(), flowlet.getFlow().getId(), flowlet.getId()));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((Id)flowlet);
        }
        return ((Instances)ObjectResponse.fromJsonBody((HttpResponse)response, Instances.class).getResponseObject()).getInstances();
    }

    public void setFlowletInstances(Id.Flow.Flowlet flowlet, int instances) throws IOException, NotFoundException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(flowlet.getNamespace(), String.format("apps/%s/flows/%s/flowlets/%s/instances", flowlet.getFlow().getApplicationId(), flowlet.getFlow().getId(), flowlet.getId()));
        HttpRequest request = HttpRequest.put((URL)url).withBody(GSON.toJson((Object)new Instances(instances))).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((Id)flowlet);
        }
    }

    public int getWorkerInstances(Id.Worker worker) throws IOException, NotFoundException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(worker.getNamespace(), String.format("apps/%s/workers/%s/instances", worker.getApplicationId(), worker.getId()));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((Id)worker);
        }
        return ((Instances)ObjectResponse.fromJsonBody((HttpResponse)response, Instances.class).getResponseObject()).getInstances();
    }

    public void setWorkerInstances(Id.Worker worker, int instances) throws IOException, NotFoundException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(worker.getNamespace(), String.format("apps/%s/workers/%s/instances", worker.getApplicationId(), worker.getId()));
        HttpRequest request = HttpRequest.put((URL)url).withBody(GSON.toJson((Object)new Instances(instances))).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((Id)worker);
        }
    }

    public int getServiceInstances(Id.Service service) throws IOException, NotFoundException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(service.getNamespace(), String.format("apps/%s/services/%s/instances", service.getApplicationId(), service.getId()));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((Id)service);
        }
        return ((Instances)ObjectResponse.fromJsonBody((HttpResponse)response, Instances.class).getResponseObject()).getInstances();
    }

    public void setServiceInstances(Id.Service service, int instances) throws IOException, NotFoundException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(service.getNamespace(), String.format("apps/%s/services/%s/instances", service.getApplicationId(), service.getId()));
        HttpRequest request = HttpRequest.put((URL)url).withBody(GSON.toJson((Object)new Instances(instances))).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((Id)service);
        }
    }

    public List<WorkflowActionNode> getWorkflowCurrent(Id.Application appId, String workflowId, String runId) throws IOException, NotFoundException, UnauthorizedException {
        String path = String.format("/apps/%s/workflows/%s/runs/%s/current", appId.getId(), workflowId, runId);
        URL url = this.config.resolveNamespacedURLV3(appId.getNamespace(), path);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            Id.Program program = Id.Program.from((Id.Application)appId, (ProgramType)ProgramType.WORKFLOW, (String)workflowId);
            throw new NotFoundException((Id)new Id.Run(program, runId));
        }
        ObjectResponse objectResponse = ObjectResponse.fromJsonBody((HttpResponse)response, (Type)new TypeToken<List<WorkflowActionNode>>(){}.getType(), (Gson)GSON);
        return (List)objectResponse.getResponseObject();
    }

    public List<RunRecord> getProgramRuns(Id.Program program, String state, long startTime, long endTime, int limit) throws IOException, NotFoundException, UnauthorizedException {
        String queryParams = String.format("%s=%s&%s=%d&%s=%d&%s=%d", "status", state, "start", startTime, "end", endTime, "limit", limit);
        String path = String.format("apps/%s/%s/%s/runs?%s", program.getApplicationId(), program.getType().getCategoryName(), program.getId(), queryParams);
        URL url = this.config.resolveNamespacedURLV3(program.getNamespace(), path);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((Id)program);
        }
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<List<RunRecord>>(){}).getResponseObject();
    }

    public List<RunRecord> getAllProgramRuns(Id.Program program, long startTime, long endTime, int limit) throws IOException, NotFoundException, UnauthorizedException {
        return this.getProgramRuns(program, ProgramRunStatus.ALL.name(), startTime, endTime, limit);
    }

    public String getProgramLogs(Id.Program program, long start, long stop) throws IOException, NotFoundException, UnauthorizedException {
        String path = String.format("apps/%s/%s/%s/logs?start=%d&stop=%d", program.getApplicationId(), program.getType().getCategoryName(), program.getId(), start, stop);
        URL url = this.config.resolveNamespacedURLV3(program.getNamespace(), path);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), new int[0]);
        if (response.getResponseCode() == 404) {
            throw new ProgramNotFoundException(program);
        }
        return new String(response.getResponseBody(), Charsets.UTF_8);
    }

    public Map<String, String> getRuntimeArgs(Id.Program program) throws IOException, UnauthorizedException, ProgramNotFoundException {
        String path = String.format("apps/%s/%s/%s/runtimeargs", program.getApplicationId(), program.getType().getCategoryName(), program.getId());
        URL url = this.config.resolveNamespacedURLV3(program.getNamespace(), path);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ProgramNotFoundException(program);
        }
        return (Map)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<Map<String, String>>(){}).getResponseObject();
    }

    public void setRuntimeArgs(Id.Program program, Map<String, String> runtimeArgs) throws IOException, UnauthorizedException, ProgramNotFoundException {
        String path = String.format("apps/%s/%s/%s/runtimeargs", program.getApplicationId(), program.getType().getCategoryName(), program.getId());
        URL url = this.config.resolveNamespacedURLV3(program.getNamespace(), path);
        HttpRequest request = HttpRequest.put((URL)url).withBody(GSON.toJson(runtimeArgs)).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ProgramNotFoundException(program);
        }
    }
}

