/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.api.annotation.Beta;
import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.UnauthorizedException;
import co.cask.cdap.proto.ConfigEntry;
import co.cask.cdap.proto.Version;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;

@Beta
public class MetaClient {
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public MetaClient(ClientConfig config, RESTClient restClient) {
        this.config = config;
        this.restClient = restClient;
    }

    public MetaClient(ClientConfig config) {
        this.config = config;
        this.restClient = new RESTClient(config);
    }

    public void ping() throws IOException, UnauthorizedException {
        this.restClient.execute(HttpMethod.GET, this.config.resolveURLNoVersion("ping"), this.config.getAccessToken(), new int[0]);
    }

    public Version getVersion() throws IOException, UnauthorizedException {
        HttpResponse response = this.restClient.execute(HttpMethod.GET, this.config.resolveURL("version"), this.config.getAccessToken(), new int[0]);
        return (Version)ObjectResponse.fromJsonBody((HttpResponse)response, Version.class).getResponseObject();
    }

    public Map<String, ConfigEntry> getCDAPConfig() throws IOException, UnauthorizedException {
        return this.getConfig("config/cdap");
    }

    public Map<String, ConfigEntry> getHadoopConfig() throws IOException, UnauthorizedException {
        return this.getConfig("config/hadoop");
    }

    private Map<String, ConfigEntry> getConfig(String url) throws IOException, UnauthorizedException {
        HttpResponse response = this.restClient.execute(HttpMethod.GET, this.config.resolveURL(url), this.config.getAccessToken(), new int[0]);
        List responseObject = (List)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<List<ConfigEntry>>(){}).getResponseObject();
        HashMap config = Maps.newHashMap();
        for (ConfigEntry configEntry : responseObject) {
            config.put(configEntry.getName(), configEntry);
        }
        return config;
    }
}

