/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.api.annotation.Beta;
import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.NotFoundException;
import co.cask.cdap.common.UnauthorizedException;
import co.cask.cdap.proto.Id;
import co.cask.cdap.proto.template.ApplicationTemplateDetail;
import co.cask.cdap.proto.template.ApplicationTemplateMeta;
import co.cask.cdap.proto.template.PluginMeta;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.inject.Inject;

@Beta
public class ApplicationTemplateClient {
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public ApplicationTemplateClient(ClientConfig config, RESTClient restClient) {
        this.config = config;
        this.restClient = restClient;
    }

    public ApplicationTemplateClient(ClientConfig config) {
        this.config = config;
        this.restClient = new RESTClient(config);
    }

    public List<ApplicationTemplateMeta> list() throws IOException, UnauthorizedException {
        URL url = this.config.resolveURLV3("templates");
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), new int[0]);
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<List<ApplicationTemplateMeta>>(){}).getResponseObject();
    }

    public ApplicationTemplateDetail get(String templateId) throws NotFoundException, IOException, UnauthorizedException {
        Id.ApplicationTemplate id = Id.ApplicationTemplate.from((String)templateId);
        URL url = this.config.resolveURLV3("templates/" + templateId);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((Id)id);
        }
        return (ApplicationTemplateDetail)ObjectResponse.fromJsonBody((HttpResponse)response, ApplicationTemplateDetail.class).getResponseObject();
    }

    public List<PluginMeta> getPlugins(String templateId, String pluginType) throws NotFoundException, IOException, UnauthorizedException {
        Id.ApplicationTemplate id = Id.ApplicationTemplate.from((String)templateId);
        URL url = this.config.resolveURLV3("templates/" + templateId + "/extensions/" + pluginType);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException((Id)id);
        }
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<List<PluginMeta>>(){}).getResponseObject();
    }
}

