/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.api.annotation.Beta;
import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.AdapterNotFoundException;
import co.cask.cdap.common.ApplicationTemplateNotFoundException;
import co.cask.cdap.common.BadRequestException;
import co.cask.cdap.common.UnauthorizedException;
import co.cask.cdap.common.utils.Tasks;
import co.cask.cdap.proto.AdapterConfig;
import co.cask.cdap.proto.AdapterDetail;
import co.cask.cdap.proto.AdapterStatus;
import co.cask.cdap.proto.Id;
import co.cask.cdap.proto.ProgramId;
import co.cask.cdap.proto.ProgramRunStatus;
import co.cask.cdap.proto.RunRecord;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpRequest;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.HashMultimap;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Beta
public class AdapterClient {
    private static final Gson GSON = new Gson();
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public AdapterClient(ClientConfig config, RESTClient restClient) {
        this.config = config;
        this.restClient = restClient;
    }

    public AdapterClient(ClientConfig config) {
        this.config = config;
        this.restClient = new RESTClient(config);
    }

    @Deprecated
    public List<AdapterDetail> list() throws IOException, UnauthorizedException {
        return this.list(this.config.getNamespace());
    }

    @Deprecated
    public AdapterDetail get(String adapterName) throws AdapterNotFoundException, IOException, UnauthorizedException {
        return this.get(Id.Adapter.from((Id.Namespace)this.config.getNamespace(), (String)adapterName));
    }

    @Deprecated
    public void create(String adapterName, AdapterConfig adapterSpec) throws ApplicationTemplateNotFoundException, BadRequestException, IOException, UnauthorizedException {
        this.create(Id.Adapter.from((Id.Namespace)this.config.getNamespace(), (String)adapterName), adapterSpec);
    }

    @Deprecated
    public void delete(String adapterName) throws AdapterNotFoundException, IOException, UnauthorizedException {
        this.delete(Id.Adapter.from((Id.Namespace)this.config.getNamespace(), (String)adapterName));
    }

    @Deprecated
    public boolean exists(String adapterName) throws IOException, UnauthorizedException {
        return this.exists(Id.Adapter.from((Id.Namespace)this.config.getNamespace(), (String)adapterName));
    }

    @Deprecated
    public void waitForExists(String adapterName, long timeout, TimeUnit timeoutUnit) throws IOException, UnauthorizedException, TimeoutException, InterruptedException {
        this.waitForExists(Id.Adapter.from((Id.Namespace)this.config.getNamespace(), (String)adapterName), timeout, timeoutUnit);
    }

    @Deprecated
    public void waitForDeleted(String adapterName, long timeout, TimeUnit timeoutUnit) throws IOException, UnauthorizedException, TimeoutException, InterruptedException {
        this.waitForDeleted(Id.Adapter.from((Id.Namespace)this.config.getNamespace(), (String)adapterName), timeout, timeoutUnit);
    }

    @Deprecated
    public void start(String adapterName) throws IOException, UnauthorizedException, AdapterNotFoundException {
        this.start(Id.Adapter.from((Id.Namespace)this.config.getNamespace(), (String)adapterName));
    }

    @Deprecated
    public void stop(String adapterName) throws IOException, UnauthorizedException, AdapterNotFoundException {
        this.stop(Id.Adapter.from((Id.Namespace)this.config.getNamespace(), (String)adapterName));
    }

    @Deprecated
    public void waitForStatus(String adapterName, AdapterStatus status, long timeout, TimeUnit timeoutUnit) throws IOException, UnauthorizedException, TimeoutException, InterruptedException {
        this.waitForStatus(Id.Adapter.from((Id.Namespace)this.config.getNamespace(), (String)adapterName), status, timeout, timeoutUnit);
    }

    @Deprecated
    public String getLogs(String adapterName) throws AdapterNotFoundException, UnauthorizedException, IOException {
        return this.getLogs(Id.Adapter.from((Id.Namespace)this.config.getNamespace(), (String)adapterName));
    }

    @Deprecated
    public String getLogs(String adapterName, @Nullable Long start, @Nullable Long stop) throws AdapterNotFoundException, UnauthorizedException, IOException {
        return this.getLogs(Id.Adapter.from((Id.Namespace)this.config.getNamespace(), (String)adapterName), start, stop);
    }

    @Deprecated
    public String getLogs(String adapterName, @Nullable Long start, @Nullable Long stop, @Nullable Boolean escape, @Nullable String filter) throws IOException, AdapterNotFoundException, UnauthorizedException {
        return this.getLogs(Id.Adapter.from((Id.Namespace)this.config.getNamespace(), (String)adapterName), start, stop, escape, filter);
    }

    @Deprecated
    public AdapterStatus getStatus(String adapterName) throws IOException, UnauthorizedException, AdapterNotFoundException {
        return this.getStatus(Id.Adapter.from((Id.Namespace)this.config.getNamespace(), (String)adapterName));
    }

    @Deprecated
    public List<RunRecord> getRuns(String adapterName, ProgramRunStatus status, long startTs, long endTs, @Nullable Integer resultLimit) throws IOException, UnauthorizedException, AdapterNotFoundException {
        return this.getRuns(Id.Adapter.from((Id.Namespace)this.config.getNamespace(), (String)adapterName), status, startTs, endTs, resultLimit);
    }

    public List<AdapterDetail> list(Id.Namespace namespace) throws IOException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(namespace, "adapters");
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), new int[0]);
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<List<AdapterDetail>>(){}, (Gson)GSON).getResponseObject();
    }

    public AdapterDetail get(Id.Adapter adapter) throws AdapterNotFoundException, IOException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(adapter.getNamespace(), "adapters/" + adapter.getId());
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new AdapterNotFoundException(adapter);
        }
        return (AdapterDetail)ObjectResponse.fromJsonBody((HttpResponse)response, AdapterDetail.class, (Gson)GSON).getResponseObject();
    }

    public void create(Id.Adapter adapter, AdapterConfig adapterSpec) throws ApplicationTemplateNotFoundException, BadRequestException, IOException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(adapter.getNamespace(), String.format("adapters/%s", adapter.getId()));
        HttpRequest request = HttpRequest.put((URL)url).withBody(GSON.toJson((Object)adapterSpec)).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 404, 400);
        if (response.getResponseCode() == 404) {
            throw new ApplicationTemplateNotFoundException(Id.ApplicationTemplate.from((String)adapterSpec.getTemplate()));
        }
        if (response.getResponseCode() == 400) {
            throw new BadRequestException(response.getResponseBodyAsString());
        }
    }

    public void delete(Id.Adapter adapter) throws AdapterNotFoundException, IOException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(adapter.getNamespace(), String.format("adapters/%s", adapter.getId()));
        HttpResponse response = this.restClient.execute(HttpMethod.DELETE, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new AdapterNotFoundException(adapter);
        }
    }

    public boolean exists(Id.Adapter adapter) throws IOException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(adapter.getNamespace(), String.format("adapters/%s", adapter.getId()));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        return response.getResponseCode() != 404;
    }

    public void waitForExists(final Id.Adapter adapter, long timeout, TimeUnit timeoutUnit) throws IOException, UnauthorizedException, TimeoutException, InterruptedException {
        try {
            Tasks.waitFor((Object)true, (Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return AdapterClient.this.exists(adapter);
                }
            }, (long)timeout, (TimeUnit)timeoutUnit, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), IOException.class, UnauthorizedException.class);
        }
    }

    public void waitForDeleted(final Id.Adapter adapter, long timeout, TimeUnit timeoutUnit) throws IOException, UnauthorizedException, TimeoutException, InterruptedException {
        try {
            Tasks.waitFor((Object)false, (Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return AdapterClient.this.exists(adapter);
                }
            }, (long)timeout, (TimeUnit)timeoutUnit, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), IOException.class, UnauthorizedException.class);
        }
    }

    public void start(Id.Adapter adapter) throws IOException, UnauthorizedException, AdapterNotFoundException {
        URL url = this.config.resolveNamespacedURLV3(adapter.getNamespace(), String.format("adapters/%s/start", adapter.getId()));
        HttpResponse response = this.restClient.execute(HttpMethod.POST, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new AdapterNotFoundException(adapter);
        }
    }

    public void stop(Id.Adapter adapter) throws IOException, UnauthorizedException, AdapterNotFoundException {
        URL url = this.config.resolveNamespacedURLV3(adapter.getNamespace(), String.format("adapters/%s/stop", adapter.getId()));
        HttpResponse response = this.restClient.execute(HttpMethod.POST, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new AdapterNotFoundException(adapter);
        }
    }

    public void waitForStatus(final Id.Adapter adapter, final AdapterStatus status, long timeout, TimeUnit timeoutUnit) throws IOException, UnauthorizedException, TimeoutException, InterruptedException {
        try {
            Tasks.waitFor((Object)true, (Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return status.equals((Object)AdapterClient.this.getStatus(adapter));
                }
            }, (long)timeout, (TimeUnit)timeoutUnit, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), IOException.class, UnauthorizedException.class);
        }
    }

    public String getLogs(Id.Adapter adapter) throws AdapterNotFoundException, UnauthorizedException, IOException {
        return this.getLogs(adapter, null, null, null, null);
    }

    public String getLogs(Id.Adapter adapter, @Nullable Long start, @Nullable Long stop) throws AdapterNotFoundException, UnauthorizedException, IOException {
        return this.getLogs(adapter, start, stop, null, null);
    }

    public String getLogs(Id.Adapter adapter, @Nullable Long start, @Nullable Long stop, @Nullable Boolean escape, @Nullable String filter) throws IOException, AdapterNotFoundException, UnauthorizedException {
        HashMultimap queryParams = HashMultimap.create();
        queryParams.put((Object)"adapterid", (Object)adapter.getId());
        if (start != null) {
            queryParams.put((Object)"start", (Object)Long.toString(start));
        }
        if (stop != null) {
            queryParams.put((Object)"stop", (Object)Long.toString(stop));
        }
        if (escape != null) {
            queryParams.put((Object)"escape", (Object)Boolean.toString(escape));
        }
        if (filter != null) {
            queryParams.put((Object)"filter", (Object)filter);
        }
        String queryString = Joiner.on((String)"&").join((Iterable)queryParams.entries());
        AdapterDetail adapterDetail = this.get(adapter);
        ProgramId program = adapterDetail.getProgram();
        URL url = this.config.resolveNamespacedURLV3(adapter.getNamespace(), String.format("apps/%s/%s/%s/logs?%s", program.getApplication(), program.getType().getCategoryName(), program.getId(), queryString));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new AdapterNotFoundException(adapter);
        }
        return response.getResponseBodyAsString();
    }

    public AdapterStatus getStatus(Id.Adapter adapter) throws IOException, UnauthorizedException, AdapterNotFoundException {
        URL url = this.config.resolveNamespacedURLV3(adapter.getNamespace(), String.format("adapters/%s/status", adapter.getId()));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new AdapterNotFoundException(adapter);
        }
        Map statusMap = (Map)ObjectResponse.fromJsonBody((HttpResponse)response, (Type)new TypeToken<Map<String, String>>(){}.getType()).getResponseObject();
        return AdapterStatus.valueOf((String)((String)statusMap.get("status")));
    }

    public List<RunRecord> getRuns(Id.Adapter adapter, ProgramRunStatus status, long startTs, long endTs, @Nullable Integer resultLimit) throws IOException, UnauthorizedException, AdapterNotFoundException {
        String query = "?status=" + status + "&start=" + startTs + "&end=" + endTs + (resultLimit == null ? "" : "&resultLimit=" + resultLimit);
        URL url = this.config.resolveNamespacedURLV3(adapter.getNamespace(), String.format("adapters/%s/runs" + query, adapter.getId()));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new AdapterNotFoundException(adapter);
        }
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (Type)new TypeToken<List<RunRecord>>(){}.getType()).getResponseObject();
    }
}

