/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.api.workflow.WorkflowToken;
import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.NotFoundException;
import co.cask.cdap.common.UnauthorizedException;
import co.cask.cdap.proto.Id;
import co.cask.cdap.proto.WorkflowTokenDetail;
import co.cask.cdap.proto.WorkflowTokenNodeDetail;
import co.cask.cdap.proto.codec.WorkflowTokenDetailCodec;
import co.cask.cdap.proto.codec.WorkflowTokenNodeDetailCodec;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.inject.Inject;
import java.io.IOException;
import java.net.URL;
import javax.annotation.Nullable;

public class WorkflowClient {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(WorkflowTokenDetail.class, (Object)new WorkflowTokenDetailCodec()).registerTypeAdapter(WorkflowTokenNodeDetail.class, (Object)new WorkflowTokenNodeDetailCodec()).create();
    private final ClientConfig config;
    private final RESTClient restClient;

    @Inject
    public WorkflowClient(ClientConfig config, RESTClient restClient) {
        this.config = config;
        this.restClient = restClient;
    }

    WorkflowClient(ClientConfig config) {
        this(config, new RESTClient(config));
    }

    public WorkflowTokenDetail getWorkflowToken(Id.Run workflowRunId) throws UnauthorizedException, IOException, NotFoundException {
        return this.getWorkflowToken(workflowRunId, null, null);
    }

    public WorkflowTokenDetail getWorkflowToken(Id.Run workflowRunId, WorkflowToken.Scope scope) throws UnauthorizedException, IOException, NotFoundException {
        return this.getWorkflowToken(workflowRunId, scope, null);
    }

    public WorkflowTokenDetail getWorkflowToken(Id.Run workflowRunId, String key) throws UnauthorizedException, IOException, NotFoundException {
        return this.getWorkflowToken(workflowRunId, null, key);
    }

    public WorkflowTokenDetail getWorkflowToken(Id.Run workflowRunId, @Nullable WorkflowToken.Scope scope, @Nullable String key) throws IOException, UnauthorizedException, NotFoundException {
        String path = String.format("apps/%s/workflows/%s/runs/%s/token", workflowRunId.getProgram().getApplicationId(), workflowRunId.getProgram().getId(), workflowRunId.getId());
        URL url = this.config.resolveNamespacedURLV3(workflowRunId.getNamespace(), this.appendScopeAndKeyToUrl(path, scope, key));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            String msg = "Either the workflow or its run id";
            if (key != null) {
                msg = String.format("%s or the specified key at the specified scope", msg);
            }
            throw new NotFoundException((Object)workflowRunId, msg);
        }
        return (WorkflowTokenDetail)ObjectResponse.fromJsonBody((HttpResponse)response, WorkflowTokenDetail.class, (Gson)GSON).getResponseObject();
    }

    public WorkflowTokenNodeDetail getWorkflowTokenAtNode(Id.Run workflowRunId, String nodeName) throws UnauthorizedException, IOException, NotFoundException {
        return this.getWorkflowTokenAtNode(workflowRunId, nodeName, null, null);
    }

    public WorkflowTokenNodeDetail getWorkflowTokenAtNode(Id.Run workflowRunId, String nodeName, WorkflowToken.Scope scope) throws UnauthorizedException, IOException, NotFoundException {
        return this.getWorkflowTokenAtNode(workflowRunId, nodeName, scope, null);
    }

    public WorkflowTokenNodeDetail getWorkflowTokenAtNode(Id.Run workflowRunId, String nodeName, String key) throws UnauthorizedException, IOException, NotFoundException {
        return this.getWorkflowTokenAtNode(workflowRunId, nodeName, null, key);
    }

    public WorkflowTokenNodeDetail getWorkflowTokenAtNode(Id.Run workflowRunId, String nodeName, @Nullable WorkflowToken.Scope scope, @Nullable String key) throws IOException, UnauthorizedException, NotFoundException {
        String path = String.format("apps/%s/workflows/%s/runs/%s/nodes/%s/token", workflowRunId.getProgram().getApplicationId(), workflowRunId.getProgram().getId(), workflowRunId.getId(), nodeName);
        URL url = this.config.resolveNamespacedURLV3(workflowRunId.getNamespace(), this.appendScopeAndKeyToUrl(path, scope, key));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            String msg = "Either the workflow or its run id";
            if (key != null) {
                msg = String.format("%s or the specified key at the specified scope", msg);
            }
            throw new NotFoundException((Object)workflowRunId, msg);
        }
        return (WorkflowTokenNodeDetail)ObjectResponse.fromJsonBody((HttpResponse)response, WorkflowTokenNodeDetail.class, (Gson)GSON).getResponseObject();
    }

    private String appendScopeAndKeyToUrl(String workflowTokenUrl, @Nullable WorkflowToken.Scope scope, String key) {
        StringBuilder output = new StringBuilder(workflowTokenUrl);
        if (scope != null) {
            output.append(String.format("?scope=%s", scope.name()));
            if (key != null) {
                output.append(String.format("&key=%s", key));
            }
        } else if (key != null) {
            output.append(String.format("?key=%s", key));
        }
        return output.toString();
    }
}

