/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.api.annotation.Beta;
import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.UnauthorizedException;
import co.cask.cdap.common.namespace.AbstractNamespaceClient;
import co.cask.common.http.HttpRequest;
import co.cask.common.http.HttpResponse;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.inject.Inject;

@Beta
public class NamespaceClient
extends AbstractNamespaceClient {
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public NamespaceClient(ClientConfig config, RESTClient restClient) {
        this.config = config;
        this.restClient = restClient;
    }

    public NamespaceClient(ClientConfig config) {
        this.config = config;
        this.restClient = new RESTClient(config);
    }

    protected HttpResponse execute(HttpRequest request) throws IOException, UnauthorizedException {
        return this.restClient.execute(request, this.config.getAccessToken(), 400, 404, 403);
    }

    protected URL resolve(String resource) throws MalformedURLException {
        return this.config.resolveURLV3(resource);
    }
}

