/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.api.annotation.Beta;
import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.AlreadyExistsException;
import co.cask.cdap.common.BadRequestException;
import co.cask.cdap.common.DatasetModuleAlreadyExistsException;
import co.cask.cdap.common.DatasetModuleCannotBeDeletedException;
import co.cask.cdap.common.DatasetModuleNotFoundException;
import co.cask.cdap.common.UnauthorizedException;
import co.cask.cdap.common.utils.Tasks;
import co.cask.cdap.proto.DatasetModuleMeta;
import co.cask.cdap.proto.Id;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpRequest;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;

@Beta
public class DatasetModuleClient {
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public DatasetModuleClient(ClientConfig config, RESTClient restClient) {
        this.config = config;
        this.restClient = restClient;
    }

    public DatasetModuleClient(ClientConfig config) {
        this.config = config;
        this.restClient = new RESTClient(config);
    }

    @Deprecated
    public List<DatasetModuleMeta> list() throws IOException, UnauthorizedException {
        return this.list(this.config.getNamespace());
    }

    @Deprecated
    public void add(String moduleName, String className, File moduleJarFile) throws BadRequestException, AlreadyExistsException, IOException, UnauthorizedException {
        this.add(Id.DatasetModule.from((Id.Namespace)this.config.getNamespace(), (String)moduleName), className, moduleJarFile);
    }

    @Deprecated
    public void delete(String moduleName) throws DatasetModuleCannotBeDeletedException, DatasetModuleNotFoundException, IOException, UnauthorizedException {
        this.delete(Id.DatasetModule.from((Id.Namespace)this.config.getNamespace(), (String)moduleName));
    }

    @Deprecated
    public boolean exists(String moduleName) throws IOException, UnauthorizedException {
        return this.exists(Id.DatasetModule.from((Id.Namespace)this.config.getNamespace(), (String)moduleName));
    }

    @Deprecated
    public void waitForExists(String moduleName, long timeout, TimeUnit timeoutUnit) throws IOException, UnauthorizedException, TimeoutException, InterruptedException {
        this.waitForExists(Id.DatasetModule.from((Id.Namespace)this.config.getNamespace(), (String)moduleName), timeout, timeoutUnit);
    }

    @Deprecated
    public void waitForDeleted(String moduleName, long timeout, TimeUnit timeoutUnit) throws IOException, UnauthorizedException, TimeoutException, InterruptedException {
        this.waitForDeleted(Id.DatasetModule.from((Id.Namespace)this.config.getNamespace(), (String)moduleName), timeout, timeoutUnit);
    }

    @Deprecated
    public void deleteAll() throws DatasetModuleCannotBeDeletedException, IOException, UnauthorizedException {
        this.deleteAll(this.config.getNamespace());
    }

    @Deprecated
    public DatasetModuleMeta get(String moduleName) throws DatasetModuleNotFoundException, IOException, UnauthorizedException {
        return this.get(Id.DatasetModule.from((Id.Namespace)this.config.getNamespace(), (String)moduleName));
    }

    public List<DatasetModuleMeta> list(Id.Namespace namespace) throws IOException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(namespace, "data/modules");
        return (List)ObjectResponse.fromJsonBody((HttpResponse)this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), new int[0]), (TypeToken)new TypeToken<List<DatasetModuleMeta>>(){}).getResponseObject();
    }

    public void add(Id.DatasetModule module, String className, File moduleJarFile) throws BadRequestException, AlreadyExistsException, IOException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(module.getNamespace(), String.format("data/modules/%s", module.getId()));
        ImmutableMap headers = ImmutableMap.of((Object)"X-Class-Name", (Object)className);
        HttpRequest request = HttpRequest.put((URL)url).addHeaders((Map)headers).withBody(moduleJarFile).build();
        HttpResponse response = this.restClient.upload(request, this.config.getAccessToken(), 400, 409);
        if (response.getResponseCode() == 400) {
            throw new BadRequestException(String.format("Module jar file does not exist: %s", moduleJarFile));
        }
        if (response.getResponseCode() == 409) {
            throw new DatasetModuleAlreadyExistsException(module);
        }
    }

    public void delete(Id.DatasetModule module) throws DatasetModuleCannotBeDeletedException, DatasetModuleNotFoundException, IOException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(module.getNamespace(), String.format("data/modules/%s", module.getId()));
        HttpResponse response = this.restClient.execute(HttpMethod.DELETE, url, this.config.getAccessToken(), 409, 404);
        if (response.getResponseCode() == 409) {
            throw new DatasetModuleCannotBeDeletedException(module);
        }
        if (response.getResponseCode() == 404) {
            throw new DatasetModuleNotFoundException(module);
        }
    }

    public boolean exists(Id.DatasetModule module) throws IOException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(module.getNamespace(), String.format("data/modules/%s", module.getId()));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        return response.getResponseCode() != 404;
    }

    public void waitForExists(final Id.DatasetModule module, long timeout, TimeUnit timeoutUnit) throws IOException, UnauthorizedException, TimeoutException, InterruptedException {
        try {
            Tasks.waitFor((Object)true, (Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return DatasetModuleClient.this.exists(module);
                }
            }, (long)timeout, (TimeUnit)timeoutUnit, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), IOException.class, UnauthorizedException.class);
        }
    }

    public void waitForDeleted(final Id.DatasetModule module, long timeout, TimeUnit timeoutUnit) throws IOException, UnauthorizedException, TimeoutException, InterruptedException {
        try {
            Tasks.waitFor((Object)false, (Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return DatasetModuleClient.this.exists(module);
                }
            }, (long)timeout, (TimeUnit)timeoutUnit, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), IOException.class, UnauthorizedException.class);
        }
    }

    public void deleteAll(Id.Namespace namespace) throws DatasetModuleCannotBeDeletedException, IOException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(namespace, "data/modules");
        HttpResponse response = this.restClient.execute(HttpMethod.DELETE, url, this.config.getAccessToken(), 409);
        if (response.getResponseCode() == 409) {
            throw new DatasetModuleCannotBeDeletedException(null);
        }
    }

    public DatasetModuleMeta get(Id.DatasetModule module) throws DatasetModuleNotFoundException, IOException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(module.getNamespace(), String.format("data/modules/%s", module.getId()));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new DatasetModuleNotFoundException(module);
        }
        return (DatasetModuleMeta)ObjectResponse.fromJsonBody((HttpResponse)response, DatasetModuleMeta.class).getResponseObject();
    }
}

