/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.api.schedule.ScheduleSpecification;
import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.exception.NotFoundException;
import co.cask.cdap.common.exception.UnauthorizedException;
import co.cask.cdap.proto.Id;
import co.cask.cdap.proto.ProgramStatus;
import co.cask.cdap.proto.ProgramType;
import co.cask.cdap.proto.codec.ScheduleSpecificationCodec;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.List;
import javax.inject.Inject;

public class ScheduleClient {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(ScheduleSpecification.class, (Object)new ScheduleSpecificationCodec()).create();
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public ScheduleClient(ClientConfig config, RESTClient restClient) {
        this.config = config;
        this.restClient = restClient;
    }

    public ScheduleClient(ClientConfig config) {
        this.config = config;
        this.restClient = new RESTClient(config);
    }

    public List<ScheduleSpecification> list(String appId, String workflowId) throws IOException, UnauthorizedException, NotFoundException {
        String path = String.format("apps/%s/workflows/%s/schedules", appId, workflowId);
        URL url = this.config.resolveNamespacedURLV3(path);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (404 == response.getResponseCode()) {
            throw new NotFoundException((Id)Id.Program.from((Id.Namespace)this.config.getNamespace(), (String)appId, (ProgramType)ProgramType.WORKFLOW, (String)workflowId));
        }
        ObjectResponse objectResponse = ObjectResponse.fromJsonBody((HttpResponse)response, (Type)new TypeToken<List<ScheduleSpecification>>(){}.getType(), (Gson)GSON);
        return (List)objectResponse.getResponseObject();
    }

    public void suspend(String appId, String scheduleId) throws IOException, UnauthorizedException, NotFoundException {
        String path = String.format("apps/%s/schedules/%s/suspend", appId, scheduleId);
        URL url = this.config.resolveNamespacedURLV3(path);
        HttpResponse response = this.restClient.execute(HttpMethod.POST, url, this.config.getAccessToken(), 404);
        if (404 == response.getResponseCode()) {
            throw new NotFoundException((Id)Id.Schedule.from((Id.Namespace)this.config.getNamespace(), (String)appId, (String)scheduleId));
        }
    }

    public void resume(String appId, String scheduleId) throws IOException, UnauthorizedException, NotFoundException {
        String path = String.format("apps/%s/schedules/%s/resume", appId, scheduleId);
        URL url = this.config.resolveNamespacedURLV3(path);
        HttpResponse response = this.restClient.execute(HttpMethod.POST, url, this.config.getAccessToken(), 404);
        if (404 == response.getResponseCode()) {
            throw new NotFoundException((Id)Id.Schedule.from((Id.Namespace)this.config.getNamespace(), (String)appId, (String)scheduleId));
        }
    }

    public String getStatus(String appId, String scheduleId) throws IOException, UnauthorizedException, NotFoundException {
        String path = String.format("apps/%s/schedules/%s/status", appId, scheduleId);
        URL url = this.config.resolveNamespacedURLV3(path);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (404 == response.getResponseCode()) {
            throw new NotFoundException((Id)Id.Schedule.from((Id.Namespace)this.config.getNamespace(), (String)appId, (String)scheduleId));
        }
        return ((ProgramStatus)ObjectResponse.fromJsonBody((HttpResponse)response, ProgramStatus.class).getResponseObject()).getStatus();
    }
}

