/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.api.metrics.RuntimeMetrics;
import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.exception.UnauthorizedException;
import co.cask.cdap.common.metrics.MetricsContexts;
import co.cask.cdap.proto.Id;
import co.cask.cdap.proto.MetricQueryResult;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import com.google.common.base.Joiner;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import javax.inject.Inject;

public class MetricsClient {
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public MetricsClient(ClientConfig config, RESTClient restClient) {
        this.config = config;
        this.restClient = restClient;
    }

    public MetricsClient(ClientConfig config) {
        this.config = config;
        this.restClient = new RESTClient(config);
    }

    public MetricQueryResult query(String metric, @Nullable Map<String, String> context, @Nullable String start, @Nullable String end, @Nullable String groupBy) throws IOException, UnauthorizedException {
        URL url = this.config.resolveURLV3(String.format("metrics/query?metric=%s%s%s%s%s", metric, start == null ? "" : "&start=" + start, end == null ? "" : "&end=" + end, context == null ? "" : "&context=" + this.contextToPathParam(context), groupBy == null ? "" : "&groupBy=" + groupBy));
        HttpResponse response = this.restClient.execute(HttpMethod.POST, url, this.config.getAccessToken(), new int[0]);
        return (MetricQueryResult)ObjectResponse.fromJsonBody((HttpResponse)response, MetricQueryResult.class).getResponseObject();
    }

    public MetricQueryResult query(String metric, Map<String, String> context) throws IOException, UnauthorizedException {
        return this.query(metric, context, null, null, null);
    }

    public MetricQueryResult query(String metric) throws IOException, UnauthorizedException {
        return this.query(metric, null, null, null, null);
    }

    public RuntimeMetrics getFlowletMetrics(Id.Program flowId, String flowletId) {
        return this.getMetrics(MetricsContexts.forFlowlet((Id.Program)flowId, (String)flowletId), "system.process.tuples.read", "system.process.events.processed", "system.process.errors");
    }

    public RuntimeMetrics getServiceMetrics(Id.Program serviceId) {
        return this.getMetrics(MetricsContexts.forService((Id.Program)serviceId), "system.requests.count", "system.response.successful.count", "system.response.server.error.count");
    }

    private RuntimeMetrics getMetrics(final Map<String, String> context, final String inputName, final String processedName, final String exceptionName) {
        return new RuntimeMetrics(){

            public long getInput() {
                return MetricsClient.this.getTotalCounter(context, inputName);
            }

            public long getProcessed() {
                return MetricsClient.this.getTotalCounter(context, processedName);
            }

            public long getException() {
                return MetricsClient.this.getTotalCounter(context, exceptionName);
            }

            public void waitForinput(long count, long timeout, TimeUnit timeoutUnit) throws TimeoutException, InterruptedException {
                this.doWaitFor(inputName, count, timeout, timeoutUnit);
            }

            public void waitForProcessed(long count, long timeout, TimeUnit timeoutUnit) throws TimeoutException, InterruptedException {
                this.doWaitFor(processedName, count, timeout, timeoutUnit);
            }

            public void waitForException(long count, long timeout, TimeUnit timeoutUnit) throws TimeoutException, InterruptedException {
                this.doWaitFor(exceptionName, count, timeout, timeoutUnit);
            }

            public void waitFor(String name, long count, long timeout, TimeUnit timeoutUnit) throws TimeoutException, InterruptedException {
                this.doWaitFor(name, count, timeout, timeoutUnit);
            }

            private void doWaitFor(String name, long count, long timeout, TimeUnit timeoutUnit) throws TimeoutException, InterruptedException {
                long value = MetricsClient.this.getTotalCounter(context, name);
                long sleepMillis = Math.max(10L, Math.min(timeoutUnit.toMillis(timeout) / 10L, TimeUnit.SECONDS.toMillis(1L)));
                Stopwatch stopwatch = new Stopwatch().start();
                while (value < count && stopwatch.elapsedTime(timeoutUnit) < timeout) {
                    TimeUnit.MILLISECONDS.sleep(sleepMillis);
                    value = MetricsClient.this.getTotalCounter(context, name);
                }
                if (value < count) {
                    throw new TimeoutException("Time limit reached. Got '" + value + "' instead of '" + count + "'");
                }
            }

            public String toString() {
                return String.format("%s; input=%d, processed=%d, exception=%d", Joiner.on((String)",").withKeyValueSeparator(":").join(context), this.getInput(), this.getProcessed(), this.getException());
            }
        };
    }

    private String contextToPathParam(Map<String, String> context) {
        return Joiner.on((String)".").withKeyValueSeparator(".").join(context);
    }

    private long getTotalCounter(Map<String, String> context, String metricName) {
        try {
            MetricQueryResult.TimeSeries[] result = this.query(metricName, context).getSeries();
            if (result.length == 0) {
                return 0L;
            }
            MetricQueryResult.TimeValue[] timeValues = result[0].getData();
            if (timeValues.length == 0) {
                return 0L;
            }
            return timeValues[0].getValue();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

