/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.exception.UnauthorizedException;
import co.cask.cdap.proto.Version;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import java.io.IOException;
import javax.inject.Inject;

public class MetaClient {
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public MetaClient(ClientConfig config, RESTClient restClient) {
        this.config = config;
        this.restClient = restClient;
    }

    public MetaClient(ClientConfig config) {
        this.config = config;
        this.restClient = new RESTClient(config);
    }

    public void ping() throws IOException, UnauthorizedException {
        this.restClient.execute(HttpMethod.GET, this.config.resolveURLNoVersion("ping"), this.config.getAccessToken(), new int[0]);
    }

    public Version getVersion() throws IOException, UnauthorizedException {
        HttpResponse response = this.restClient.execute(HttpMethod.GET, this.config.resolveURL("version"), this.config.getAccessToken(), new int[0]);
        return (Version)ObjectResponse.fromJsonBody((HttpResponse)response, Version.class).getResponseObject();
    }
}

