/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.exception.ApplicationNotFoundException;
import co.cask.cdap.common.exception.UnauthorizedException;
import co.cask.cdap.common.utils.Tasks;
import co.cask.cdap.proto.ApplicationDetail;
import co.cask.cdap.proto.ApplicationRecord;
import co.cask.cdap.proto.Id;
import co.cask.cdap.proto.ProgramRecord;
import co.cask.cdap.proto.ProgramType;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpRequest;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;

public class ApplicationClient {
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public ApplicationClient(ClientConfig config, RESTClient restClient) {
        this.config = config;
        this.restClient = restClient;
    }

    public ApplicationClient(ClientConfig config) {
        this.config = config;
        this.restClient = new RESTClient(config);
    }

    public List<ApplicationRecord> list() throws IOException, UnauthorizedException {
        HttpResponse response = this.restClient.execute(HttpMethod.GET, this.config.resolveNamespacedURLV3("apps"), this.config.getAccessToken(), new int[0]);
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<List<ApplicationRecord>>(){}).getResponseObject();
    }

    public void delete(String appId) throws ApplicationNotFoundException, IOException, UnauthorizedException {
        Id.Application app = Id.Application.from((Id.Namespace)this.config.getNamespace(), (String)appId);
        HttpResponse response = this.restClient.execute(HttpMethod.DELETE, this.config.resolveNamespacedURLV3("apps/" + app.getId()), this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ApplicationNotFoundException(app);
        }
    }

    public void deleteAll() throws IOException, UnauthorizedException {
        this.restClient.execute(HttpMethod.DELETE, this.config.resolveNamespacedURLV3("apps"), this.config.getAccessToken(), new int[0]);
    }

    public boolean exists(String appId) throws IOException, UnauthorizedException {
        HttpResponse response = this.restClient.execute(HttpMethod.GET, this.config.resolveNamespacedURLV3("apps/" + appId), this.config.getAccessToken(), 404);
        return response.getResponseCode() != 404;
    }

    public void waitForDeployed(final String appId, long timeout, TimeUnit timeoutUnit) throws IOException, UnauthorizedException, TimeoutException, InterruptedException {
        try {
            Tasks.waitFor((Object)true, (Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return ApplicationClient.this.exists(appId);
                }
            }, (long)timeout, (TimeUnit)timeoutUnit, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), IOException.class, UnauthorizedException.class);
        }
    }

    public void waitForDeleted(final String appId, long timeout, TimeUnit timeoutUnit) throws IOException, UnauthorizedException, TimeoutException, InterruptedException {
        try {
            Tasks.waitFor((Object)false, (Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return ApplicationClient.this.exists(appId);
                }
            }, (long)timeout, (TimeUnit)timeoutUnit, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), IOException.class, UnauthorizedException.class);
        }
    }

    public void deploy(File jarFile) throws IOException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3("apps");
        ImmutableMap headers = ImmutableMap.of((Object)"X-Archive-Name", (Object)jarFile.getName());
        HttpRequest request = HttpRequest.post((URL)url).addHeaders((Map)headers).withBody(jarFile).build();
        this.restClient.upload(request, this.config.getAccessToken(), new int[0]);
    }

    public List<ProgramRecord> listAllPrograms(ProgramType programType) throws IOException, UnauthorizedException {
        Preconditions.checkArgument((boolean)programType.isListable());
        String path = programType.getCategoryName();
        URL url = this.config.resolveNamespacedURLV3(path);
        HttpRequest request = HttpRequest.get((URL)url).build();
        ObjectResponse response = ObjectResponse.fromJsonBody((HttpResponse)this.restClient.execute(request, this.config.getAccessToken(), new int[0]), (TypeToken)new TypeToken<List<ProgramRecord>>(){});
        return (List)response.getResponseObject();
    }

    public Map<ProgramType, List<ProgramRecord>> listAllPrograms() throws IOException, UnauthorizedException {
        ImmutableMap.Builder allPrograms = ImmutableMap.builder();
        for (ProgramType programType : ProgramType.values()) {
            if (!programType.isListable()) continue;
            ArrayList programRecords = Lists.newArrayList();
            programRecords.addAll(this.listAllPrograms(programType));
            allPrograms.put((Object)programType, (Object)programRecords);
        }
        return allPrograms.build();
    }

    public List<ProgramRecord> listPrograms(String appId, ProgramType programType) throws ApplicationNotFoundException, IOException, UnauthorizedException {
        Preconditions.checkArgument((boolean)programType.isListable());
        ArrayList programs = Lists.newArrayList();
        for (ProgramRecord program : this.listPrograms(appId)) {
            if (!programType.equals((Object)program.getType())) continue;
            programs.add(program);
        }
        return programs;
    }

    public Map<ProgramType, List<ProgramRecord>> listProgramsByType(String appId) throws ApplicationNotFoundException, IOException, UnauthorizedException {
        HashMap result = Maps.newHashMap();
        for (ProgramType type : ProgramType.values()) {
            result.put(type, Lists.newArrayList());
        }
        for (ProgramRecord program : this.listPrograms(appId)) {
            ((List)result.get(program.getType())).add(program);
        }
        return result;
    }

    public List<ProgramRecord> listPrograms(String appId) throws ApplicationNotFoundException, IOException, UnauthorizedException {
        String path = String.format("apps/%s", appId);
        URL url = this.config.resolveNamespacedURLV3(path);
        HttpRequest request = HttpRequest.get((URL)url).build();
        ObjectResponse response = ObjectResponse.fromJsonBody((HttpResponse)this.restClient.execute(request, this.config.getAccessToken(), 404), (TypeToken)new TypeToken<ApplicationDetail>(){});
        if (response.getResponseCode() == 404) {
            throw new ApplicationNotFoundException(Id.Application.from((Id.Namespace)this.config.getNamespace(), (String)appId));
        }
        return ((ApplicationDetail)response.getResponseObject()).getPrograms();
    }
}

