/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.exception.AdapterNotFoundException;
import co.cask.cdap.common.exception.ApplicationTemplateNotFoundException;
import co.cask.cdap.common.exception.BadRequestException;
import co.cask.cdap.common.exception.UnauthorizedException;
import co.cask.cdap.common.utils.Tasks;
import co.cask.cdap.proto.AdapterConfig;
import co.cask.cdap.proto.AdapterDetail;
import co.cask.cdap.proto.AdapterStatus;
import co.cask.cdap.proto.Id;
import co.cask.cdap.proto.ProgramId;
import co.cask.cdap.proto.ProgramRunStatus;
import co.cask.cdap.proto.RunRecord;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpRequest;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.HashMultimap;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import javax.inject.Inject;

public class AdapterClient {
    private static final Gson GSON = new Gson();
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public AdapterClient(ClientConfig config, RESTClient restClient) {
        this.config = config;
        this.restClient = restClient;
    }

    public AdapterClient(ClientConfig config) {
        this.config = config;
        this.restClient = new RESTClient(config);
    }

    public List<AdapterDetail> list() throws IOException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3("adapters");
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), new int[0]);
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<List<AdapterDetail>>(){}, (Gson)GSON).getResponseObject();
    }

    public AdapterDetail get(String adapterName) throws AdapterNotFoundException, IOException, UnauthorizedException {
        Id.Adapter adapter = Id.Adapter.from((Id.Namespace)this.config.getNamespace(), (String)adapterName);
        URL url = this.config.resolveNamespacedURLV3("adapters/" + adapterName);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new AdapterNotFoundException(adapter);
        }
        return (AdapterDetail)ObjectResponse.fromJsonBody((HttpResponse)response, AdapterDetail.class, (Gson)GSON).getResponseObject();
    }

    public void create(String adapterName, AdapterConfig adapterSpec) throws ApplicationTemplateNotFoundException, BadRequestException, IOException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(String.format("adapters/%s", adapterName));
        HttpRequest request = HttpRequest.put((URL)url).withBody(GSON.toJson((Object)adapterSpec)).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 404, 400);
        if (response.getResponseCode() == 404) {
            throw new ApplicationTemplateNotFoundException(Id.ApplicationTemplate.from((String)adapterSpec.getTemplate()));
        }
        if (response.getResponseCode() == 400) {
            throw new BadRequestException(response.getResponseBodyAsString());
        }
    }

    public void delete(String adapterName) throws AdapterNotFoundException, IOException, UnauthorizedException {
        Id.Adapter adapter = Id.Adapter.from((Id.Namespace)this.config.getNamespace(), (String)adapterName);
        URL url = this.config.resolveNamespacedURLV3(String.format("adapters/%s", adapterName));
        HttpResponse response = this.restClient.execute(HttpMethod.DELETE, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new AdapterNotFoundException(adapter);
        }
    }

    public boolean exists(String adapterName) throws IOException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(String.format("adapters/%s", adapterName));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        return response.getResponseCode() != 404;
    }

    public void waitForExists(final String adapterName, long timeout, TimeUnit timeoutUnit) throws IOException, UnauthorizedException, TimeoutException, InterruptedException {
        try {
            Tasks.waitFor((Object)true, (Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return AdapterClient.this.exists(adapterName);
                }
            }, (long)timeout, (TimeUnit)timeoutUnit, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), IOException.class, UnauthorizedException.class);
        }
    }

    public void waitForDeleted(final String adapterName, long timeout, TimeUnit timeoutUnit) throws IOException, UnauthorizedException, TimeoutException, InterruptedException {
        try {
            Tasks.waitFor((Object)false, (Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return AdapterClient.this.exists(adapterName);
                }
            }, (long)timeout, (TimeUnit)timeoutUnit, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), IOException.class, UnauthorizedException.class);
        }
    }

    public void start(String adapterName) throws IOException, UnauthorizedException, AdapterNotFoundException {
        Id.Adapter adapter = Id.Adapter.from((Id.Namespace)this.config.getNamespace(), (String)adapterName);
        URL url = this.config.resolveNamespacedURLV3(String.format("adapters/%s/start", adapterName));
        HttpResponse response = this.restClient.execute(HttpMethod.POST, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new AdapterNotFoundException(adapter);
        }
    }

    public void stop(String adapterName) throws IOException, UnauthorizedException, AdapterNotFoundException {
        Id.Adapter adapter = Id.Adapter.from((Id.Namespace)this.config.getNamespace(), (String)adapterName);
        URL url = this.config.resolveNamespacedURLV3(String.format("adapters/%s/stop", adapterName));
        HttpResponse response = this.restClient.execute(HttpMethod.POST, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new AdapterNotFoundException(adapter);
        }
    }

    public void waitForStatus(final String adapterName, final AdapterStatus status, long timeout, TimeUnit timeoutUnit) throws IOException, UnauthorizedException, TimeoutException, InterruptedException {
        try {
            Tasks.waitFor((Object)true, (Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return status.equals((Object)AdapterClient.this.getStatus(adapterName));
                }
            }, (long)timeout, (TimeUnit)timeoutUnit, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), IOException.class, UnauthorizedException.class);
        }
    }

    public String getLogs(String adapterName) throws AdapterNotFoundException, UnauthorizedException, IOException {
        return this.getLogs(adapterName, null, null, null, null);
    }

    public String getLogs(String adapterName, @Nullable Long start, @Nullable Long stop) throws AdapterNotFoundException, UnauthorizedException, IOException {
        return this.getLogs(adapterName, start, stop, null, null);
    }

    public String getLogs(String adapterName, @Nullable Long start, @Nullable Long stop, @Nullable Boolean escape, @Nullable String filter) throws IOException, AdapterNotFoundException, UnauthorizedException {
        HashMultimap queryParams = HashMultimap.create();
        queryParams.put((Object)"adapterid", (Object)adapterName);
        if (start != null) {
            queryParams.put((Object)"start", (Object)Long.toString(start));
        }
        if (stop != null) {
            queryParams.put((Object)"stop", (Object)Long.toString(stop));
        }
        if (escape != null) {
            queryParams.put((Object)"escape", (Object)Boolean.toString(escape));
        }
        if (filter != null) {
            queryParams.put((Object)"filter", (Object)filter);
        }
        String queryString = Joiner.on((String)"&").join((Iterable)queryParams.entries());
        AdapterDetail adapterDetail = this.get(adapterName);
        ProgramId program = adapterDetail.getProgram();
        Id.Adapter adapter = Id.Adapter.from((Id.Namespace)this.config.getNamespace(), (String)adapterName);
        URL url = this.config.resolveNamespacedURLV3(String.format("apps/%s/%s/%s/logs?%s", program.getApplication(), program.getType().getCategoryName(), program.getId(), queryString));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new AdapterNotFoundException(adapter);
        }
        return response.getResponseBodyAsString();
    }

    public AdapterStatus getStatus(String adapterName) throws IOException, UnauthorizedException, AdapterNotFoundException {
        Id.Adapter adapter = Id.Adapter.from((Id.Namespace)this.config.getNamespace(), (String)adapterName);
        URL url = this.config.resolveNamespacedURLV3(String.format("adapters/%s/status", adapterName));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new AdapterNotFoundException(adapter);
        }
        Map statusMap = (Map)ObjectResponse.fromJsonBody((HttpResponse)response, (Type)new TypeToken<Map<String, String>>(){}.getType()).getResponseObject();
        return AdapterStatus.valueOf((String)((String)statusMap.get("status")));
    }

    public List<RunRecord> getRuns(String adapterName, ProgramRunStatus status, long startTs, long endTs, @Nullable Integer resultLimit) throws IOException, UnauthorizedException, AdapterNotFoundException {
        String query = "?status" + status + "&start=" + startTs + "&end=" + endTs + (resultLimit == null ? "" : "&resultLimit=" + resultLimit);
        Id.Adapter adapter = Id.Adapter.from((Id.Namespace)this.config.getNamespace(), (String)adapterName);
        URL url = this.config.resolveNamespacedURLV3(String.format("adapters/%s/runs" + query, adapterName));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new AdapterNotFoundException(adapter);
        }
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (Type)new TypeToken<List<RunRecord>>(){}.getType()).getResponseObject();
    }
}

