/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client.util;

import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.common.conf.Constants;
import co.cask.cdap.proto.ProgramType;
import com.google.common.base.Preconditions;
import java.net.MalformedURLException;
import java.net.URL;

public class VersionMigrationUtils {
    private VersionMigrationUtils() {
    }

    public static boolean isProcedureSupported(ClientConfig config) {
        return Constants.DEFAULT_NAMESPACE_ID.equals((Object)config.getConnectionConfig().getNamespace());
    }

    public static boolean isProgramSupported(ClientConfig config, ProgramType programType) {
        return ProgramType.PROCEDURE != programType || VersionMigrationUtils.isProcedureSupported(config);
    }

    public static void assertProcedureSupported(ClientConfig config) {
        Preconditions.checkState((boolean)VersionMigrationUtils.isProcedureSupported(config), (Object)"Procedure operations are only supported in the default namespace.");
        Preconditions.checkState((boolean)"v2".equals(config.getApiVersion()), (Object)"Procedure operations are only supported in V2 APIs.");
    }

    public static URL resolveURL(ClientConfig config, ProgramType programType, String path) throws MalformedURLException {
        if (ProgramType.PROCEDURE == programType) {
            VersionMigrationUtils.assertProcedureSupported(config);
            return config.resolveURL(path);
        }
        return config.resolveNamespacedURLV3(path);
    }
}

