/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client.config;

import co.cask.cdap.client.config.ConnectionConfig;
import co.cask.cdap.client.exception.DisconnectedException;
import co.cask.cdap.proto.Id;
import co.cask.cdap.security.authentication.client.AccessToken;
import co.cask.common.http.HttpRequestConfig;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.Nullable;

public class ClientConfig {
    private static final boolean DEFAULT_VERIFY_SSL_CERTIFICATE = true;
    private static final int DEFAULT_UPLOAD_READ_TIMEOUT = 15000;
    private static final int DEFAULT_UPLOAD_CONNECT_TIMEOUT = 15000;
    private static final int DEFAULT_SERVICE_UNAVAILABLE_RETRY_LIMIT = 50;
    private static final int DEFAULT_READ_TIMEOUT = 15000;
    private static final int DEFAULT_CONNECT_TIMEOUT = 15000;
    private static final String DEFAULT_VERSION = "v2";
    @Nullable
    private ConnectionConfig connectionConfig;
    private boolean verifySSLCert;
    private int defaultReadTimeout;
    private int defaultConnectTimeout;
    private int uploadReadTimeout;
    private int uploadConnectTimeout;
    private int unavailableRetryLimit;
    private String apiVersion;
    private Supplier<AccessToken> accessToken;

    private ClientConfig(@Nullable ConnectionConfig connectionConfig, boolean verifySSLCert, int unavailableRetryLimit, String apiVersion, Supplier<AccessToken> accessToken, int defaultReadTimeout, int defaultConnectTimeout, int uploadReadTimeout, int uploadConnectTimeout) {
        this.connectionConfig = connectionConfig;
        this.verifySSLCert = verifySSLCert;
        this.apiVersion = apiVersion;
        this.unavailableRetryLimit = unavailableRetryLimit;
        this.accessToken = accessToken;
        this.defaultReadTimeout = defaultReadTimeout;
        this.defaultConnectTimeout = defaultConnectTimeout;
        this.uploadReadTimeout = uploadReadTimeout;
        this.uploadConnectTimeout = uploadConnectTimeout;
    }

    public static ClientConfig getDefault() {
        return ClientConfig.builder().build();
    }

    private URL resolveURL(String apiVersion, String path) throws DisconnectedException, MalformedURLException {
        return this.getConnectionConfig().resolveURI(apiVersion, path).toURL();
    }

    public URL resolveURL(String path) throws DisconnectedException, MalformedURLException {
        return this.resolveURL(this.apiVersion, path);
    }

    public URL resolveURLV3(String path) throws MalformedURLException {
        return this.resolveURL("v3", path);
    }

    public URL resolveNamespacedURLV3(String path) throws MalformedURLException {
        return this.getConnectionConfig().resolveNamespacedURI("v3", path).toURL();
    }

    public HttpRequestConfig getDefaultRequestConfig() {
        if (this.connectionConfig == null) {
            throw new DisconnectedException();
        }
        return new HttpRequestConfig(this.defaultConnectTimeout, this.defaultReadTimeout, this.verifySSLCert);
    }

    public HttpRequestConfig getUploadRequestConfig() {
        if (this.connectionConfig == null) {
            throw new DisconnectedException();
        }
        return new HttpRequestConfig(this.uploadConnectTimeout, this.uploadReadTimeout, this.verifySSLCert);
    }

    public int getDefaultReadTimeout() {
        return this.defaultReadTimeout;
    }

    public int getDefaultConnectTimeout() {
        return this.defaultConnectTimeout;
    }

    public int getUploadReadTimeout() {
        return this.uploadReadTimeout;
    }

    public int getUploadConnectTimeout() {
        return this.uploadConnectTimeout;
    }

    public void setConnectionConfig(@Nullable ConnectionConfig connectionConfig) {
        this.connectionConfig = connectionConfig;
    }

    public ConnectionConfig getConnectionConfig() {
        if (this.connectionConfig == null) {
            throw new DisconnectedException();
        }
        return this.connectionConfig;
    }

    public boolean isVerifySSLCert() {
        return this.verifySSLCert;
    }

    public void setVerifySSLCert(boolean verifySSLCert) {
        this.verifySSLCert = verifySSLCert;
    }

    public void setDefaultReadTimeout(int defaultReadTimeout) {
        this.defaultReadTimeout = defaultReadTimeout;
    }

    public void setDefaultConnectTimeout(int defaultConnectTimeout) {
        this.defaultConnectTimeout = defaultConnectTimeout;
    }

    public void setUploadReadTimeout(int uploadReadTimeout) {
        this.uploadReadTimeout = uploadReadTimeout;
    }

    public void setUploadConnectTimeout(int uploadConnectTimeout) {
        this.uploadConnectTimeout = uploadConnectTimeout;
    }

    public void setUnavailableRetryLimit(int unavailableRetryLimit) {
        this.unavailableRetryLimit = unavailableRetryLimit;
    }

    public Id.Namespace getNamespace() {
        return this.connectionConfig.getNamespace();
    }

    public void setNamespace(Id.Namespace namespace) {
        this.connectionConfig = ConnectionConfig.builder(this.connectionConfig).setNamespace(namespace).build();
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public int getUnavailableRetryLimit() {
        return this.unavailableRetryLimit;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public void setAllTimeouts(int timeout) {
        this.defaultConnectTimeout = timeout;
        this.defaultReadTimeout = timeout;
        this.uploadConnectTimeout = timeout;
        this.uploadReadTimeout = timeout;
    }

    @Nullable
    public AccessToken getAccessToken() {
        return (AccessToken)this.accessToken.get();
    }

    public Supplier<AccessToken> getAccessTokenSupplier() {
        return this.accessToken;
    }

    public void setAccessToken(Supplier<AccessToken> accessToken) {
        this.accessToken = accessToken;
    }

    public void setAccessToken(AccessToken accessToken) {
        this.accessToken = Suppliers.ofInstance((Object)accessToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ConnectionConfig connectionConfig = ConnectionConfig.DEFAULT;
        private String apiVersion = "v2";
        private Supplier<AccessToken> accessToken = Suppliers.ofInstance(null);
        private boolean verifySSLCert = true;
        private int uploadReadTimeout = 15000;
        private int uploadConnectTimeout = 15000;
        private int defaultReadTimeout = 15000;
        private int defaultConnectTimeout = 15000;
        private int unavailableRetryLimit = 50;

        public Builder() {
        }

        public Builder(ClientConfig clientConfig) {
            this.connectionConfig = clientConfig.connectionConfig;
            this.verifySSLCert = clientConfig.verifySSLCert;
            this.apiVersion = clientConfig.apiVersion;
            this.accessToken = clientConfig.accessToken;
            this.uploadReadTimeout = clientConfig.uploadReadTimeout;
            this.uploadConnectTimeout = clientConfig.uploadConnectTimeout;
            this.defaultReadTimeout = clientConfig.defaultReadTimeout;
            this.defaultConnectTimeout = clientConfig.defaultConnectTimeout;
            this.unavailableRetryLimit = clientConfig.unavailableRetryLimit;
        }

        public Builder setConnectionConfig(ConnectionConfig connectionConfig) {
            this.connectionConfig = connectionConfig;
            return this;
        }

        public Builder setVerifySSLCert(boolean verifySSLCert) {
            this.verifySSLCert = verifySSLCert;
            return this;
        }

        public Builder setUploadReadTimeout(int uploadReadTimeout) {
            this.uploadReadTimeout = uploadReadTimeout;
            return this;
        }

        public Builder setUploadConnectTimeout(int uploadConnectTimeout) {
            this.uploadConnectTimeout = uploadConnectTimeout;
            return this;
        }

        public Builder setDefaultReadTimeout(int defaultReadTimeout) {
            this.defaultReadTimeout = defaultReadTimeout;
            return this;
        }

        public Builder setDefaultConnectTimeout(int defaultConnectTimeout) {
            this.defaultConnectTimeout = defaultConnectTimeout;
            return this;
        }

        public Builder setAccessToken(Supplier<AccessToken> accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public Builder setAccessToken(AccessToken accessToken) {
            this.accessToken = Suppliers.ofInstance((Object)accessToken);
            return this;
        }

        public Builder setApiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public Builder setUnavailableRetryLimit(int retry) {
            this.unavailableRetryLimit = retry;
            return this;
        }

        public ClientConfig build() {
            return new ClientConfig(this.connectionConfig, this.verifySSLCert, this.unavailableRetryLimit, this.apiVersion, this.accessToken, this.defaultConnectTimeout, this.defaultReadTimeout, this.uploadConnectTimeout, this.uploadReadTimeout);
        }
    }
}

