/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.client.util.VersionMigrationUtils;
import co.cask.cdap.common.exception.BadRequestException;
import co.cask.cdap.common.exception.NotFoundException;
import co.cask.cdap.common.exception.UnauthorizedException;
import co.cask.cdap.proto.ProgramRecord;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpRequest;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import com.google.common.base.Charsets;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;

@Deprecated
public class ProcedureClient {
    private static final Gson GSON = new Gson();
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public ProcedureClient(ClientConfig config, RESTClient restClient) {
        this.config = config;
        this.restClient = restClient;
    }

    public ProcedureClient(ClientConfig config) {
        this.config = config;
        this.restClient = new RESTClient(config);
    }

    public String call(String appId, String procedureId, String methodId, Map<String, String> parameters) throws BadRequestException, NotFoundException, IOException, UnauthorizedException {
        return new String(this.callRaw(appId, procedureId, methodId, parameters), Charsets.UTF_8);
    }

    public byte[] callRaw(String appId, String procedureId, String methodId, Map<String, String> parameters) throws BadRequestException, NotFoundException, IOException, UnauthorizedException {
        VersionMigrationUtils.assertProcedureSupported(this.config);
        URL url = this.config.resolveURL(String.format("apps/%s/procedures/%s/methods/%s", appId, procedureId, methodId));
        HttpRequest request = HttpRequest.post((URL)url).withBody(GSON.toJson(parameters)).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 400, 404);
        if (response.getResponseCode() == 400) {
            throw new BadRequestException("The Application, Procedure and method exist, but the arguments are not as expected: " + GSON.toJson(parameters));
        }
        if (response.getResponseCode() == 404) {
            throw new NotFoundException("application or procedure or method", appId + "/" + procedureId + "/" + methodId);
        }
        return response.getResponseBody();
    }

    public List<ProgramRecord> list() throws IOException, UnauthorizedException {
        VersionMigrationUtils.assertProcedureSupported(this.config);
        URL url = this.config.resolveURL("procedures");
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), new int[0]);
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<List<ProgramRecord>>(){}).getResponseObject();
    }
}

