/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.exception.NotFoundException;
import co.cask.cdap.common.exception.ProgramNotFoundException;
import co.cask.cdap.common.exception.UnauthorizedException;
import co.cask.cdap.proto.Id;
import co.cask.cdap.proto.ProgramType;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.inject.Inject;
import java.io.IOException;
import java.net.URL;
import java.util.Map;

public class PreferencesClient {
    private static final Gson GSON = new Gson();
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public PreferencesClient(ClientConfig config, RESTClient restClient) {
        this.config = config;
        this.restClient = restClient;
    }

    public PreferencesClient(ClientConfig config) {
        this.config = config;
        this.restClient = new RESTClient(config);
    }

    public Map<String, String> getInstancePreferences() throws IOException, UnauthorizedException {
        URL url = this.config.resolveURLV3("preferences");
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), new int[0]);
        return (Map)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<Map<String, String>>(){}).getResponseObject();
    }

    public void setInstancePreferences(Map<String, String> preferences) throws IOException, UnauthorizedException {
        URL url = this.config.resolveURLV3("preferences");
        this.restClient.execute(HttpMethod.PUT, url, GSON.toJson(preferences), null, this.config.getAccessToken(), new int[0]);
    }

    public void deleteInstancePreferences() throws IOException, UnauthorizedException {
        URL url = this.config.resolveURLV3("preferences");
        this.restClient.execute(HttpMethod.DELETE, url, this.config.getAccessToken(), new int[0]);
    }

    public Map<String, String> getNamespacePreferences(Id.Namespace namespace, boolean resolved) throws IOException, UnauthorizedException, NotFoundException {
        String res = Boolean.toString(resolved);
        URL url = this.config.resolveURLV3(String.format("namespaces/%s/preferences?resolved=%s", namespace.getId(), res));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException("namespace", namespace.getId());
        }
        return (Map)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<Map<String, String>>(){}).getResponseObject();
    }

    public void setNamespacePreferences(Id.Namespace namespace, Map<String, String> preferences) throws IOException, UnauthorizedException, NotFoundException {
        URL url = this.config.resolveURLV3(String.format("namespaces/%s/preferences", namespace));
        HttpResponse response = this.restClient.execute(HttpMethod.PUT, url, GSON.toJson(preferences), null, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException("namespace", namespace.getId());
        }
    }

    public void deleteNamespacePreferences(Id.Namespace namespace) throws IOException, UnauthorizedException, NotFoundException {
        URL url = this.config.resolveURLV3(String.format("namespaces/%s/preferences", namespace.getId()));
        HttpResponse response = this.restClient.execute(HttpMethod.DELETE, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException("namespace", namespace.getId());
        }
    }

    public Map<String, String> getApplicationPreferences(Id.Application application, boolean resolved) throws IOException, UnauthorizedException, NotFoundException {
        String res = Boolean.toString(resolved);
        URL url = this.config.resolveURLV3(String.format("namespaces/%s/apps/%s/preferences?resolved=%s", application.getNamespaceId(), application.getId(), res));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException("namespace or application", application.getNamespace() + "/" + application);
        }
        return (Map)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<Map<String, String>>(){}).getResponseObject();
    }

    public void setApplicationPreferences(Id.Application application, Map<String, String> preferences) throws IOException, UnauthorizedException, NotFoundException {
        URL url = this.config.resolveURLV3(String.format("namespaces/%s/apps/%s/preferences", application.getNamespaceId(), application.getId()));
        HttpResponse response = this.restClient.execute(HttpMethod.PUT, url, GSON.toJson(preferences), null, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException("namespace or application", application.getNamespaceId() + "/" + application);
        }
    }

    public void deleteApplicationPreferences(Id.Application application) throws IOException, UnauthorizedException, NotFoundException {
        URL url = this.config.resolveURLV3(String.format("namespaces/%s/apps/%s/preferences", application.getNamespaceId(), application.getId()));
        HttpResponse response = this.restClient.execute(HttpMethod.DELETE, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException("namespace or application", application.getNamespaceId() + "/" + application);
        }
    }

    public Map<String, String> getProgramPreferences(Id.Application application, String programType, String programId, boolean resolved) throws IOException, UnauthorizedException, ProgramNotFoundException {
        String res = Boolean.toString(resolved);
        URL url = this.config.resolveURLV3(String.format("namespaces/%s/apps/%s/%s/%s/preferences?resolved=%s", application.getNamespaceId(), application.getId(), programType, programId, res));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ProgramNotFoundException(ProgramType.valueOfCategoryName((String)programType), application.getId(), programId);
        }
        return (Map)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<Map<String, String>>(){}).getResponseObject();
    }

    public void setProgramPreferences(Id.Application application, String programType, String programId, Map<String, String> preferences) throws IOException, UnauthorizedException, ProgramNotFoundException {
        URL url = this.config.resolveURLV3(String.format("namespaces/%s/apps/%s/%s/%s/preferences", application.getNamespaceId(), application.getId(), programType, programId));
        HttpResponse response = this.restClient.execute(HttpMethod.PUT, url, GSON.toJson(preferences), null, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ProgramNotFoundException(ProgramType.valueOfCategoryName((String)programType), application.getId(), programId);
        }
    }

    public void deleteProgramPreferences(Id.Application application, String programType, String programId) throws IOException, UnauthorizedException, ProgramNotFoundException {
        URL url = this.config.resolveURLV3(String.format("namespaces/%s/apps/%s/%s/%s/preferences", application.getNamespaceId(), application.getId(), programType, programId));
        HttpResponse response = this.restClient.execute(HttpMethod.DELETE, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ProgramNotFoundException(ProgramType.valueOfCategoryName((String)programType), application.getId(), programId);
        }
    }
}

