/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.exception.BadRequestException;
import co.cask.cdap.common.exception.NotFoundException;
import co.cask.cdap.common.exception.ServiceNotEnabledException;
import co.cask.cdap.common.exception.UnauthorizedException;
import co.cask.cdap.proto.Instances;
import co.cask.cdap.proto.SystemServiceMeta;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpRequest;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;

public class MonitorClient {
    private static final Gson GSON = new Gson();
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public MonitorClient(ClientConfig config, RESTClient restClient) {
        this.config = config;
        this.restClient = restClient;
    }

    public MonitorClient(ClientConfig config) {
        this.config = config;
        this.restClient = new RESTClient(config);
    }

    public List<SystemServiceMeta> listSystemServices() throws IOException, UnauthorizedException {
        URL url = this.config.resolveURL("system/services");
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), new int[0]);
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<List<SystemServiceMeta>>(){}).getResponseObject();
    }

    public String getSystemServiceStatus(String serviceName) throws IOException, NotFoundException, BadRequestException, UnauthorizedException {
        URL url = this.config.resolveURL(String.format("system/services/%s/status", serviceName));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404, 400);
        String responseBody = new String(response.getResponseBody());
        if (response.getResponseCode() == 404) {
            throw new NotFoundException("system service", serviceName);
        }
        if (response.getResponseCode() == 400) {
            throw new BadRequestException(responseBody);
        }
        Map status = (Map)GSON.fromJson(responseBody, new TypeToken<Map<String, String>>(){}.getType());
        return (String)status.get("status");
    }

    public Map<String, String> getAllSystemServiceStatus() throws IOException, UnauthorizedException {
        URL url = this.config.resolveURL("system/services/status");
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), new int[0]);
        return (Map)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<Map<String, String>>(){}).getResponseObject();
    }

    public void setSystemServiceInstances(String serviceName, int instances) throws IOException, NotFoundException, BadRequestException, UnauthorizedException {
        URL url = this.config.resolveURL(String.format("system/services/%s/instances", serviceName));
        HttpRequest request = HttpRequest.put((URL)url).withBody(GSON.toJson((Object)new Instances(instances))).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 404, 400);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException("system service", serviceName);
        }
        if (response.getResponseCode() == 400) {
            throw new BadRequestException(new String(response.getResponseBody()));
        }
    }

    public int getSystemServiceInstances(String serviceName) throws IOException, NotFoundException, ServiceNotEnabledException, UnauthorizedException {
        URL url = this.config.resolveURL(String.format("system/services/%s/instances", serviceName));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404, 403);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException("system service", serviceName);
        }
        if (response.getResponseCode() == 403) {
            throw new ServiceNotEnabledException(serviceName);
        }
        return ((Instances)ObjectResponse.fromJsonBody((HttpResponse)response, Instances.class).getResponseObject()).getInstances();
    }
}

