/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.exception.DatasetAlreadyExistsException;
import co.cask.cdap.common.exception.DatasetNotFoundException;
import co.cask.cdap.common.exception.DatasetTypeNotFoundException;
import co.cask.cdap.common.exception.UnauthorizedException;
import co.cask.cdap.common.utils.Tasks;
import co.cask.cdap.proto.DatasetInstanceConfiguration;
import co.cask.cdap.proto.DatasetSpecificationSummary;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpRequest;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;

public class DatasetClient {
    private static final Gson GSON = new Gson();
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public DatasetClient(ClientConfig config, RESTClient restClient) {
        this.config = config;
        this.restClient = restClient;
    }

    public DatasetClient(ClientConfig config) {
        this.config = config;
        this.restClient = new RESTClient(config);
    }

    public List<DatasetSpecificationSummary> list() throws IOException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3("data/datasets");
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), new int[0]);
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<List<DatasetSpecificationSummary>>(){}).getResponseObject();
    }

    public void create(String datasetName, DatasetInstanceConfiguration properties) throws DatasetTypeNotFoundException, DatasetAlreadyExistsException, IOException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(String.format("data/datasets/%s", datasetName));
        HttpRequest request = HttpRequest.put((URL)url).withBody(GSON.toJson((Object)properties)).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 404, 409);
        if (response.getResponseCode() == 404) {
            throw new DatasetTypeNotFoundException(properties.getTypeName());
        }
        if (response.getResponseCode() == 409) {
            throw new DatasetAlreadyExistsException(datasetName);
        }
    }

    public void create(String datasetName, String typeName) throws DatasetTypeNotFoundException, DatasetAlreadyExistsException, IOException, UnauthorizedException {
        this.create(datasetName, new DatasetInstanceConfiguration(typeName, (Map)ImmutableMap.of()));
    }

    public void delete(String datasetName) throws DatasetNotFoundException, IOException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(String.format("data/datasets/%s", datasetName));
        HttpResponse response = this.restClient.execute(HttpMethod.DELETE, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new DatasetNotFoundException(datasetName);
        }
    }

    public boolean exists(String datasetName) throws IOException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(String.format("data/datasets/%s", datasetName));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        return response.getResponseCode() != 404;
    }

    public void waitForExists(final String datasetName, long timeout, TimeUnit timeoutUnit) throws IOException, UnauthorizedException, TimeoutException, InterruptedException {
        try {
            Tasks.waitFor((Object)true, (Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return DatasetClient.this.exists(datasetName);
                }
            }, (long)timeout, (TimeUnit)timeoutUnit, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), IOException.class, UnauthorizedException.class);
        }
    }

    public void waitForDeleted(final String datasetName, long timeout, TimeUnit timeoutUnit) throws IOException, UnauthorizedException, TimeoutException, InterruptedException {
        try {
            Tasks.waitFor((Object)false, (Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return DatasetClient.this.exists(datasetName);
                }
            }, (long)timeout, (TimeUnit)timeoutUnit, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), IOException.class, UnauthorizedException.class);
        }
    }

    public void truncate(String datasetName) throws IOException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(String.format("data/datasets/%s/admin/truncate", datasetName));
        this.restClient.execute(HttpMethod.POST, url, this.config.getAccessToken(), new int[0]);
    }
}

