/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.exception.AdapterNotFoundException;
import co.cask.cdap.common.exception.AdapterTypeNotFoundException;
import co.cask.cdap.common.exception.BadRequestException;
import co.cask.cdap.common.exception.UnauthorizedException;
import co.cask.cdap.common.utils.Tasks;
import co.cask.cdap.proto.AdapterConfig;
import co.cask.cdap.proto.AdapterSpecification;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpRequest;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import com.google.common.base.Throwables;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;

public class AdapterClient {
    private static final Gson GSON = new Gson();
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public AdapterClient(ClientConfig config, RESTClient restClient) {
        this.config = config;
        this.restClient = restClient;
    }

    public AdapterClient(ClientConfig config) {
        this.config = config;
        this.restClient = new RESTClient(config);
    }

    public List<AdapterSpecification> list() throws IOException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3("adapters");
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), new int[0]);
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<List<AdapterSpecification>>(){}).getResponseObject();
    }

    public AdapterSpecification get(String adapterName) throws AdapterNotFoundException, IOException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3("adapters/" + adapterName);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new AdapterNotFoundException(adapterName);
        }
        return (AdapterSpecification)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<AdapterSpecification>(){}).getResponseObject();
    }

    public void create(String adapterName, AdapterConfig adapterConfig) throws AdapterTypeNotFoundException, BadRequestException, IOException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(String.format("adapters/%s", adapterName));
        HttpRequest request = HttpRequest.post((URL)url).withBody(GSON.toJson((Object)adapterConfig)).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 404, 400);
        if (response.getResponseCode() == 404) {
            throw new AdapterTypeNotFoundException(adapterConfig.type);
        }
        if (response.getResponseCode() == 400) {
            throw new BadRequestException(response.getResponseMessage());
        }
    }

    public void delete(String adapterName) throws AdapterNotFoundException, IOException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(String.format("adapters/%s", adapterName));
        HttpResponse response = this.restClient.execute(HttpMethod.DELETE, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new AdapterNotFoundException(adapterName);
        }
    }

    public boolean exists(String adapterName) throws IOException, UnauthorizedException {
        URL url = this.config.resolveNamespacedURLV3(String.format("adapters/%s", adapterName));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        return response.getResponseCode() != 404;
    }

    public void waitForExists(final String adapterName, long timeout, TimeUnit timeoutUnit) throws IOException, UnauthorizedException, TimeoutException, InterruptedException {
        try {
            Tasks.waitFor((Object)true, (Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return AdapterClient.this.exists(adapterName);
                }
            }, (long)timeout, (TimeUnit)timeoutUnit, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), IOException.class, UnauthorizedException.class);
        }
    }

    public void waitForDeleted(final String adapterName, long timeout, TimeUnit timeoutUnit) throws IOException, UnauthorizedException, TimeoutException, InterruptedException {
        try {
            Tasks.waitFor((Object)false, (Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return AdapterClient.this.exists(adapterName);
                }
            }, (long)timeout, (TimeUnit)timeoutUnit, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), IOException.class, UnauthorizedException.class);
        }
    }
}

