/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.exception.NotFoundException;
import co.cask.cdap.client.exception.ProgramNotFoundException;
import co.cask.cdap.client.exception.UnAuthorizedAccessTokenException;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.proto.ProgramType;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.inject.Inject;
import java.io.IOException;
import java.net.URL;
import java.util.Map;

public class PreferencesClient {
    private static final Gson GSON = new Gson();
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public PreferencesClient(ClientConfig config) {
        this.config = new ClientConfig.Builder(config).setApiVersion("v3").build();
        this.restClient = RESTClient.create(config);
    }

    public Map<String, String> getInstancePreferences() throws IOException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL("configuration/preferences");
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), new int[0]);
        return (Map)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<Map<String, String>>(){}).getResponseObject();
    }

    public void setInstancePreferences(Map<String, String> preferences) throws IOException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL("configuration/preferences");
        HttpResponse response = this.restClient.execute(HttpMethod.PUT, url, GSON.toJson(preferences), null, this.config.getAccessToken(), new int[0]);
    }

    public void deleteInstancePreferences() throws IOException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL("configuration/preferences");
        this.restClient.execute(HttpMethod.DELETE, url, this.config.getAccessToken(), new int[0]);
    }

    public Map<String, String> getNamespacePreferences(String namespace, boolean resolved) throws IOException, UnAuthorizedAccessTokenException, NotFoundException {
        String res = Boolean.toString(resolved);
        URL url = this.config.resolveURL(String.format("configuration/preferences/namespaces/%s?resolved=%s", namespace, res));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException("namespace", namespace);
        }
        return (Map)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<Map<String, String>>(){}).getResponseObject();
    }

    public void setNamespacePreferences(String namespace, Map<String, String> preferences) throws IOException, UnAuthorizedAccessTokenException, NotFoundException {
        URL url = this.config.resolveURL(String.format("configuration/preferences/namespaces/%s", namespace));
        HttpResponse response = this.restClient.execute(HttpMethod.PUT, url, GSON.toJson(preferences), null, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException("namespace", namespace);
        }
    }

    public void deleteNamespacePreferences(String namespace) throws IOException, UnAuthorizedAccessTokenException, NotFoundException {
        URL url = this.config.resolveURL(String.format("configuration/preferences/namespaces/%s", namespace));
        HttpResponse response = this.restClient.execute(HttpMethod.DELETE, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException("namespace", namespace);
        }
    }

    public Map<String, String> getApplicationPreferences(String namespace, String application, boolean resolved) throws IOException, UnAuthorizedAccessTokenException, NotFoundException {
        String res = Boolean.toString(resolved);
        URL url = this.config.resolveURL(String.format("configuration/preferences/namespaces/%s/apps/%s?resolved=%s", namespace, application, res));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException("namespace or application", namespace + "/" + application);
        }
        return (Map)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<Map<String, String>>(){}).getResponseObject();
    }

    public void setApplicationPreferences(String namespace, String application, Map<String, String> preferences) throws IOException, UnAuthorizedAccessTokenException, NotFoundException {
        URL url = this.config.resolveURL(String.format("configuration/preferences/namespaces/%s/apps/%s", namespace, application));
        HttpResponse response = this.restClient.execute(HttpMethod.PUT, url, GSON.toJson(preferences), null, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException("namespace or application", namespace + "/" + application);
        }
    }

    public void deleteApplicationPreferences(String namespace, String application) throws IOException, UnAuthorizedAccessTokenException, NotFoundException {
        URL url = this.config.resolveURL(String.format("configuration/preferences/namespaces/%s/apps/%s", namespace, application));
        HttpResponse response = this.restClient.execute(HttpMethod.DELETE, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException("namespace or application", namespace + "/" + application);
        }
    }

    public Map<String, String> getProgramPreferences(String namespace, String application, String programType, String programId, boolean resolved) throws IOException, UnAuthorizedAccessTokenException, ProgramNotFoundException {
        String res = Boolean.toString(resolved);
        URL url = this.config.resolveURL(String.format("configuration/preferences/namespaces/%s/apps/%s/%s/%s?resolved=%s", namespace, application, programType, programId, res));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ProgramNotFoundException(ProgramType.valueOfCategoryName((String)programType), application, programId);
        }
        return (Map)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<Map<String, String>>(){}).getResponseObject();
    }

    public void setProgramPreferences(String namespace, String application, String programType, String programId, Map<String, String> preferences) throws IOException, UnAuthorizedAccessTokenException, ProgramNotFoundException {
        URL url = this.config.resolveURL(String.format("configuration/preferences/namespaces/%s/apps/%s/%s/%s", namespace, application, programType, programId));
        HttpResponse response = this.restClient.execute(HttpMethod.PUT, url, GSON.toJson(preferences), null, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ProgramNotFoundException(ProgramType.valueOfCategoryName((String)programType), application, programId);
        }
    }

    public void deleteProgramPreferences(String namespace, String application, String programType, String programId) throws IOException, UnAuthorizedAccessTokenException, ProgramNotFoundException {
        URL url = this.config.resolveURL(String.format("configuration/preferences/namespaces/%s/apps/%s/%s/%s", namespace, application, programType, programId));
        HttpResponse response = this.restClient.execute(HttpMethod.DELETE, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ProgramNotFoundException(ProgramType.valueOfCategoryName((String)programType), application, programId);
        }
    }
}

