/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.exception.AlreadyExistsException;
import co.cask.cdap.client.exception.BadRequestException;
import co.cask.cdap.client.exception.CannotBeDeletedException;
import co.cask.cdap.client.exception.NotFoundException;
import co.cask.cdap.client.exception.UnAuthorizedAccessTokenException;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.proto.NamespaceMeta;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpRequest;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.inject.Inject;

public class NamespaceClient {
    private static final String NAMESPACE_ENTITY_TYPE = "namespace";
    private static final Gson GSON = new Gson();
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public NamespaceClient(ClientConfig config) {
        this.config = config;
        this.restClient = RESTClient.create(this.config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NamespaceMeta> list() throws IOException, UnAuthorizedAccessTokenException {
        String origVersion = this.config.getApiVersion();
        try {
            this.config.setApiVersion("v3");
            HttpResponse response = this.restClient.execute(HttpMethod.GET, this.config.resolveURL("namespaces"), this.config.getAccessToken(), new int[0]);
            List list = (List)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<List<NamespaceMeta>>(){}).getResponseObject();
            return list;
        }
        finally {
            this.config.setApiVersion(origVersion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamespaceMeta get(String namespaceId) throws IOException, UnAuthorizedAccessTokenException, NotFoundException {
        String origVersion = this.config.getApiVersion();
        try {
            this.config.setApiVersion("v3");
            HttpResponse response = this.restClient.execute(HttpMethod.GET, this.config.resolveURL(String.format("namespaces/%s", namespaceId)), this.config.getAccessToken(), 404);
            if (404 == response.getResponseCode()) {
                throw new NotFoundException(NAMESPACE_ENTITY_TYPE, namespaceId);
            }
            NamespaceMeta namespaceMeta = (NamespaceMeta)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<NamespaceMeta>(){}).getResponseObject();
            return namespaceMeta;
        }
        finally {
            this.config.setApiVersion(origVersion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String namespaceId) throws IOException, UnAuthorizedAccessTokenException, NotFoundException, CannotBeDeletedException {
        String origVersion = this.config.getApiVersion();
        try {
            this.config.setApiVersion("v3");
            HttpResponse response = this.restClient.execute(HttpMethod.DELETE, this.config.resolveURL(String.format("namespaces/%s", namespaceId)), this.config.getAccessToken(), 404, 403);
            if (404 == response.getResponseCode()) {
                throw new NotFoundException(NAMESPACE_ENTITY_TYPE, namespaceId);
            }
            if (403 == response.getResponseCode()) {
                throw new CannotBeDeletedException(NAMESPACE_ENTITY_TYPE, namespaceId);
            }
        }
        finally {
            this.config.setApiVersion(origVersion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(NamespaceMeta namespaceMeta) throws IOException, UnAuthorizedAccessTokenException, AlreadyExistsException, BadRequestException {
        String origVersion = this.config.getApiVersion();
        try {
            this.config.setApiVersion("v3");
            URL url = this.config.resolveURL(String.format("namespaces/%s", namespaceMeta.getId()));
            NamespaceMeta.Builder builder = new NamespaceMeta.Builder();
            String name = namespaceMeta.getName();
            String description = namespaceMeta.getDescription();
            if (name != null) {
                builder.setName(name);
            }
            if (description != null) {
                builder.setDescription(description);
            }
            String body = GSON.toJson((Object)builder.build());
            HttpRequest request = HttpRequest.put((URL)url).withBody(body).build();
            HttpResponse response = this.restClient.upload(request, this.config.getAccessToken(), 400);
            String responseBody = response.getResponseBodyAsString();
            if (response.getResponseCode() == 400) {
                throw new BadRequestException("Bad request: " + responseBody);
            }
            if (responseBody != null && responseBody.equals(String.format("Namespace '%s' already exists.", namespaceMeta.getId()))) {
                throw new AlreadyExistsException(NAMESPACE_ENTITY_TYPE, namespaceMeta.getId());
            }
        }
        finally {
            this.config.setApiVersion(origVersion);
        }
    }
}

