/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.exception.ResetFailureException;
import co.cask.cdap.client.exception.ResetNotEnabledException;
import co.cask.cdap.client.exception.UnAuthorizedAccessTokenException;
import co.cask.cdap.client.exception.UnauthorizedException;
import co.cask.cdap.client.util.RESTClient;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpRequest;
import co.cask.common.http.HttpResponse;
import java.io.IOException;
import java.net.URL;
import javax.inject.Inject;

public class MetaClient {
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public MetaClient(ClientConfig config) {
        this.config = config;
        this.restClient = RESTClient.create(config);
    }

    public void resetUnrecoverably() throws ResetFailureException, UnauthorizedException, IOException, UnAuthorizedAccessTokenException, ResetNotEnabledException {
        URL url = this.config.resolveURL(String.format("unrecoverable/reset", new Object[0]));
        HttpRequest request = HttpRequest.post((URL)url).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 401, 400, 403);
        if (response.getResponseCode() == 401) {
            throw new UnauthorizedException();
        }
        if (response.getResponseCode() == 400) {
            throw new ResetFailureException(response.getResponseMessage());
        }
        if (response.getResponseCode() == 403) {
            throw new ResetNotEnabledException();
        }
    }

    public void ping() throws IOException, UnAuthorizedAccessTokenException {
        this.restClient.execute(HttpMethod.GET, this.config.resolveURL("ping"), this.config.getAccessToken(), new int[0]);
    }
}

