/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.exception.AlreadyExistsException;
import co.cask.cdap.client.exception.BadRequestException;
import co.cask.cdap.client.exception.DatasetModuleAlreadyExistsException;
import co.cask.cdap.client.exception.DatasetModuleCannotBeDeletedException;
import co.cask.cdap.client.exception.DatasetModuleNotFoundException;
import co.cask.cdap.client.exception.UnAuthorizedAccessTokenException;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.utils.Tasks;
import co.cask.cdap.proto.DatasetModuleMeta;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpRequest;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;

public class DatasetModuleClient {
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public DatasetModuleClient(ClientConfig config) {
        this.config = config;
        this.restClient = RESTClient.create(config);
    }

    public List<DatasetModuleMeta> list() throws IOException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL("data/modules");
        return (List)ObjectResponse.fromJsonBody((HttpResponse)this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), new int[0]), (TypeToken)new TypeToken<List<DatasetModuleMeta>>(){}).getResponseObject();
    }

    public void add(String moduleName, String className, File moduleJarFile) throws BadRequestException, AlreadyExistsException, IOException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("data/modules/%s", moduleName));
        ImmutableMap headers = ImmutableMap.of((Object)"X-Class-Name", (Object)className);
        HttpRequest request = HttpRequest.put((URL)url).addHeaders((Map)headers).withBody(moduleJarFile).build();
        HttpResponse response = this.restClient.upload(request, this.config.getAccessToken(), 400, 409);
        if (response.getResponseCode() == 400) {
            throw new BadRequestException(String.format("Module jar file does not exist: %s", moduleJarFile));
        }
        if (response.getResponseCode() == 409) {
            throw new DatasetModuleAlreadyExistsException(moduleName);
        }
    }

    public void delete(String moduleName) throws DatasetModuleCannotBeDeletedException, DatasetModuleNotFoundException, IOException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("data/modules/%s", moduleName));
        HttpResponse response = this.restClient.execute(HttpMethod.DELETE, url, this.config.getAccessToken(), 409, 404);
        if (response.getResponseCode() == 409) {
            throw new DatasetModuleCannotBeDeletedException(moduleName);
        }
        if (response.getResponseCode() == 404) {
            throw new DatasetModuleNotFoundException(moduleName);
        }
    }

    public boolean exists(String moduleName) throws IOException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("data/modules/%s", moduleName));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        return response.getResponseCode() != 404;
    }

    public void waitForExists(final String moduleName, long timeout, TimeUnit timeoutUnit) throws IOException, UnAuthorizedAccessTokenException, TimeoutException, InterruptedException {
        try {
            Tasks.waitFor((Object)true, (Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return DatasetModuleClient.this.exists(moduleName);
                }
            }, (long)timeout, (TimeUnit)timeoutUnit, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), IOException.class, UnAuthorizedAccessTokenException.class);
        }
    }

    public void waitForDeleted(final String moduleName, long timeout, TimeUnit timeoutUnit) throws IOException, UnAuthorizedAccessTokenException, TimeoutException, InterruptedException {
        try {
            Tasks.waitFor((Object)false, (Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return DatasetModuleClient.this.exists(moduleName);
                }
            }, (long)timeout, (TimeUnit)timeoutUnit, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), IOException.class, UnAuthorizedAccessTokenException.class);
        }
    }

    public void deleteAll() throws DatasetModuleCannotBeDeletedException, IOException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL("data/modules");
        HttpResponse response = this.restClient.execute(HttpMethod.DELETE, url, this.config.getAccessToken(), 409);
        if (response.getResponseCode() == 409) {
            throw new DatasetModuleCannotBeDeletedException(null);
        }
    }

    public DatasetModuleMeta get(String moduleName) throws DatasetModuleNotFoundException, IOException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("data/modules/%s", moduleName));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new DatasetModuleNotFoundException(moduleName);
        }
        return (DatasetModuleMeta)ObjectResponse.fromJsonBody((HttpResponse)response, DatasetModuleMeta.class).getResponseObject();
    }
}

